/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.VertexView;

public class VertexRenderer
extends JLabel
implements CellViewRenderer,
Serializable {
    protected transient VertexView view;
    protected transient boolean hasFocus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean childrenSelected;
    protected transient Color defaultForeground;
    protected transient Color defaultBackground;
    protected transient Color bordercolor;
    protected transient int borderWidth;
    protected transient boolean isDoubleBuffered = false;
    protected transient boolean labelEnabled;
    protected transient Color gradientColor = null;
    protected transient Color gridColor = Color.black;
    protected transient Color highlightColor = Color.black;
    protected transient Color lockedHandleColor = Color.black;

    public VertexRenderer() {
        this.defaultForeground = UIManager.getColor("Tree.textForeground");
        this.defaultBackground = UIManager.getColor("Tree.textBackground");
    }

    @Override
    public Component getRendererComponent(JGraph graph, CellView view, boolean sel, boolean focus, boolean preview) {
        this.gridColor = graph.getGridColor();
        this.highlightColor = graph.getHighlightColor();
        this.lockedHandleColor = graph.getLockedHandleColor();
        this.isDoubleBuffered = graph.isDoubleBuffered();
        if (view instanceof VertexView) {
            this.view = (VertexView)view;
            this.setComponentOrientation(graph.getComponentOrientation());
            if (graph.getEditingCell() != view.getCell()) {
                String label = graph.convertValueToString(view);
                if (label != null) {
                    this.setText(label.toString());
                } else {
                    this.setText(null);
                }
            } else {
                this.setText(null);
            }
            this.hasFocus = focus;
            this.childrenSelected = graph.getSelectionModel().isChildrenSelected(view.getCell());
            this.selected = sel;
            this.preview = preview;
            if (this.view.isLeaf() || GraphConstants.isGroupOpaque(view.getAllAttributes())) {
                this.installAttributes(view);
            } else {
                this.resetAttributes();
            }
            return this;
        }
        return null;
    }

    protected void resetAttributes() {
        this.setText(null);
        this.setBorder(null);
        this.setOpaque(false);
        this.setGradientColor(null);
        this.setIcon(null);
    }

    protected void installAttributes(CellView view) {
        Color foreground;
        AttributeMap map = view.getAllAttributes();
        this.setIcon(GraphConstants.getIcon(map));
        this.setOpaque(GraphConstants.isOpaque(map));
        this.setBorder(GraphConstants.getBorder(map));
        this.setVerticalAlignment(GraphConstants.getVerticalAlignment(map));
        this.setHorizontalAlignment(GraphConstants.getHorizontalAlignment(map));
        this.setVerticalTextPosition(GraphConstants.getVerticalTextPosition(map));
        this.setHorizontalTextPosition(GraphConstants.getHorizontalTextPosition(map));
        this.bordercolor = GraphConstants.getBorderColor(map);
        this.borderWidth = Math.max(1, Math.round(GraphConstants.getLineWidth(map)));
        if (this.getBorder() == null && this.bordercolor != null) {
            this.setBorder(BorderFactory.createLineBorder(this.bordercolor, this.borderWidth));
        }
        this.setForeground((foreground = GraphConstants.getForeground(map)) != null ? foreground : this.defaultForeground);
        Color gradientColor = GraphConstants.getGradientColor(map);
        this.setGradientColor(gradientColor);
        Color background = GraphConstants.getBackground(map);
        this.setBackground(background != null ? background : this.defaultBackground);
        this.setFont(GraphConstants.getFont(map));
        this.labelEnabled = GraphConstants.isLabelEnabled(map);
    }

    @Override
    public void paint(Graphics g) {
        try {
            if (this.gradientColor != null && !this.preview && this.isOpaque()) {
                this.setOpaque(false);
                Graphics2D g2d = (Graphics2D)g;
                g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.getBackground(), this.getWidth(), this.getHeight(), this.gradientColor, true));
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            super.paint(g);
            this.paintSelectionBorder(g);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void paintSelectionBorder(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Stroke previousStroke = g2.getStroke();
        g2.setStroke(GraphConstants.SELECTION_STROKE);
        if (this.childrenSelected || this.selected) {
            if (this.childrenSelected) {
                g.setColor(this.gridColor);
            } else if (this.hasFocus && this.selected) {
                g.setColor(this.lockedHandleColor);
            } else if (this.selected) {
                g.setColor(this.highlightColor);
            }
            Dimension d = this.getSize();
            g.drawRect(0, 0, d.width - 1, d.height - 1);
        }
        g2.setStroke(previousStroke);
    }

    public Point2D getPerimeterPoint(VertexView view, Point2D source, Point2D p) {
        Rectangle2D bounds = view.getBounds();
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        double xCenter = x + width / 2.0;
        double yCenter = y + height / 2.0;
        double dx = p.getX() - xCenter;
        double dy = p.getY() - yCenter;
        double alpha = Math.atan2(dy, dx);
        double xout = 0.0;
        double yout = 0.0;
        double pi = Math.PI;
        double pi2 = 1.5707963267948966;
        double beta = pi2 - alpha;
        double t = Math.atan2(height, width);
        if (alpha < -pi + t || alpha > pi - t) {
            xout = x;
            yout = yCenter - width * Math.tan(alpha) / 2.0;
        } else if (alpha < -t) {
            yout = y;
            xout = xCenter - height * Math.tan(beta) / 2.0;
        } else if (alpha < t) {
            xout = x + width;
            yout = yCenter + width * Math.tan(alpha) / 2.0;
        } else {
            yout = y + height;
            xout = xCenter + height * Math.tan(beta) / 2.0;
        }
        return new Point2D.Double(xout, yout);
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text") {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    public Color getGradientColor() {
        return this.gradientColor;
    }

    public void setGradientColor(Color gradientColor) {
        this.gradientColor = gradientColor;
    }
}

