/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.PortRenderer;

public class PortView
extends AbstractCellView {
    public static transient int SIZE = 6;
    public static transient PortRenderer renderer = new PortRenderer();
    public static boolean allowPortMagic = true;
    protected transient CellView lastParent;

    public PortView() {
    }

    public PortView(Object cell) {
        super(cell);
    }

    @Override
    public CellView getParentView() {
        CellView parent = super.getParentView();
        if (parent == null) {
            parent = this.lastParent;
        } else {
            this.lastParent = parent;
        }
        return parent;
    }

    @Override
    public Rectangle2D getBounds() {
        Point2D loc = this.getLocation();
        double x = 0.0;
        double y = 0.0;
        if (loc != null) {
            x = loc.getX();
            y = loc.getY();
        }
        Rectangle2D.Double bounds = new Rectangle2D.Double(x, y, 0.0, 0.0);
        bounds.setFrame(((RectangularShape)bounds).getX() - (double)(this.getPortSize() / 2), ((RectangularShape)bounds).getY() - (double)(this.getPortSize() / 2), this.getPortSize(), this.getPortSize());
        return bounds;
    }

    @Override
    public CellViewRenderer getRenderer() {
        return renderer;
    }

    @Override
    public CellHandle getHandle(GraphContext context) {
        return null;
    }

    public Point2D getLocation() {
        return this.getLocation(null, null);
    }

    public Point2D getLocation(EdgeView edge) {
        return this.getLocation(edge, null);
    }

    public Point2D getLocation(EdgeView edge, Point2D nearest) {
        CellView vertex = this.getParentView();
        Point2D pos = null;
        if (vertex != null) {
            PortView anchor = null;
            Point2D offset = GraphConstants.getOffset(this.allAttributes);
            if (edge == null && offset == null) {
                pos = PortView.getCenterPoint(vertex);
            }
            if (offset != null) {
                double x = offset.getX();
                double y = offset.getY();
                Rectangle2D r = vertex.getBounds();
                boolean isAbsoluteX = GraphConstants.isAbsoluteX(this.allAttributes);
                boolean isAbsoluteY = GraphConstants.isAbsoluteY(this.allAttributes);
                if (!isAbsoluteX) {
                    x = x * (r.getWidth() - 1.0) / 1000.0;
                }
                if (!isAbsoluteY) {
                    y = y * (r.getHeight() - 1.0) / 1000.0;
                }
                pos = anchor != null ? anchor.getLocation(edge, nearest) : new Point2D.Double(r.getX(), r.getY());
                pos = new Point2D.Double(pos.getX() + x, pos.getY() + y);
            } else if (edge != null) {
                if (nearest == null) {
                    return PortView.getCenterPoint(vertex);
                }
                pos = vertex.getPerimeterPoint(edge, pos, nearest);
                if (this.shouldInvokePortMagic(edge) && nearest != null) {
                    Rectangle2D r = vertex.getBounds();
                    if (nearest.getX() >= r.getX() && nearest.getX() <= r.getX() + r.getWidth()) {
                        pos.setLocation(nearest.getX(), pos.getY());
                    } else if (nearest.getY() >= r.getY() && nearest.getY() <= r.getY() + r.getHeight()) {
                        pos.setLocation(pos.getX(), nearest.getY());
                    }
                    if (nearest.getX() < r.getX()) {
                        pos.setLocation(r.getX(), pos.getY());
                    } else if (nearest.getX() > r.getX() + r.getWidth()) {
                        pos.setLocation(r.getX() + r.getWidth(), pos.getY());
                    }
                    if (nearest.getY() < r.getY()) {
                        pos.setLocation(pos.getX(), r.getY());
                    } else if (nearest.getY() > r.getY() + r.getHeight()) {
                        pos.setLocation(pos.getX(), r.getY() + r.getHeight());
                    }
                }
            }
        }
        return pos;
    }

    protected boolean shouldInvokePortMagic(EdgeView edge) {
        return allowPortMagic && !(this.getParentView() instanceof EdgeView) && edge.getPointCount() > 2 && GraphConstants.getLineStyle(edge.getAllAttributes()) == 11;
    }

    public int getPortSize() {
        return SIZE;
    }

    public void setPortSize(int size) {
        SIZE = size;
    }
}

