/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.GraphTransferable;
import org.jgraph.graph.ParentMap;

public class GraphTransferHandler
extends TransferHandler {
    protected boolean alwaysReceiveAsCopyAction = false;
    protected Object out;
    protected Object in;
    protected int inCount = 0;

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] flavors) {
        for (int i = 0; i < flavors.length; ++i) {
            if (flavors[i] != GraphTransferable.dataFlavor) continue;
            return true;
        }
        return false;
    }

    public Transferable createTransferableForGraph(JGraph graph) {
        return this.createTransferable(graph);
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        JGraph graph;
        if (c instanceof JGraph && !(graph = (JGraph)c).isSelectionEmpty()) {
            return this.createTransferable(graph, graph.getSelectionCells());
        }
        return null;
    }

    protected Transferable createTransferable(JGraph graph, Object[] cells) {
        Object[] flat = graph.getDescendants(graph.order(cells));
        ParentMap pm = ParentMap.create(graph.getModel(), flat, false, true);
        ConnectionSet cs = ConnectionSet.create(graph.getModel(), flat, false);
        Map viewAttributes = GraphConstants.createAttributes(flat, graph.getGraphLayoutCache());
        Rectangle2D bounds = graph.getCellBounds(graph.getSelectionCells());
        bounds = new AttributeMap.SerializableRectangle2D(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        this.out = flat;
        return this.create(graph, flat, viewAttributes, bounds, cs, pm);
    }

    protected GraphTransferable create(JGraph graph, Object[] cells, Map viewAttributes, Rectangle2D bounds, ConnectionSet cs, ParentMap pm) {
        return new GraphTransferable(cells, viewAttributes, bounds, cs, pm);
    }

    @Override
    protected void exportDone(JComponent comp, Transferable data, int action) {
        if (comp instanceof JGraph && data instanceof GraphTransferable) {
            JGraph graph = (JGraph)comp;
            if (action == 2) {
                Object[] cells = ((GraphTransferable)data).getCells();
                graph.getGraphLayoutCache().remove(cells);
            }
            graph.getUI().updateHandle();
            graph.getUI().setInsertionLocation(null);
        }
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        try {
            if (comp instanceof JGraph) {
                JGraph graph = (JGraph)comp;
                GraphModel model = graph.getModel();
                GraphLayoutCache cache = graph.getGraphLayoutCache();
                if (t.isDataFlavorSupported(GraphTransferable.dataFlavor) && graph.isEnabled()) {
                    Point p = graph.getUI().getInsertionLocation();
                    Object obj = t.getTransferData(GraphTransferable.dataFlavor);
                    GraphTransferable gt = (GraphTransferable)obj;
                    Object[] cells = gt.getCells();
                    boolean allInModel = true;
                    for (int i = 0; i < cells.length && allInModel; ++i) {
                        allInModel = allInModel && model.contains(cells[i]);
                    }
                    this.inCount = this.in == cells ? ++this.inCount : (allInModel ? 1 : 0);
                    this.in = cells;
                    if (p != null && this.in == this.out && graph.getUI().getHandle() != null) {
                        int mod = graph.getUI().getDropAction() == 1 ? 2 : 0;
                        graph.getUI().getHandle().mouseReleased(new MouseEvent(comp, 0, 0L, mod, p.x, p.y, 1, false));
                        return false;
                    }
                    Rectangle2D bounds = gt.getBounds();
                    Hashtable nested = gt.getAttributeMap();
                    ConnectionSet cs = gt.getConnectionSet();
                    ParentMap pm = gt.getParentMap();
                    if (!allInModel || p == null || this.alwaysReceiveAsCopyAction || graph.getUI().getDropAction() == 1) {
                        double dx = 0.0;
                        double dy = 0.0;
                        if (nested != null) {
                            if (p != null && bounds != null) {
                                Point2D insert = graph.fromScreen(graph.snap((Point2D)p.clone()));
                                dx = insert.getX() - bounds.getX();
                                dy = insert.getY() - bounds.getY();
                            } else {
                                Point2D insertPoint = this.getInsertionOffset(graph, this.inCount, bounds);
                                if (insertPoint != null) {
                                    dx = insertPoint.getX();
                                    dy = insertPoint.getY();
                                }
                            }
                        }
                        this.handleExternalDrop(graph, cells, nested, cs, pm, dx, dy);
                        return graph.getUI().getDropAction() == 2 && !allInModel;
                    }
                    if (p != null) {
                        Point2D insert = graph.fromScreen(graph.snap(new Point(p)));
                        if (bounds != null && nested != null) {
                            double dx = insert.getX() - bounds.getX();
                            double dy = insert.getY() - bounds.getY();
                            AttributeMap.translate(nested.values(), dx, dy);
                        } else if (bounds == null) {
                            double gs2 = 2.0 * graph.getGridSize();
                            nested = new Hashtable();
                            Hashtable emptyMap = new Hashtable();
                            for (int i = 0; i < cells.length; ++i) {
                                if (!model.isEdge(cells[i]) && !model.isPort(cells[i])) {
                                    Rectangle2D tmp = graph.getCellBounds(cells[i]);
                                    if (tmp == null) {
                                        tmp = GraphConstants.getBounds(model.getAttributes(cells[i]));
                                    }
                                    if (tmp != null) {
                                        tmp = (Rectangle2D)tmp.clone();
                                    }
                                    Hashtable attrs = new Hashtable();
                                    Object parent = model.getParent(cells[i]);
                                    if (tmp == null) {
                                        tmp = new Rectangle2D.Double(p.getX(), p.getY(), gs2 / 2.0, gs2);
                                        GraphConstants.setResize(attrs, true);
                                        p.setLocation(p.getX() + gs2, p.getY() + gs2);
                                        graph.snap(p);
                                    } else if (parent == null || !nested.keySet().contains(model.getParent(cells[i]))) {
                                        CellView view = graph.getGraphLayoutCache().getMapping(cells[i], false);
                                        if (view != null && !view.isLeaf()) {
                                            double dx = p.getX() - tmp.getX();
                                            double dy = p.getY() - tmp.getY();
                                            GraphLayoutCache.translateViews(new CellView[]{view}, dx, dy);
                                        } else {
                                            tmp.setFrame(p.getX(), p.getY(), tmp.getWidth(), tmp.getHeight());
                                        }
                                        p.setLocation(p.getX() + gs2, p.getY() + gs2);
                                        graph.snap(p);
                                    }
                                    GraphConstants.setBounds(attrs, tmp);
                                    nested.put(cells[i], attrs);
                                    continue;
                                }
                                nested.put(cells[i], emptyMap);
                            }
                        }
                        cache.edit(nested, null, null, null);
                    }
                    graph.setSelectionCells(DefaultGraphModel.getTopmostCells(model, cells));
                    return false;
                }
                return this.importDataImpl(comp, t);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    protected Point2D getInsertionOffset(JGraph graph, int inCount, Rectangle2D bounds) {
        Point2D.Double result = null;
        if (graph != null) {
            result = new Point2D.Double((double)inCount * graph.getGridSize(), (double)inCount * graph.getGridSize());
        }
        return result;
    }

    protected void handleExternalDrop(JGraph graph, Object[] cells, Map nested, ConnectionSet cs, ParentMap pm, double dx, double dy) {
        Iterator it = cs.connections();
        while (it.hasNext()) {
            ConnectionSet.Connection conn = (ConnectionSet.Connection)it.next();
            if (pm.getChangedNodes().contains(conn.getPort()) || graph.getModel().contains(conn.getPort())) continue;
            it.remove();
        }
        Map clones = graph.cloneCells(cells);
        graph.getGraphLayoutCache().insertClones(cells, clones, nested, cs, pm, dx, dy);
    }

    protected boolean importDataImpl(JComponent comp, Transferable t) {
        return false;
    }

    public boolean isAlwaysReceiveAsCopyAction() {
        return this.alwaysReceiveAsCopyAction;
    }

    public void setAlwaysReceiveAsCopyAction(boolean alwaysReceiveAsCopyAction) {
        this.alwaysReceiveAsCopyAction = alwaysReceiveAsCopyAction;
    }
}

