/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;

public class GraphContext
implements CellMapper {
    public static boolean PREVIEW_EDGE_GROUPS = false;
    protected JGraph graph;
    protected transient GraphLayoutCache graphLayoutCache;
    protected Object[] cells;
    protected Set allCells;
    protected Set cellSet;
    protected int cellCount;
    protected Map views = new Hashtable();

    public GraphContext(JGraph graph, Object[] cells) {
        GraphModel model = graph.getModel();
        this.allCells = new HashSet(DefaultGraphModel.getDescendants(model, cells));
        this.graphLayoutCache = graph.getGraphLayoutCache();
        this.graph = graph;
        this.cells = cells;
        this.cellSet = new HashSet();
        for (Object cell : this.allCells) {
            if (!this.graphLayoutCache.isVisible(cell)) continue;
            this.cellSet.add(cell);
            if (model.isPort(cell)) continue;
            ++this.cellCount;
        }
    }

    public boolean isEmpty() {
        return this.cells == null || this.cells.length == 0;
    }

    public int getDescendantCount() {
        return this.cellCount;
    }

    public JGraph getGraph() {
        return this.graph;
    }

    public Object[] getCells() {
        return this.cells;
    }

    public boolean contains(Object node) {
        return this.cellSet.contains(node);
    }

    public CellView[] createTemporaryCellViews() {
        CellView[] cellViews = new CellView[this.cells.length];
        for (int i = 0; i < this.cells.length; ++i) {
            cellViews[i] = this.getMapping(this.cells[i], true);
        }
        return cellViews;
    }

    public CellView[] createTemporaryPortViews() {
        GraphModel model = this.graph.getModel();
        ArrayList<CellView> result = new ArrayList<CellView>();
        for (Object cand : this.allCells) {
            if (!model.isPort(cand) || !this.graph.getGraphLayoutCache().isVisible(cand)) continue;
            result.add(this.getMapping(cand, true));
        }
        CellView[] array = new CellView[result.size()];
        result.toArray(array);
        return array;
    }

    public CellView[] createTemporaryContextViews() {
        return this.createTemporaryContextViews(this.cellSet);
    }

    public CellView[] createTemporaryContextViews(Set cellSet) {
        Object[] cells = cellSet.toArray();
        ArrayList<CellView> result = new ArrayList<CellView>();
        Set delta = DefaultGraphModel.getEdges(this.graph.getModel(), cells);
        do {
            for (Object obj : delta) {
                CellView edge = this.graphLayoutCache.getMapping(obj, false);
                if (cellSet.contains(obj) || !this.graphLayoutCache.isVisible(obj) || edge == null || !PREVIEW_EDGE_GROUPS && !edge.isLeaf()) continue;
                CellView preview = this.createMapping(obj);
                result.add(preview);
                CellView[] children = preview.getChildViews();
                for (int i = 0; i < children.length; ++i) {
                    children[i] = this.createMapping(children[i].getCell());
                }
                preview.refresh(this.graph.getGraphLayoutCache(), this, false);
            }
        } while (!(delta = DefaultGraphModel.getEdges(this.graph.getModel(), delta.toArray())).isEmpty());
        CellView[] array = new CellView[result.size()];
        result.toArray(array);
        return array;
    }

    @Override
    public CellView getMapping(Object cell, boolean create) {
        if (cell != null) {
            CellView view = (CellView)this.views.get(cell);
            if (view != null) {
                return view;
            }
            if (this.contains(cell) || this.graph.getModel().isPort(cell) && create && this.graph.getGraphLayoutCache().isVisible(cell)) {
                return this.createMapping(cell);
            }
            return this.graphLayoutCache.getMapping(cell, false);
        }
        return null;
    }

    public CellView createMapping(Object cell) {
        CellView view = this.graphLayoutCache.getFactory().createView(this.graph.getModel(), cell);
        this.putMapping(cell, view);
        view.refresh(this.graph.getGraphLayoutCache(), this, true);
        CellView src = this.graphLayoutCache.getMapping(cell, false);
        if (src != null) {
            view.changeAttributes(this.graphLayoutCache, (AttributeMap)src.getAttributes().clone());
            view.refresh(this.graph.getGraphLayoutCache(), this, false);
        }
        return view;
    }

    public ConnectionSet disconnect(CellView[] cells) {
        ConnectionSet cs = new ConnectionSet();
        for (int i = 0; i < cells.length; ++i) {
            if (!(cells[i] instanceof EdgeView)) continue;
            EdgeView view = (EdgeView)cells[i];
            CellView port = view.getSource();
            if (!GraphConstants.isDisconnectable(view.getAllAttributes())) continue;
            if (port != null && GraphConstants.isDisconnectable(port.getParentView().getAllAttributes()) && !this.contains(port.getCell())) {
                view.setSource(null);
                cs.disconnect(view.getCell(), true);
            }
            if ((port = view.getTarget()) == null || !GraphConstants.isDisconnectable(port.getParentView().getAllAttributes()) || this.contains(port.getCell())) continue;
            view.setTarget(null);
            cs.disconnect(view.getCell(), false);
        }
        return cs;
    }

    @Override
    public void putMapping(Object cell, CellView view) {
        this.views.put(cell, view);
    }
}

