/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.Edge;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.util.Bezier;
import org.jgraph.util.Spline2D;

public class EdgeRenderer
extends JComponent
implements CellViewRenderer,
Serializable {
    public static boolean HIT_LABEL_EXACT = false;
    protected static transient Graphics fontGraphics;
    public static double LABELWIDTHBUFFER;
    public boolean simpleExtraLabels = true;
    public Font extraLabelFont = null;
    protected transient FontMetrics metrics;
    protected transient WeakReference graph;
    protected transient EdgeView view;
    protected transient int beginDeco;
    protected transient int endDeco;
    protected transient int beginSize;
    protected transient int endSize;
    protected transient int lineStyle;
    protected transient float lineWidth;
    protected transient boolean labelsEnabled;
    protected transient boolean labelBorder;
    protected transient boolean beginFill;
    protected transient boolean endFill;
    protected transient boolean focus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean opaque;
    protected transient boolean childrenSelected;
    protected transient boolean labelTransformEnabled;
    protected transient boolean isMoveBelowZero;
    protected transient Color borderColor;
    protected transient Color defaultForeground = UIManager.getColor("Tree.textForeground");
    protected transient Color defaultBackground = UIManager.getColor("Tree.textBackground");
    protected transient Color fontColor;
    protected transient float[] lineDash;
    protected transient float dashOffset = 0.0f;
    protected transient Color gradientColor = null;
    protected transient Color gridColor = null;
    protected transient Color lockedHandleColor = null;
    protected transient Color highlightColor = null;
    protected transient Bezier bezier;
    protected transient Spline2D spline;

    void setView(CellView value) {
        if (value instanceof EdgeView) {
            this.view = (EdgeView)value;
            this.installAttributes(this.view);
        } else {
            this.view = null;
        }
    }

    @Override
    public Component getRendererComponent(JGraph graph, CellView view, boolean sel, boolean focus, boolean preview) {
        if (view instanceof EdgeView && graph != null) {
            this.gridColor = graph.getGridColor();
            this.lockedHandleColor = graph.getLockedHandleColor();
            this.highlightColor = graph.getHighlightColor();
            this.isMoveBelowZero = graph.isMoveBelowZero();
            this.graph = new WeakReference<JGraph>(graph);
            this.focus = focus;
            this.selected = sel;
            this.preview = preview;
            this.childrenSelected = graph.getSelectionModel().isChildrenSelected(view.getCell());
            this.setView(view);
            return this;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean intersects(JGraph graph, CellView value, Rectangle rect) {
        if (value instanceof EdgeView && graph != null && value != null) {
            Object[] labels;
            Rectangle2D r;
            this.setView(value);
            Graphics2D g2 = (Graphics2D)graph.getGraphics();
            EdgeView edgeView = (EdgeView)value;
            if (g2 == null || edgeView.getPointCount() == 2) {
                Point2D p0 = edgeView.getPoint(0);
                Point2D p1 = edgeView.getPoint(1);
                if (rect.intersectsLine(p0.getX(), p0.getY(), p1.getX(), p1.getY())) {
                    return true;
                }
            } else if (g2 != null && g2.hit(rect, this.view.getShape(), true)) {
                return true;
            }
            if ((r = this.getLabelBounds(graph, this.view)) != null && r.intersects(rect)) {
                boolean hits = true;
                if (HIT_LABEL_EXACT) {
                    AffineTransform tx = g2.getTransform();
                    try {
                        String lab = graph.convertValueToString(this.view);
                        Point2D tmpPt = this.getLabelPosition(this.view);
                        Dimension size = this.getLabelSize(this.view, lab);
                        Rectangle tmp = new Rectangle((int)tmpPt.getX(), (int)tmpPt.getY(), size.width, size.height);
                        double cx = tmp.getCenterX();
                        double cy = tmp.getCenterY();
                        g2.translate((double)(-size.width / 2), (double)(-size.height) * 0.75 - (double)this.metrics.getDescent());
                        boolean applyTransform = this.isLabelTransform(lab);
                        double angle = 0.0;
                        if (applyTransform) {
                            angle = this.getLabelAngle(lab);
                            g2.rotate(angle, cx, cy);
                        }
                        hits = g2.hit(rect, tmp, false);
                    }
                    finally {
                        g2.setTransform(tx);
                    }
                }
                if (hits) {
                    return true;
                }
            }
            if ((labels = GraphConstants.getExtraLabels(this.view.getAllAttributes())) != null) {
                for (int i = 0; i < labels.length; ++i) {
                    r = this.getExtraLabelBounds(graph, this.view, i);
                    if (r == null || !r.intersects(rect)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Rectangle2D getBounds(CellView value) {
        if (value instanceof EdgeView && value != null) {
            Object[] labels;
            Rectangle2D rect;
            this.view = (EdgeView)value;
            Rectangle2D r = this.getPaintBounds(this.view);
            JGraph graph = null;
            if (this.graph != null) {
                graph = (JGraph)this.graph.get();
            }
            if ((rect = this.getLabelBounds(graph, this.view)) != null) {
                Rectangle2D.union(r, rect, r);
            }
            if ((labels = GraphConstants.getExtraLabels(this.view.getAllAttributes())) != null) {
                for (int i = 0; i < labels.length; ++i) {
                    rect = this.getExtraLabelBounds(graph, this.view, i);
                    if (rect == null) continue;
                    Rectangle2D.union(r, rect, r);
                }
            }
            int b = (int)Math.ceil(this.lineWidth);
            r.setFrame(r.getX() - (double)b, r.getY() - (double)b, r.getWidth() + (double)(2 * b), r.getHeight() + (double)(2 * b));
            return r;
        }
        return null;
    }

    private boolean isLabelTransformEnabled() {
        return this.labelTransformEnabled;
    }

    private boolean isLabelTransform(String label) {
        if (!this.isLabelTransformEnabled()) {
            return false;
        }
        Point2D p = this.getLabelPosition(this.view);
        if (p != null && label != null && label.length() > 0) {
            int sw = this.metrics.stringWidth(label);
            Point2D p1 = this.view.getPoint(0);
            Point2D p2 = this.view.getPoint(this.view.getPointCount() - 1);
            double length = Math.sqrt((p2.getX() - p1.getX()) * (p2.getX() - p1.getX()) + (p2.getY() - p1.getY()) * (p2.getY() - p1.getY()));
            if (!(length <= Double.NaN) && !(length < (double)sw)) {
                return true;
            }
        }
        return false;
    }

    private double getLabelAngle(String label) {
        Point2D p = this.getLabelPosition(this.view);
        double angle = 0.0;
        if (p != null && label != null && label.length() > 0) {
            int sw = this.metrics.stringWidth(label);
            Point2D p1 = this.view.getPoint(0);
            Point2D p2 = this.view.getPoint(this.view.getPointCount() - 1);
            double length = Math.sqrt((p2.getX() - p1.getX()) * (p2.getX() - p1.getX()) + (p2.getY() - p1.getY()) * (p2.getY() - p1.getY()));
            if (!(length <= Double.NaN) && !(length < (double)sw)) {
                double cos = (p2.getX() - p1.getX()) / length;
                double sin = (p2.getY() - p1.getY()) / length;
                angle = Math.acos(cos);
                if (sin < 0.0) {
                    angle = Math.PI * 2 - angle;
                }
            }
            if (angle > 1.5707963267948966 && angle <= 4.71238898038469) {
                angle -= Math.PI;
            }
        }
        return angle;
    }

    public Rectangle2D getLabelBounds(JGraph paintingContext, EdgeView view) {
        String label;
        if (paintingContext == null && this.graph != null) {
            JGraph graph;
            paintingContext = graph = (JGraph)this.graph.get();
        }
        String string = label = paintingContext != null ? paintingContext.convertValueToString(view) : String.valueOf(view.getCell());
        if (label != null) {
            Point2D p = this.getLabelPosition(view);
            Dimension d = this.getLabelSize(view, label);
            return this.getLabelBounds(p, d, label);
        }
        return null;
    }

    public Rectangle2D getExtraLabelBounds(JGraph paintingContext, EdgeView view, int index) {
        if (paintingContext == null && this.graph != null) {
            JGraph graph;
            paintingContext = graph = (JGraph)this.graph.get();
        }
        this.setView(view);
        Object[] labels = GraphConstants.getExtraLabels(view.getAllAttributes());
        if (labels != null && index < labels.length) {
            Point2D p = this.getExtraLabelPosition(this.view, index);
            Dimension d = this.getExtraLabelSize(paintingContext, this.view, index);
            String label = paintingContext != null ? paintingContext.convertValueToString(labels[index]) : String.valueOf(labels[index]);
            return this.getLabelBounds(p, d, label);
        }
        return new Rectangle2D.Double(this.getX(), this.getY(), 0.0, 0.0);
    }

    public Rectangle2D getLabelBounds(Point2D p, Dimension d, String label) {
        if (label != null && this.isLabelTransform(label)) {
            double angle = this.getLabelAngle(label);
            if (angle < 0.0) {
                angle = -angle;
            }
            if (angle > 1.5707963267948966) {
                angle %= 1.5707963267948966;
            }
            double yside = Math.abs(Math.cos(angle) * (double)d.height + Math.sin(angle) * (double)d.width);
            double xside = Math.abs((double)d.width * Math.cos(angle) + (double)d.height * Math.sin(angle));
            if (xside > yside) {
                yside = xside;
            }
            if (yside > xside) {
                xside = yside;
            }
            angle = this.getLabelAngle(label);
            d.width = (int)xside + d.height;
            d.height = (int)yside + d.height;
        }
        if (p != null && d != null) {
            double x = Math.max(0.0, p.getX() - (double)(d.width / 2));
            double y = Math.max(0.0, p.getY() - (double)(d.height / 2));
            return new Rectangle2D.Double(x, y, d.width + 1, d.height + 1);
        }
        return null;
    }

    public Point2D getLabelPosition(EdgeView view) {
        this.setView(view);
        return this.getLabelPosition(view.getLabelPosition());
    }

    public Point2D getExtraLabelPosition(EdgeView view, int index) {
        this.setView(view);
        Point2D[] pts = GraphConstants.getExtraLabelPositions(view.getAllAttributes());
        if (pts != null && index < pts.length) {
            return this.getLabelPosition(pts[index]);
        }
        return null;
    }

    protected Point2D getLabelPosition(Point2D pos) {
        Rectangle2D tmp = this.getPaintBounds(this.view);
        int unit = 1000;
        Point2D p0 = this.view.getPoint(0);
        if (pos != null && tmp != null && p0 != null) {
            double dy;
            if (!this.isLabelTransformEnabled()) {
                return this.view.getAbsoluteLabelPositionFromRelative(pos);
            }
            Point2D vector = this.view.getLabelVector();
            double dx = vector.getX();
            double len = Math.sqrt(dx * dx + (dy = vector.getY()) * dy);
            if (len > 0.0) {
                int pointIndex = this.view.getFirstPointOfSegment();
                if (pointIndex >= 0 && pointIndex < this.view.getPointCount() - 1) {
                    p0 = this.view.getPoint(pointIndex);
                }
                double x = p0.getX() + dx * pos.getX() / (double)unit;
                double y = p0.getY() + dy * pos.getX() / (double)unit;
                return new Point2D.Double(x += -dy * pos.getY() / len, y += dx * pos.getY() / len);
            }
            return new Point2D.Double(p0.getX() + pos.getX(), p0.getY() + pos.getY());
        }
        return null;
    }

    public Dimension getExtraLabelSize(JGraph paintingContext, EdgeView view, int index) {
        Object[] labels = GraphConstants.getExtraLabels(view.getAllAttributes());
        if (labels != null && index < labels.length) {
            String label = paintingContext != null ? paintingContext.convertValueToString(labels[index]) : String.valueOf(labels[index]);
            return this.getLabelSize(view, label);
        }
        return null;
    }

    public Dimension getLabelSize(EdgeView view, String label) {
        if (label != null && fontGraphics != null) {
            fontGraphics.setFont(GraphConstants.getFont(view.getAllAttributes()));
            this.metrics = fontGraphics.getFontMetrics();
            int sw = (int)((double)this.metrics.stringWidth(label) * LABELWIDTHBUFFER);
            int sh = this.metrics.getHeight();
            return new Dimension(sw, sh);
        }
        return null;
    }

    protected void installAttributes(CellView view) {
        AttributeMap map = view.getAllAttributes();
        this.beginDeco = GraphConstants.getLineBegin(map);
        this.beginSize = GraphConstants.getBeginSize(map);
        this.beginFill = GraphConstants.isBeginFill(map) && this.isFillable(this.beginDeco);
        this.endDeco = GraphConstants.getLineEnd(map);
        this.endSize = GraphConstants.getEndSize(map);
        this.endFill = GraphConstants.isEndFill(map) && this.isFillable(this.endDeco);
        this.lineWidth = GraphConstants.getLineWidth(map);
        Edge.Routing routing = GraphConstants.getRouting(map);
        int n = this.lineStyle = routing != null && view instanceof EdgeView ? routing.getPreferredLineStyle((EdgeView)view) : -1;
        if (this.lineStyle == -1) {
            this.lineStyle = GraphConstants.getLineStyle(map);
        }
        this.lineDash = GraphConstants.getDashPattern(map);
        this.dashOffset = GraphConstants.getDashOffset(map);
        this.borderColor = GraphConstants.getBorderColor(map);
        Color foreground = GraphConstants.getLineColor(map);
        this.setForeground(foreground != null ? foreground : this.defaultForeground);
        Color background = GraphConstants.getBackground(map);
        this.setBackground(background != null ? background : this.defaultBackground);
        Color gradientColor = GraphConstants.getGradientColor(map);
        this.setGradientColor(gradientColor);
        this.setOpaque(GraphConstants.isOpaque(map));
        this.setFont(GraphConstants.getFont(map));
        Color tmp = GraphConstants.getForeground(map);
        this.fontColor = tmp != null ? tmp : this.getForeground();
        this.labelTransformEnabled = GraphConstants.isLabelAlongEdge(map);
        this.labelsEnabled = GraphConstants.isLabelEnabled(map);
    }

    protected boolean isFillable(int decoration) {
        return decoration != 4 && decoration != 7 && decoration != 8;
    }

    public Rectangle2D getPaintBounds(EdgeView view) {
        Rectangle2D rec = null;
        this.setView(view);
        rec = view.getShape() != null ? view.getShape().getBounds() : new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        return rec;
    }

    @Override
    public void paint(Graphics g) {
        if (this.view.isLeaf()) {
            Shape edgeShape = this.view.getShape();
            if (edgeShape != null) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                this.setOpaque(false);
                super.paint(g);
                this.translateGraphics(g);
                this.beforeEdgePaint(g);
                this.paintEdge(g);
                this.paintSelection(g);
                this.paintLabels(g);
                this.afterEdgePaint(g);
            }
        } else {
            this.paintSelectionBorder(g);
        }
    }

    protected void paintLabels(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(1.0f));
        g.setFont(this.extraLabelFont != null ? this.extraLabelFont : this.getFont());
        Object[] labels = GraphConstants.getExtraLabels(this.view.getAllAttributes());
        JGraph graph = (JGraph)this.graph.get();
        if (labels != null) {
            for (int i = 0; i < labels.length; ++i) {
                this.paintLabel(g, graph.convertValueToString(labels[i]), this.getExtraLabelPosition(this.view, i), !this.simpleExtraLabels);
            }
        }
        if (graph.getEditingCell() != this.view.getCell()) {
            g.setFont(this.getFont());
            String label = graph.convertValueToString(this.view);
            if (label != null) {
                this.paintLabel(g, label.toString(), this.getLabelPosition(this.view), true);
            }
        }
    }

    protected void paintEdge(Graphics g) {
        g.setColor(this.getForeground());
        if (this.lineWidth > 0.0f) {
            Graphics2D g2 = (Graphics2D)g;
            int c = 0;
            int j = 0;
            g2.setStroke(new BasicStroke(this.lineWidth, c, j));
            if (this.gradientColor != null && !this.preview) {
                g2.setPaint(new GradientPaint(0.0f, 0.0f, this.getBackground(), this.getWidth(), this.getHeight(), this.gradientColor, true));
            }
            if (this.view.beginShape != null) {
                if (this.beginFill) {
                    g2.fill(this.view.beginShape);
                }
                g2.draw(this.view.beginShape);
            }
            if (this.view.endShape != null) {
                if (this.endFill) {
                    g2.fill(this.view.endShape);
                }
                g2.draw(this.view.endShape);
            }
            if (this.lineDash != null) {
                g2.setStroke(new BasicStroke(this.lineWidth, c, j, 10.0f, this.lineDash, this.dashOffset));
            }
            if (this.view.lineShape != null) {
                g2.draw(this.view.lineShape);
            }
        }
    }

    protected void paintSelection(Graphics g) {
        if (this.selected) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(GraphConstants.SELECTION_STROKE);
            g2.setColor(this.highlightColor);
            if (this.view.beginShape != null) {
                g2.draw(this.view.beginShape);
            }
            if (this.view.lineShape != null) {
                g2.draw(this.view.lineShape);
            }
            if (this.view.endShape != null) {
                g2.draw(this.view.endShape);
            }
        }
    }

    protected void beforeEdgePaint(Graphics g) {
    }

    protected void afterEdgePaint(Graphics g) {
    }

    protected void paintSelectionBorder(Graphics g) {
        ((Graphics2D)g).setStroke(GraphConstants.SELECTION_STROKE);
        if (this.childrenSelected) {
            g.setColor(this.gridColor);
        } else if (this.focus && this.selected) {
            g.setColor(this.lockedHandleColor);
        } else if (this.selected) {
            g.setColor(this.highlightColor);
        }
        if (this.childrenSelected || this.selected) {
            Dimension d = this.getSize();
            g.drawRect(0, 0, d.width - 1, d.height - 1);
        }
    }

    protected void translateGraphics(Graphics g) {
        g.translate(-this.getX(), -this.getY());
    }

    protected void paintLabel(Graphics g, String label, Point2D p, boolean mainLabel) {
        if (this.labelsEnabled && p != null && label != null && label.length() > 0 && this.metrics != null) {
            int sw = this.metrics.stringWidth(label);
            int sh = this.metrics.getHeight();
            Graphics2D g2 = (Graphics2D)g;
            boolean applyTransform = this.isLabelTransform(label);
            double angle = 0.0;
            int dx = -sw / 2;
            int offset = this.isMoveBelowZero || applyTransform ? 0 : Math.min(0, (int)((double)dx + p.getX()));
            g2.translate(p.getX() - (double)offset, p.getY());
            if (applyTransform) {
                angle = this.getLabelAngle(label);
                g2.rotate(angle);
            }
            if (this.isOpaque() && mainLabel) {
                g.setColor(this.getBackground());
                g.fillRect(-sw / 2 - 1, -sh / 2 - 1, sw + 2, sh + 2);
            }
            if (this.borderColor != null && mainLabel) {
                g.setColor(this.borderColor);
                g.drawRect(-sw / 2 - 1, -sh / 2 - 1, sw + 2, sh + 2);
            }
            int dy = sh / 4;
            g.setColor(this.fontColor);
            if (applyTransform && this.borderColor == null && !this.isOpaque()) {
                dy = -this.metrics.getDescent();
            }
            g.drawString(label, dx, dy);
            if (applyTransform) {
                g2.rotate(-angle);
            }
            g2.translate(-p.getX() + (double)offset, -p.getY());
        }
    }

    protected Shape createShape() {
        int n = this.view.getPointCount();
        if (n > 1) {
            EdgeView tmp = this.view;
            Point2D[] p = null;
            p = new Point2D[n];
            for (int i = 0; i < n; ++i) {
                Point2D pt = tmp.getPoint(i);
                if (pt == null) {
                    return null;
                }
                p[i] = new Point2D.Double(pt.getX(), pt.getY());
            }
            if (this.view != tmp) {
                this.view = tmp;
                this.installAttributes(this.view);
            }
            if (this.view.sharedPath == null) {
                this.view.sharedPath = new GeneralPath(1, n);
            } else {
                this.view.sharedPath.reset();
            }
            this.view.endShape = null;
            this.view.lineShape = null;
            this.view.beginShape = null;
            Point2D p0 = p[0];
            Point2D pe = p[n - 1];
            Point2D p1 = p[1];
            Point2D p2 = p[n - 2];
            if (this.lineStyle == 12 && n > 2) {
                this.bezier = new Bezier(p);
                p2 = this.bezier.getPoint(this.bezier.getPointCount() - 1);
            } else if (this.lineStyle == 13 && n > 2) {
                this.spline = new Spline2D(p);
                double[] point = this.spline.getPoint(0.9875);
                double scaledX = pe.getX() - (pe.getX() - point[0]) * 128.0;
                double scaledY = pe.getY() - (pe.getY() - point[1]) * 128.0;
                p2.setLocation(scaledX, scaledY);
            }
            if (this.beginDeco != 0) {
                this.view.beginShape = this.createLineEnd(this.beginSize, this.beginDeco, p1, p0);
            }
            if (this.endDeco != 0) {
                this.view.endShape = this.createLineEnd(this.endSize, this.endDeco, p2, pe);
            }
            this.view.sharedPath.moveTo((float)p0.getX(), (float)p0.getY());
            if (this.lineStyle == 12 && n > 2) {
                Point2D[] b = this.bezier.getPoints();
                this.view.sharedPath.quadTo((float)b[0].getX(), (float)b[0].getY(), (float)p1.getX(), (float)p1.getY());
                for (int i = 2; i < n - 1; ++i) {
                    Point2D b0 = b[2 * i - 3];
                    Point2D b1 = b[2 * i - 2];
                    this.view.sharedPath.curveTo((float)b0.getX(), (float)b0.getY(), (float)b1.getX(), (float)b1.getY(), (float)p[i].getX(), (float)p[i].getY());
                }
                this.view.sharedPath.quadTo((float)b[b.length - 1].getX(), (float)b[b.length - 1].getY(), (float)p[n - 1].getX(), (float)p[n - 1].getY());
            } else if (this.lineStyle == 13 && n > 2) {
                for (double t = 0.0; t <= 1.0; t += 0.0125) {
                    double[] xy = this.spline.getPoint(t);
                    this.view.sharedPath.lineTo((float)xy[0], (float)xy[1]);
                }
            } else {
                for (int i = 1; i < n - 1; ++i) {
                    this.view.sharedPath.lineTo((float)p[i].getX(), (float)p[i].getY());
                }
                this.view.sharedPath.lineTo((float)pe.getX(), (float)pe.getY());
            }
            this.view.sharedPath.moveTo((float)pe.getX(), (float)pe.getY());
            if (this.view.endShape == null && this.view.beginShape == null) {
                this.view.lineShape = this.view.sharedPath;
            } else {
                this.view.lineShape = (GeneralPath)this.view.sharedPath.clone();
                if (this.view.endShape != null) {
                    this.view.sharedPath.append(this.view.endShape, true);
                }
                if (this.view.beginShape != null) {
                    this.view.sharedPath.append(this.view.beginShape, true);
                }
            }
            return this.view.sharedPath;
        }
        return null;
    }

    protected Shape createLineEnd(int size, int style, Point2D src, Point2D dst) {
        if (src == null || dst == null) {
            return null;
        }
        int d = (int)Math.max(1.0, dst.distance(src));
        int ax = (int)(-((double)size * (dst.getX() - src.getX()) / (double)d));
        int ay = (int)(-((double)size * (dst.getY() - src.getY()) / (double)d));
        if (style == 9) {
            Polygon poly = new Polygon();
            poly.addPoint((int)dst.getX(), (int)dst.getY());
            poly.addPoint((int)(dst.getX() + (double)(ax / 2) + (double)(ay / 3)), (int)(dst.getY() + (double)(ay / 2) - (double)(ax / 3)));
            Point2D last = (Point2D)dst.clone();
            dst.setLocation(dst.getX() + (double)ax, dst.getY() + (double)ay);
            poly.addPoint((int)dst.getX(), (int)dst.getY());
            poly.addPoint((int)(last.getX() + (double)(ax / 2) - (double)(ay / 3)), (int)(last.getY() + (double)(ay / 2) + (double)(ax / 3)));
            return poly;
        }
        if (style == 2 || style == 1) {
            Polygon poly = new Polygon();
            poly.addPoint((int)dst.getX(), (int)dst.getY());
            poly.addPoint((int)(dst.getX() + (double)ax + (double)(ay / 2)), (int)(dst.getY() + (double)ay - (double)(ax / 2)));
            Point2D last = (Point2D)dst.clone();
            if (style == 1) {
                dst.setLocation((int)(dst.getX() + (double)(ax * 2 / 3)), (int)(dst.getY() + (double)(ay * 2 / 3)));
                poly.addPoint((int)dst.getX(), (int)dst.getY());
            } else if (style == 9) {
                dst.setLocation(dst.getX() + (double)(2 * ax), dst.getY() + (double)(2 * ay));
                poly.addPoint((int)dst.getX(), (int)dst.getY());
            } else {
                dst.setLocation((int)(dst.getX() + (double)ax), (int)(dst.getY() + (double)ay));
            }
            poly.addPoint((int)(last.getX() + (double)ax - (double)(ay / 2)), (int)(last.getY() + (double)ay + (double)(ax / 2)));
            return poly;
        }
        if (style == 4) {
            GeneralPath path = new GeneralPath(1, 4);
            path.moveTo((float)(dst.getX() + (double)ax + (double)(ay / 2)), (float)(dst.getY() + (double)ay - (double)(ax / 2)));
            path.lineTo((float)dst.getX(), (float)dst.getY());
            path.lineTo((float)(dst.getX() + (double)ax - (double)(ay / 2)), (float)(dst.getY() + (double)ay + (double)(ax / 2)));
            return path;
        }
        if (style == 5) {
            Ellipse2D.Float ellipse = new Ellipse2D.Float((float)(dst.getX() + (double)(ax / 2) - (double)(size / 2)), (float)(dst.getY() + (double)(ay / 2) - (double)(size / 2)), size, size);
            dst.setLocation(dst.getX() + (double)ax, dst.getY() + (double)ay);
            return ellipse;
        }
        if (style == 7 || style == 8) {
            GeneralPath path = new GeneralPath(1, 4);
            path.moveTo((float)(dst.getX() + (double)(ax / 2) + (double)(ay / 2)), (float)(dst.getY() + (double)(ay / 2) - (double)(ax / 2)));
            path.lineTo((float)(dst.getX() + (double)(ax / 2) - (double)(ay / 2)), (float)(dst.getY() + (double)(ay / 2) + (double)(ax / 2)));
            if (style == 8) {
                path.moveTo((float)(dst.getX() + (double)(ax / 3) + (double)(ay / 2)), (float)(dst.getY() + (double)(ay / 3) - (double)(ax / 2)));
                path.lineTo((float)(dst.getX() + (double)(ax / 3) - (double)(ay / 2)), (float)(dst.getY() + (double)(ay / 3) + (double)(ax / 2)));
            }
            return path;
        }
        return null;
    }

    public Color getGradientColor() {
        return this.gradientColor;
    }

    public void setGradientColor(Color gradientColor) {
        this.gradientColor = gradientColor;
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text") {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    static {
        try {
            fontGraphics = new BufferedImage(1, 1, 1).getGraphics();
        }
        catch (Error e) {
            fontGraphics = null;
        }
        LABELWIDTHBUFFER = 1.1;
    }
}

