/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.event.SwingPropertyChangeSupport;
import org.jgraph.JGraph;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.GraphSelectionModel;

public class DefaultGraphSelectionModel
implements GraphSelectionModel,
Cloneable,
Serializable {
    public static final String SELECTION_MODE_PROPERTY = "selectionMode";
    public static final int SELECTED = -1;
    public static final Integer UNSELECTED = new Integer(0);
    protected JGraph graph;
    protected SwingPropertyChangeSupport changeSupport;
    protected EventListenerList listenerList = new EventListenerList();
    protected int selectionMode;
    protected boolean childrenSelectable = true;
    protected Map cellStates = new Hashtable();
    protected Set selection = new LinkedHashSet();

    public DefaultGraphSelectionModel(JGraph graph) {
        this.graph = graph;
    }

    @Override
    public void setSelectionMode(int mode) {
        int oldMode = this.selectionMode;
        this.selectionMode = mode;
        if (this.selectionMode != 4 && this.selectionMode != 1) {
            this.selectionMode = 4;
        }
        if (oldMode != this.selectionMode && this.changeSupport != null) {
            this.changeSupport.firePropertyChange(SELECTION_MODE_PROPERTY, new Integer(oldMode), new Integer(this.selectionMode));
        }
    }

    @Override
    public int getSelectionMode() {
        return this.selectionMode;
    }

    @Override
    public void setChildrenSelectable(boolean flag) {
        this.childrenSelectable = flag;
    }

    @Override
    public boolean isChildrenSelectable() {
        return this.childrenSelectable;
    }

    protected boolean isChildrenSelectable(Object cell) {
        AttributeMap attr = this.graph.getModel().getAttributes(cell);
        if (attr != null && this.childrenSelectable) {
            return GraphConstants.isChildrenSelectable(attr);
        }
        return this.childrenSelectable;
    }

    @Override
    public void setSelectionCell(Object cell) {
        if (cell == null) {
            this.setSelectionCells(null);
        } else {
            this.setSelectionCells(new Object[]{cell});
        }
    }

    @Override
    public void setSelectionCells(Object[] cells) {
        if (cells != null) {
            if (this.selectionMode == 1 && cells.length > 0) {
                cells = new Object[]{cells[cells.length - 1]};
            }
            this.cellStates.clear();
            Vector<CellPlaceHolder> change = new Vector<CellPlaceHolder>();
            LinkedHashSet newSelection = new LinkedHashSet();
            for (int i = 0; i < cells.length; ++i) {
                if (cells[i] == null) continue;
                this.selection.remove(cells[i]);
                change.addElement(new CellPlaceHolder(cells[i], !this.selection.remove(cells[i])));
                this.select(newSelection, cells[i]);
                Object parent = this.graph.getModel().getParent(cells[i]);
                if (parent == null) continue;
                change.addElement(new CellPlaceHolder(parent, false));
            }
            for (Object cell : this.selection) {
                while (cell != null) {
                    change.addElement(new CellPlaceHolder(cell, false));
                    cell = this.graph.getModel().getParent(cell);
                }
            }
            this.selection = newSelection;
            if (change.size() > 0) {
                this.notifyCellChange(change);
            }
        }
    }

    @Override
    public void addSelectionCell(Object cell) {
        if (cell != null) {
            this.addSelectionCells(new Object[]{cell});
        }
    }

    @Override
    public void addSelectionCells(Object[] cells) {
        if (cells != null) {
            if (this.selectionMode == 1) {
                this.setSelectionCells(cells);
            } else {
                Vector<CellPlaceHolder> change = new Vector<CellPlaceHolder>();
                for (int i = 0; i < cells.length; ++i) {
                    boolean newness;
                    if (cells[i] == null || !(newness = this.select(this.selection, cells[i]))) continue;
                    change.addElement(new CellPlaceHolder(cells[i], true));
                    Object parent = this.graph.getModel().getParent(cells[i]);
                    if (parent == null) continue;
                    change.addElement(new CellPlaceHolder(parent, false));
                }
                if (change.size() > 0) {
                    this.notifyCellChange(change);
                }
            }
        }
    }

    @Override
    public void removeSelectionCell(Object cell) {
        if (cell != null) {
            this.removeSelectionCells(new Object[]{cell});
        }
    }

    @Override
    public void removeSelectionCells(Object[] cells) {
        if (cells != null) {
            Vector<CellPlaceHolder> change = new Vector<CellPlaceHolder>();
            for (int i = 0; i < cells.length; ++i) {
                boolean removed;
                if (cells[i] == null || !(removed = this.deselect(cells[i]))) continue;
                change.addElement(new CellPlaceHolder(cells[i], false));
                Object parent = this.graph.getModel().getParent(cells[i]);
                if (parent == null) continue;
                change.addElement(new CellPlaceHolder(parent, false));
            }
            if (change.size() > 0) {
                this.notifyCellChange(change);
            }
        }
    }

    @Override
    public Object[] getSelectables() {
        if (this.isChildrenSelectable()) {
            ArrayList result = new ArrayList();
            Stack<Object> s = new Stack<Object>();
            GraphModel model = this.graph.getModel();
            for (int i = 0; i < model.getRootCount(); ++i) {
                s.add(model.getRootAt(i));
            }
            while (!s.isEmpty()) {
                Object cell = s.pop();
                AttributeMap attrs = this.graph.getAttributes(cell);
                if (!model.isPort(cell) && (attrs == null || GraphConstants.isSelectable(attrs))) {
                    result.add(cell);
                }
                if (!this.isChildrenSelectable(cell)) continue;
                for (int i = 0; i < model.getChildCount(cell); ++i) {
                    s.add(model.getChild(cell, i));
                }
            }
            return result.toArray();
        }
        return this.graph.getRoots();
    }

    @Override
    public Object getSelectionCell() {
        if (this.selection != null && this.selection.size() > 0) {
            return this.selection.toArray()[0];
        }
        return null;
    }

    @Override
    public Object[] getSelectionCells() {
        if (this.selection != null) {
            return this.selection.toArray();
        }
        return null;
    }

    @Override
    public int getSelectionCount() {
        return this.selection == null ? 0 : this.selection.size();
    }

    @Override
    public boolean isCellSelected(Object cell) {
        int count = this.getSelectedChildCount(cell);
        return count == -1;
    }

    @Override
    public boolean isChildrenSelected(Object cell) {
        int count = this.getSelectedChildCount(cell);
        return count > 0;
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.selection.isEmpty();
    }

    @Override
    public void clearSelection() {
        if (this.selection != null) {
            Vector<CellPlaceHolder> change = new Vector<CellPlaceHolder>();
            for (Map.Entry entry : this.cellStates.entrySet()) {
                Object cell = entry.getKey();
                while (cell != null) {
                    change.addElement(new CellPlaceHolder(cell, false));
                    cell = this.graph.getModel().getParent(cell);
                }
            }
            this.selection.clear();
            this.cellStates.clear();
            if (change.size() > 0) {
                this.notifyCellChange(change);
            }
        }
    }

    protected int getSelectedChildCount(Object cell) {
        if (cell != null) {
            Integer state = (Integer)this.cellStates.get(cell);
            if (state == null) {
                state = UNSELECTED;
                this.cellStates.put(cell, state);
            }
            return state;
        }
        return 0;
    }

    protected void setSelectedChildCount(Object cell, int count) {
        Integer i = new Integer(count);
        this.cellStates.put(cell, i);
    }

    protected boolean select(Set set, Object cell) {
        AttributeMap attrs = this.graph.getAttributes(cell);
        if (!this.isCellSelected(cell) && this.graph.getGraphLayoutCache().isVisible(cell) && (attrs == null || GraphConstants.isSelectable(attrs))) {
            GraphModel model = this.graph.getModel();
            Object parent = model.getParent(cell);
            while (parent != null) {
                int count = this.getSelectedChildCount(parent);
                if (count == -1) {
                    count = 0;
                }
                this.setSelectedChildCount(parent, ++count);
                this.selection.remove(parent);
                parent = model.getParent(parent);
            }
            Object[] tmp = new Object[]{cell};
            List childs = DefaultGraphModel.getDescendants(model, tmp);
            childs.remove(cell);
            for (Object child : childs) {
                if (child == null || model.isPort(child)) continue;
                this.selection.remove(child);
                this.cellStates.remove(child);
            }
            this.setSelectedChildCount(cell, -1);
            return set.add(cell);
        }
        return false;
    }

    protected boolean deselect(Object cell) {
        if (this.isCellSelected(cell)) {
            Object parent = this.graph.getModel().getParent(cell);
            boolean firstParent = true;
            int change = -1;
            while (parent != null && change != 0) {
                int count = this.getSelectedChildCount(parent);
                if ((count += change) == 0 && firstParent) {
                    change = 0;
                    count = -1;
                    this.selection.add(parent);
                }
                this.setSelectedChildCount(parent, count);
                parent = this.graph.getModel().getParent(parent);
                firstParent = false;
            }
            this.cellStates.remove(cell);
            return this.selection.remove(cell);
        }
        return false;
    }

    @Override
    public void addGraphSelectionListener(GraphSelectionListener x) {
        this.listenerList.add(GraphSelectionListener.class, x);
    }

    @Override
    public void removeGraphSelectionListener(GraphSelectionListener x) {
        this.listenerList.remove(GraphSelectionListener.class, x);
    }

    protected void fireValueChanged(GraphSelectionEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != GraphSelectionListener.class) continue;
            ((GraphSelectionListener)listeners[i + 1]).valueChanged(e);
        }
    }

    public EventListener[] getListeners(Class listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    protected void notifyCellChange(Vector changedCells) {
        int cCellCount = changedCells.size();
        boolean[] newness = new boolean[cCellCount];
        Object[] cells = new Object[cCellCount];
        for (int counter = 0; counter < cCellCount; ++counter) {
            CellPlaceHolder placeholder = (CellPlaceHolder)changedCells.elementAt(counter);
            newness[counter] = placeholder.isNew;
            cells[counter] = placeholder.cell;
        }
        GraphSelectionEvent event = new GraphSelectionEvent(this, cells, newness);
        this.fireValueChanged(event);
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultGraphSelectionModel clone = (DefaultGraphSelectionModel)super.clone();
        clone.changeSupport = null;
        if (this.selection != null) {
            clone.selection = new LinkedHashSet(this.selection);
        }
        clone.listenerList = new EventListenerList();
        return clone;
    }

    protected class CellPlaceHolder {
        protected boolean isNew;
        protected Object cell;

        protected CellPlaceHolder(Object cell, boolean isNew) {
            this.cell = cell;
            this.isNew = isNew;
        }

        public Object getCell() {
            return this.cell;
        }

        public boolean isNew() {
            return this.isNew;
        }

        public void setCell(Object cell) {
            this.cell = cell;
        }

        public void setNew(boolean isNew) {
            this.isNew = isNew;
        }
    }
}

