/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.Edge;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.PortView;

public class DefaultEdge
extends DefaultGraphCell
implements Edge {
    protected Object source;
    protected Object target;

    public DefaultEdge() {
        this(null);
    }

    public DefaultEdge(Object userObject) {
        this(userObject, null);
    }

    public DefaultEdge(Object userObject, AttributeMap storageMap) {
        super(userObject, storageMap);
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    @Override
    public void setSource(Object port) {
        this.source = port;
    }

    @Override
    public void setTarget(Object port) {
        this.target = port;
    }

    @Override
    public Object clone() {
        DefaultEdge edge = (DefaultEdge)super.clone();
        edge.source = null;
        edge.target = null;
        return edge;
    }

    public static class DefaultRouting
    extends LoopRouting {
        @Override
        protected List routeEdge(GraphLayoutCache cache, EdgeView edge) {
            ArrayList<Object> newPoints = new ArrayList<Object>();
            int n = edge.getPointCount();
            Point2D from = edge.getPoint(0);
            newPoints.add(from);
            if (edge.getSource() instanceof PortView) {
                newPoints.set(0, edge.getSource());
                from = ((PortView)edge.getSource()).getLocation();
            } else if (edge.getSource() != null) {
                Rectangle2D b = edge.getSource().getBounds();
                from = edge.getAttributes().createPoint(b.getCenterX(), b.getCenterY());
            }
            Point2D to = edge.getPoint(n - 1);
            CellView target = edge.getTarget();
            if (target instanceof PortView) {
                to = ((PortView)target).getLocation();
            } else if (target != null) {
                Rectangle2D b = target.getBounds();
                to = edge.getAttributes().createPoint(b.getCenterX(), b.getCenterY());
            }
            if (from != null && to != null) {
                double dx = Math.abs(from.getX() - to.getX());
                double dy = Math.abs(from.getY() - to.getY());
                double x2 = from.getX() + (to.getX() - from.getX()) / 2.0;
                double y2 = from.getY() + (to.getY() - from.getY()) / 2.0;
                Point2D[] routed = new Point2D[2];
                Rectangle2D targetBounds = null;
                Rectangle2D sourceBounds = null;
                if (edge.getTarget() != null && edge.getTarget().getParentView() != null && edge.getSource() != null && edge.getSource().getParentView() != null) {
                    targetBounds = edge.getTarget().getParentView().getBounds();
                    sourceBounds = edge.getSource().getParentView().getBounds();
                }
                if (targetBounds != null && sourceBounds != null) {
                    if (dx > dy) {
                        routed[0] = edge.getAttributes().createPoint(x2, from.getY());
                        routed[1] = edge.getAttributes().createPoint(x2, to.getY());
                        if (targetBounds.contains(routed[0]) || sourceBounds.contains(routed[0]) || targetBounds.contains(routed[1]) || sourceBounds.contains(routed[1])) {
                            routed[0] = edge.getAttributes().createPoint(from.getX(), y2);
                            routed[1] = edge.getAttributes().createPoint(to.getX(), y2);
                        }
                    } else {
                        routed[0] = edge.getAttributes().createPoint(from.getX(), y2);
                        routed[1] = edge.getAttributes().createPoint(to.getX(), y2);
                        if (targetBounds.contains(routed[0]) || sourceBounds.contains(routed[0]) || targetBounds.contains(routed[1]) || sourceBounds.contains(routed[1])) {
                            routed[0] = edge.getAttributes().createPoint(x2, from.getY());
                            routed[1] = edge.getAttributes().createPoint(x2, to.getY());
                        }
                    }
                    for (int i = 0; i < routed.length; ++i) {
                        if (targetBounds.contains(routed[i]) || sourceBounds.contains(routed[i])) continue;
                        newPoints.add(routed[i]);
                    }
                }
                if (target != null) {
                    newPoints.add(target);
                } else {
                    newPoints.add(to);
                }
                return newPoints;
            }
            return null;
        }
    }

    public static class LoopRouting
    implements Edge.Routing {
        @Override
        public List route(GraphLayoutCache cache, EdgeView edge) {
            if (edge.isLoop()) {
                return this.routeLoop(cache, edge);
            }
            return this.routeEdge(cache, edge);
        }

        protected List routeLoop(GraphLayoutCache cache, EdgeView edge) {
            CellView sourceParent;
            ArrayList<Object> newPoints = new ArrayList<Object>();
            newPoints.add(edge.getSource());
            CellView cellView = sourceParent = edge.getSource() != null ? edge.getSource().getParentView() : edge.getSourceParentView();
            if (sourceParent != null) {
                Point2D from = AbstractCellView.getCenterPoint(sourceParent);
                Rectangle2D rect = sourceParent.getBounds();
                double width = rect.getWidth();
                double height2 = rect.getHeight() / 2.0;
                double loopWidth = Math.min(20.0, Math.max(10.0, width / 8.0));
                double loopHeight = Math.min(30.0, Math.max(12.0, Math.max(loopWidth + 4.0, height2 / 2.0)));
                newPoints.add(edge.getAttributes().createPoint(from.getX() - loopWidth, from.getY() - height2 - loopHeight * 1.2));
                newPoints.add(edge.getAttributes().createPoint(from.getX(), from.getY() - height2 - 1.5 * loopHeight));
                newPoints.add(edge.getAttributes().createPoint(from.getX() + loopWidth, from.getY() - height2 - loopHeight * 1.2));
                newPoints.add(edge.getTarget());
                return newPoints;
            }
            return null;
        }

        protected List routeEdge(GraphLayoutCache cache, EdgeView edge) {
            return null;
        }

        @Override
        public int getPreferredLineStyle(EdgeView edge) {
            if (edge.isLoop()) {
                return this.getLoopStyle();
            }
            return this.getEdgeStyle();
        }

        protected int getLoopStyle() {
            return 12;
        }

        protected int getEdgeStyle() {
            return -1;
        }
    }
}

