/*
 * Decompiled with CFR 0.152.
 */
package jhpro.engine3d;

public class Volume {
    float x_min;
    float x_max;
    float y_min;
    float y_max;
    float z_min;
    float z_max;

    Volume() {
        this.x_max = 0.0f;
        this.x_min = 0.0f;
        this.y_max = 0.0f;
        this.y_min = 0.0f;
        this.z_max = 0.0f;
        this.z_min = 0.0f;
    }

    Volume(float xmin, float xmax, float ymin, float ymax, float zmin, float zmax) {
        this.x_min = xmin;
        this.x_max = xmax;
        this.y_min = ymin;
        this.y_max = ymax;
        this.z_min = zmin;
        this.z_max = zmax;
    }

    public float getXLen() {
        return this.x_max - this.x_min;
    }

    public float getYLen() {
        return this.y_max - this.y_min;
    }

    public float getZLen() {
        return this.z_max - this.z_min;
    }

    public String toString() {
        String s1 = " size: (" + (this.x_max - this.x_min) + ", " + (this.x_max - this.y_min) + ", " + (this.z_max - this.z_min) + " ) \n";
        String s2 = " [ ( " + this.x_min + " .. " + this.x_max + " ),( " + this.x_min + " .. " + this.y_max + " ),( " + this.y_min + " .. " + this.y_max + " ) ] ";
        return s1 + s2;
    }

    protected static Volume determineBoundingBox(float[] v, int nvert) {
        float zmax;
        float ymax;
        float xmax;
        if (nvert <= 0) {
            return new Volume();
        }
        float xmin = xmax = v[0];
        float ymin = ymax = v[2];
        float zmin = zmax = v[3];
        int i = nvert * 3;
        while ((i -= 3) > 0) {
            float z;
            float y;
            float x = v[i];
            if (x < xmin) {
                xmin = x;
            }
            if (x > xmax) {
                xmax = x;
            }
            if ((y = v[i + 1]) < ymin) {
                ymin = y;
            }
            if (y > ymax) {
                ymax = y;
            }
            if ((z = v[i + 2]) < zmin) {
                zmin = z;
            }
            if (!(z > zmax)) continue;
            zmax = z;
        }
        Volume boundingVolume = new Volume(xmin, xmax, ymin, ymax, zmin, zmax);
        return boundingVolume;
    }
}

