/*
 * Decompiled with CFR 0.152.
 */
package jhpro.engine3d;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import javax.swing.JPanel;
import jhpro.engine3d.FacetedObject;
import jhpro.engine3d.FileParse;
import jhpro.engine3d.MathParser.MathParser;
import jhpro.engine3d.Vec;
import jhpro.engine3d.Window3d;
import jhpro.engine3d.models.RingBand;

public class ViewPanel3d
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static Window3d drawPad = null;
    static int DrawSize = 500;
    static boolean take_new_value = false;
    static int nv = 0;
    private String modelName = "";
    private FacetedObject fo = null;

    public void start() {
        drawPad.Start();
    }

    public void stop() {
        drawPad.Stop();
    }

    public ViewPanel3d(String modelName) {
        this.modelName = modelName;
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        if (modelName.length() > 1) {
            try {
                this.fo = FileParse.readOffObject(modelName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.fo = RingBand.create12();
            this.fo.setFillColor(this.fo.getFillColor());
            this.fo.setShading(true);
            this.fo.setPenColor(this.fo.getPenColor());
        }
        this.fo.setTransperancy(this.fo.getTransperancy());
        drawPad = new Window3d(DrawSize, this.fo);
        this.add((Component)drawPad, "Center");
        Window3d.spinDelay = 80;
        this.start();
    }

    public FacetedObject getObject3D() {
        return this.fo;
    }

    public Window3d getPad3D() {
        return drawPad;
    }

    public void loadFileModel(String model) {
        drawPad.rotatePause();
        drawPad.loadModel(model);
        drawPad.repaint();
        drawPad.rotateResume();
    }

    public void loadFileModel(FacetedObject fo) {
        drawPad.rotatePause();
        drawPad.loadModel(fo);
        drawPad.repaint();
        drawPad.rotateResume();
    }

    public void parseFunction(String expression, int gridDivsU, int gridDivsV) {
        boolean isCurve = false;
        MathParser mathParser = new MathParser();
        Vec[][] coords = new Vec[gridDivsU][isCurve ? 1 : gridDivsV];
        double area = 0.0;
        mathParser.resetVariables();
        mathParser.setVariable("uSteps", gridDivsU - 1);
        mathParser.setVariable("tSteps", gridDivsU - 1);
        mathParser.setVariable("vSteps", isCurve ? 0.0 : (double)(gridDivsV - 1));
        for (int i = 0; i < gridDivsU; ++i) {
            double u = (float)i / (float)(gridDivsU - 1);
            for (int j = 0; j < (isCurve ? 1 : gridDivsV); ++j) {
                double v = (float)j / (float)(gridDivsV - 1);
                mathParser.setVariable("u", u);
                mathParser.setVariable("t", u);
                mathParser.setVariable("v", v);
                mathParser.setVariable("x", isCurve ? 0.0 : 2.0 * u - 1.0);
                mathParser.setVariable("y", isCurve ? 0.0 : 2.0 * v - 1.0);
                mathParser.setVariable("z", 0.0);
                try {
                    mathParser.parseExpression(expression);
                    coords[i][j] = new Vec(mathParser.getVariable("x"), mathParser.getVariable("z"), mathParser.getVariable("y"));
                    if (isCurve) {
                        if (i <= 0) continue;
                        area += coords[i][0].substract(coords[i - 1][0]).norm();
                        continue;
                    }
                    if (i <= 0 || j <= 0) continue;
                    area += coords[i][j - 1].substract(coords[i - 1][j - 1]).crossProduct(coords[i - 1][j].substract(coords[i - 1][j - 1])).norm() / 2.0 + coords[i][j - 1].substract(coords[i][j]).crossProduct(coords[i - 1][j].substract(coords[i][j])).norm() / 2.0;
                    continue;
                }
                catch (Exception e) {
                    coords[i][j] = new Vec(Double.NaN, Double.NaN, Double.NaN);
                }
            }
        }
    }
}

