/*
 * Decompiled with CFR 0.152.
 */
package jhpro.engine3d;

import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;
import jhpro.engine3d.Drawable;
import jhpro.engine3d.Facet;
import jhpro.engine3d.FacetedObject;
import jhpro.engine3d.FileParse;
import jhpro.engine3d.Matrix3d;
import jhpro.engine3d.Vec;
import jhpro.engine3d.Volume;

public class OF_off
implements Drawable {
    int nVerts;
    int nFacets;
    int nEdges;
    static float[] vert;
    private int[] tvert;
    private int[] findex;
    static Facet[] facet;
    private FacetedObject fo;
    static final Vec surfaceNormalOriginal;
    static Vec surfaceNormalCurrent;
    static int nFacets_static_copy;
    static boolean readyForShading;
    private Volume boundingVolume;
    private String modelFilename;
    static double illuminationFactor;
    static double ambientLight;
    private static boolean isShading;

    OF_off() {
        this.nVerts = 0;
        this.nEdges = 0;
        this.nFacets = 0;
        vert = null;
    }

    OF_off(FacetedObject fo) {
        this.fo = fo;
        isShading = this.fo.getShading();
        fo.describe();
        this.prepObject();
        fo = null;
        this.modelFilename = "custom";
    }

    OF_off(String modelName) {
        this();
        this.modelFilename = modelName;
        try {
            System.out.println("Read-ing : \"" + modelName + "\" ");
            this.fo = modelName.endsWith(".off") ? FileParse.readOffObject(modelName) : FileParse.readNffObject(modelName);
            this.fo.describe();
            this.prepObject();
            this.fo = null;
        }
        catch (IOException e) {
            System.err.println("Error: " + e);
        }
    }

    private static Vec vecFromIndex(int pi) {
        return new Vec(vert[pi], vert[pi + 1], vert[pi + 2]);
    }

    private static void calculateFacetNormals() {
        for (int i = 0; i < nFacets_static_copy; ++i) {
            Vec a = OF_off.vecFromIndex(OF_off.facet[i].index[0]);
            Vec b = OF_off.vecFromIndex(OF_off.facet[i].index[1]);
            Vec c = OF_off.vecFromIndex(OF_off.facet[i].index[2]);
            Vec ba = Vec.sub(b, a);
            Vec ca = Vec.sub(c, a);
            OF_off.facet[i].normal = Vec.cross(ba, ca).uvec();
        }
        readyForShading = true;
    }

    private void prepObject() {
        int i;
        this.nVerts = this.fo.v;
        nFacets_static_copy = this.nFacets = this.fo.f;
        this.nEdges = this.fo.e;
        vert = new float[this.nVerts * 3];
        facet = new Facet[this.nFacets];
        this.findex = new int[this.nFacets];
        for (i = 0; i < this.nFacets; ++i) {
            this.findex[i] = i;
        }
        int j = 0;
        for (i = 0; i < this.nVerts; ++i) {
            OF_off.vert[j++] = (float)this.fo.verticies[i][0];
            OF_off.vert[j++] = (float)this.fo.verticies[i][1];
            OF_off.vert[j++] = (float)this.fo.verticies[i][2];
        }
        for (i = 0; i < this.nFacets; ++i) {
            OF_off.facet[i] = new Facet(this.fo.n);
            for (j = 0; j < this.fo.n; ++j) {
                OF_off.facet[i].index[j] = 3 * this.fo.vindex[i][j];
            }
        }
        if (this.fo.getShading()) {
            OF_off.calculateFacetNormals();
        }
    }

    public static void tranformNormal(Matrix3d mat) {
        double cosVal;
        double toDegrees = 57.29577951308232;
        Vec toLight = new Vec(1, 0, -1);
        toLight.normalize();
        surfaceNormalCurrent = mat.transformPoint(surfaceNormalOriginal);
        if (isShading) {
            if (!readyForShading) {
                OF_off.calculateFacetNormals();
            }
            for (int i = 0; i < nFacets_static_copy; ++i) {
                Vec snc = mat.transformPoint(OF_off.facet[i].normal);
                cosVal = Vec.dot(snc, toLight);
                illuminationFactor = Math.min(1.0, Math.pow(Math.abs(cosVal), 3.0) + ambientLight);
                OF_off.facet[i].illuminationFactor = (float)illuminationFactor;
            }
        }
        surfaceNormalCurrent.uvec();
        cosVal = Vec.dot(surfaceNormalCurrent, toLight);
        if (cosVal > 1.0) {
            cosVal = 1.0;
        }
        if (cosVal < -1.0) {
            cosVal = -1.0;
        }
        illuminationFactor = Math.min(1.0, Math.abs(cosVal) + ambientLight);
    }

    @Override
    public void transform(Matrix3d mat) {
        if (this.nVerts <= 0) {
            return;
        }
        if (this.tvert == null) {
            this.tvert = new int[this.nVerts * 3];
        }
        mat.transform_for_off(vert, this.tvert, this.nVerts);
    }

    void qs(int left, int right) {
        int i = left;
        int j = right;
        int x = OF_off.facet[this.findex[(left + right) / 2]].zdepth;
        while (true) {
            if (OF_off.facet[this.findex[i]].zdepth > x && i < right) {
                ++i;
                continue;
            }
            while (x > OF_off.facet[this.findex[j]].zdepth && j > left) {
                --j;
            }
            if (i <= j) {
                int y = this.findex[i];
                this.findex[i] = this.findex[j];
                this.findex[j] = y;
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (left < j) {
            this.qs(left, j);
        }
        if (i < right) {
            this.qs(i, right);
        }
    }

    @Override
    public synchronized void Paint(Graphics g) {
        int MAX_VERTS = 7;
        int[] vx = new int[MAX_VERTS];
        int[] vy = new int[MAX_VERTS];
        g.setColor(this.fo.getPenColor());
        if (vert == null || this.nVerts <= 0) {
            return;
        }
        if (this.fo.getSolidRendering()) {
            for (int i = 0; i < this.nFacets; ++i) {
                int average_depth = 0;
                for (int c = 0; c < OF_off.facet[i].nVerts; ++c) {
                    average_depth += this.tvert[OF_off.facet[i].index[c] + 2];
                }
                OF_off.facet[i].zdepth = average_depth / OF_off.facet[i].nVerts;
            }
            this.qs(0, this.nFacets - 1);
        }
        for (int f = 0; f < this.nFacets; ++f) {
            int c;
            int i = this.findex[f];
            int uglyFudge = 1;
            for (c = 0; c < OF_off.facet[i].nVerts; ++c) {
                vx[c] = this.tvert[OF_off.facet[i].index[c]];
                vy[c] = this.tvert[OF_off.facet[i].index[c] + 1];
            }
            c = OF_off.facet[i].nVerts;
            vx[c] = this.tvert[OF_off.facet[i].index[0]];
            vy[c] = this.tvert[OF_off.facet[i].index[0] + 1];
            int fvts = OF_off.facet[i].nVerts;
            if (this.fo.getSolidRendering()) {
                g.setColor(this.fo.getFillColor());
                if (isShading) {
                    int gv = (int)(255.0f * OF_off.facet[i].illuminationFactor);
                    g.setColor(new Color(0, gv, gv, this.fo.getTransperancy()));
                }
                g.fillPolygon(vx, vy, fvts);
                g.setColor(this.fo.getPenColor());
                g.drawPolygon(vx, vy, fvts + uglyFudge);
                continue;
            }
            g.drawPolygon(vx, vy, fvts + uglyFudge);
        }
    }

    @Override
    public Volume getVolume() {
        return this.boundingVolume;
    }

    @Override
    public Volume determineBoundingBox() {
        this.boundingVolume = Volume.determineBoundingBox(vert, this.nVerts);
        return this.boundingVolume;
    }

    @Override
    public String toString() {
        String s = "File: \"" + this.modelFilename + "\" has: \n " + this.nVerts + " verticies " + this.nEdges + " edges " + this.nFacets + " facets ";
        return s;
    }

    static {
        surfaceNormalCurrent = null;
        nFacets_static_copy = 0;
        readyForShading = false;
        illuminationFactor = 1.0;
        ambientLight = 0.5;
        isShading = true;
        surfaceNormalOriginal = Vec.x_direction;
    }
}

