/*
 * Decompiled with CFR 0.152.
 */
package jhpro.engine3d;

import java.io.IOException;
import jhpro.engine3d.Drawable;
import jhpro.engine3d.FacetedObject;
import jhpro.engine3d.Model3D;
import jhpro.engine3d.OF_off;

public class MeshObject {
    static final int unknown_format = 0;
    static final int wrl_format = 1;
    static final int obj_format = 2;
    static final int off_format = 3;
    static final int nff_format = 4;

    public static Drawable getModel(FacetedObject fo) {
        OF_off model = new OF_off(fo);
        return model;
    }

    public static Drawable getModel(String modelName) throws IOException {
        Drawable model;
        String[] formats = new String[]{"unknown format", ".wrl", ".obj", ".off", ".nff"};
        int object_type = 0;
        for (int i = 1; i <= formats.length; ++i) {
            if (!modelName.endsWith(formats[i])) continue;
            object_type = i;
            break;
        }
        try {
            switch (object_type) {
                case 2: {
                    model = new Model3D(modelName);
                    break;
                }
                case 1: {
                    model = new Model3D(modelName, 0);
                    break;
                }
                case 4: {
                    model = new OF_off(modelName);
                    break;
                }
                case 3: {
                    model = new OF_off(modelName);
                    break;
                }
                default: {
                    System.out.println("Error:  unrecognized file type      ");
                    System.out.println("  controlled abort of file load.    ");
                    System.out.println("  suffix must be { .obj .wrl .off .nff } ");
                    throw new IOException("format not recognized    ");
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error ( loadModel ) " + e);
            throw new IOException("load model error: " + e);
        }
        return model;
    }
}

