/*
 * Decompiled with CFR 0.152.
 */
package org.ea.javacnn.readers;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.imageio.ImageIO;
import org.ea.javacnn.readers.Reader;

public class ImageReader
implements Reader {
    private int imageSizeX = -1;
    private int imageSizeY = -1;
    private int maxvalue = -1;
    private List<String> labels;
    private String imagePath;
    private List<String> filenames = new ArrayList<String>();
    private boolean readLabel = false;
    private boolean readImage = false;
    private int currentImage = 0;

    public ImageReader(String imagePath) {
        this.imagePath = imagePath;
        File dir = new File(imagePath);
        HashSet<String> labels = new HashSet<String>();
        for (File f : dir.listFiles()) {
            if (!f.isFile()) continue;
            this.filenames.add(f.getName());
            labels.add(f.getName().split("_")[0]);
        }
        this.labels = new ArrayList<String>();
        this.labels.addAll(labels);
        try {
            String filename = this.filenames.get(0);
            BufferedImage bi = ImageIO.read(new File(imagePath, filename));
            this.imageSizeX = bi.getWidth();
            this.imageSizeY = bi.getHeight();
            this.maxvalue = 255;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void incrementCounter() {
        ++this.currentImage;
        this.readLabel = false;
        this.readImage = false;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    @Override
    public int readNextLabel() {
        if (this.readLabel) {
            this.incrementCounter();
        }
        String filename = this.filenames.get(this.currentImage);
        int label = this.labels.indexOf(filename.split("_")[0]);
        if (this.readImage) {
            this.incrementCounter();
        } else {
            this.readLabel = true;
        }
        return label;
    }

    @Override
    public int[] readNextImage() throws Exception {
        if (this.readImage) {
            this.incrementCounter();
        }
        if (this.currentImage >= this.size()) {
            return new int[0];
        }
        String filename = this.filenames.get(this.currentImage);
        BufferedImage orgImg = ImageIO.read(new File(this.imagePath, filename));
        BufferedImage newImg = new BufferedImage(this.imageSizeX, this.imageSizeY, 10);
        Graphics g = newImg.getGraphics();
        g.drawImage(orgImg, 0, 0, null);
        int[] imageData = new int[this.imageSizeX * this.imageSizeY];
        imageData = newImg.getData().getPixels(0, 0, this.imageSizeX, this.imageSizeY, imageData);
        if (this.readLabel) {
            this.incrementCounter();
        } else {
            this.readImage = true;
        }
        return imageData;
    }

    @Override
    public void reset() {
        this.currentImage = 0;
        this.readLabel = false;
        this.readImage = false;
    }

    @Override
    public int numOfClasses() {
        return this.labels.size();
    }

    @Override
    public int size() {
        return this.filenames.size();
    }

    @Override
    public int getSizeX() {
        return this.imageSizeX;
    }

    @Override
    public int getSizeY() {
        return this.imageSizeY;
    }

    @Override
    public int getMaxvalue() {
        return this.maxvalue;
    }

    public static void main(String[] argv) {
        int i;
        ImageReader mr = new ImageReader("pngfiles/train");
        System.out.println(mr.size());
        for (i = 0; i < mr.size(); ++i) {
            System.out.print(mr.readNextLabel());
        }
        mr.reset();
        for (i = 0; i < mr.size(); ++i) {
            try {
                mr.readNextImage();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Crash at " + i);
            }
        }
        mr.reset();
        try {
            int[] b = mr.readNextImage();
            for (int j = 0; j < b.length; ++j) {
                if (j % mr.getSizeX() == 0) {
                    System.out.println();
                }
                System.out.print(b[j] + " ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

