/*
 * Decompiled with CFR 0.152.
 */
package org.ea.javacnn.data;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public class DataBlock
implements Serializable {
    private int sx;
    private int sy;
    private int depth;
    private double[] w;
    private double[] dw;

    public DataBlock(int sx, int sy, int depth) {
        this(sx, sy, depth, -1.0);
    }

    public DataBlock(int sx, int sy, int depth, double c) {
        this.sx = sx;
        this.sy = sy;
        this.depth = depth;
        int n = sx * sy * depth;
        this.w = new double[n];
        this.dw = new double[n];
        if (c != -1.0) {
            Arrays.fill(this.w, c);
        } else {
            double scale = Math.sqrt(1.0 / (double)n);
            Random r = new Random();
            for (int i = 0; i < n; ++i) {
                this.w[i] = r.nextDouble() * scale;
            }
        }
        Arrays.fill(this.dw, 0.0);
    }

    public void addImageData(int[] imgData, int maxvalue) {
        for (int i = 0; i < imgData.length; ++i) {
            this.w[i] = (double)((float)imgData[i] / (float)maxvalue) - 0.5;
        }
    }

    public int getSX() {
        return this.sx;
    }

    public int getSY() {
        return this.sy;
    }

    public int getDepth() {
        return this.depth;
    }

    public double getWeight(int ix) {
        return this.w[ix];
    }

    public double getWeight(int x, int y, int depth) {
        int ix = (this.sx * y + x) * this.depth + depth;
        return this.w[ix];
    }

    public void setWeight(int ix, double val) {
        this.w[ix] = val;
    }

    public void setWeight(int x, int y, int depth, double val) {
        int ix = (this.sx * y + x) * this.depth + depth;
        this.setWeight(ix, val);
    }

    public void addWeight(int x, int y, int depth, double val) {
        int ix;
        int n = ix = (this.sx * y + x) * this.depth + depth;
        this.w[n] = this.w[n] + val;
    }

    public double getGradient(int x, int y, int depth) {
        int ix = (this.sx * y + x) * this.depth + depth;
        return this.getGradient(ix);
    }

    public double getGradient(int ix) {
        return this.dw[ix];
    }

    public void setGradient(int x, int y, int depth, double val) {
        int ix = (this.sx * y + x) * this.depth + depth;
        this.setGradient(ix, val);
    }

    public void setGradient(int ix, double val) {
        this.dw[ix] = val;
    }

    public void addGradient(int x, int y, int depth, double val) {
        int ix = (this.sx * y + x) * this.depth + depth;
        this.addGradient(ix, val);
    }

    public void addGradient(int ix, double val) {
        int n = ix;
        this.dw[n] = this.dw[n] + val;
    }

    public void subGradient(int ix, double val) {
        int n = ix;
        this.dw[n] = this.dw[n] - val;
    }

    public void mulGradient(int ix, double val) {
        int n = ix;
        this.dw[n] = this.dw[n] * val;
    }

    public DataBlock cloneAndZero() {
        return new DataBlock(this.sx, this.sy, this.depth, 0.0);
    }

    public DataBlock clone() {
        DataBlock db = new DataBlock(this.sx, this.sy, this.depth, 0.0);
        for (int i = 0; i < this.w.length; ++i) {
            db.w[i] = this.w[i];
        }
        return db;
    }

    public void clearGradient() {
        Arrays.fill(this.dw, 0.0);
    }

    public double[] getWeights() {
        return this.w;
    }

    public double[] getGradients() {
        return this.dw;
    }

    public void addFrom(DataBlock db) {
        for (int i = 0; i < this.w.length; ++i) {
            this.w[i] = db.w[i];
        }
    }

    public void addFromScaled(DataBlock db, double a) {
        for (int i = 0; i < this.w.length; ++i) {
            this.w[i] = db.w[i] * a;
        }
    }

    public void setConst(double a) {
        for (int i = 0; i < this.w.length; ++i) {
            this.w[i] = a;
        }
    }
}

