/*
 * Decompiled with CFR 0.152.
 */
package edu.hitsz.c102c.util;

import edu.hitsz.c102c.cnn.Layer;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;

public class Util {
    public static final Operator one_value = new Operator(){
        private static final long serialVersionUID = 3752139491940330714L;

        @Override
        public double process(double value) {
            return 1.0 - value;
        }
    };
    public static final Operator digmod = new Operator(){
        private static final long serialVersionUID = -1952718905019847589L;

        @Override
        public double process(double value) {
            return 1.0 / (1.0 + Math.pow(Math.E, -value));
        }
    };
    public static final OperatorOnTwo plus = new OperatorOnTwo(){
        private static final long serialVersionUID = -6298144029766839945L;

        @Override
        public double process(double a, double b) {
            return a + b;
        }
    };
    public static OperatorOnTwo multiply = new OperatorOnTwo(){
        private static final long serialVersionUID = -7053767821858820698L;

        @Override
        public double process(double a, double b) {
            return a * b;
        }
    };
    public static OperatorOnTwo minus = new OperatorOnTwo(){
        private static final long serialVersionUID = 7346065545555093912L;

        @Override
        public double process(double a, double b) {
            return a - b;
        }
    };
    private static Random r = new Random(2L);

    public static void printMatrix(double[][] matrix) {
        for (int i = 0; i < matrix.length; ++i) {
            String line = Arrays.toString(matrix[i]);
            line = line.replaceAll(", ", "\t");
            System.out.println(line);
        }
        System.out.println();
    }

    public static double[][] rot180(double[][] matrix) {
        double tmp;
        matrix = Util.cloneMatrix(matrix);
        int m = matrix.length;
        int n = matrix[0].length;
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n / 2; ++j) {
                tmp = matrix[i][j];
                matrix[i][j] = matrix[i][n - 1 - j];
                matrix[i][n - 1 - j] = tmp;
            }
        }
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m / 2; ++i) {
                tmp = matrix[i][j];
                matrix[i][j] = matrix[m - 1 - i][j];
                matrix[m - 1 - i][j] = tmp;
            }
        }
        return matrix;
    }

    public static double[][] randomMatrix(int x, int y, boolean b) {
        double[][] matrix = new double[x][y];
        boolean tag = true;
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                matrix[i][j] = (r.nextDouble() - 0.05) / 10.0;
            }
        }
        return matrix;
    }

    public static double[] randomArray(int len) {
        double[] data = new double[len];
        for (int i = 0; i < len; ++i) {
            data[i] = 0.0;
        }
        return data;
    }

    public static int[] randomPerm(int size, int batchSize) {
        HashSet<Integer> set = new HashSet<Integer>();
        while (set.size() < batchSize) {
            set.add(r.nextInt(size));
        }
        int[] randPerm = new int[batchSize];
        int i = 0;
        for (Integer value : set) {
            randPerm[i++] = value;
        }
        return randPerm;
    }

    public static double[][] cloneMatrix(double[][] matrix) {
        int m = matrix.length;
        int n = matrix[0].length;
        double[][] outMatrix = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                outMatrix[i][j] = matrix[i][j];
            }
        }
        return outMatrix;
    }

    public static double[][] matrixOp(double[][] ma, Operator operator) {
        int m = ma.length;
        int n = ma[0].length;
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                ma[i][j] = operator.process(ma[i][j]);
            }
        }
        return ma;
    }

    public static double[][] matrixOp(double[][] ma, double[][] mb, Operator operatorA, Operator operatorB, OperatorOnTwo operator) {
        int m = ma.length;
        int n = ma[0].length;
        if (m != mb.length || n != mb[0].length) {
            throw new RuntimeException("\u00c1\u00bd\u00b8\u00f6\u00be\u00d8\u00d5\u00f3\u00b4\u00f3\u00d0\u00a1\u00b2\u00bb\u00d2\u00bb\u00d6\u00c2 ma.length:" + ma.length + "  mb.length:" + mb.length);
        }
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                double a = ma[i][j];
                if (operatorA != null) {
                    a = operatorA.process(a);
                }
                double b = mb[i][j];
                if (operatorB != null) {
                    b = operatorB.process(b);
                }
                mb[i][j] = operator.process(a, b);
            }
        }
        return mb;
    }

    public static double[][] kronecker(double[][] matrix, Layer.Size scale) {
        int m = matrix.length;
        int n = matrix[0].length;
        double[][] outMatrix = new double[m * scale.x][n * scale.y];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                for (int ki = i * scale.x; ki < (i + 1) * scale.x; ++ki) {
                    for (int kj = j * scale.y; kj < (j + 1) * scale.y; ++kj) {
                        outMatrix[ki][kj] = matrix[i][j];
                    }
                }
            }
        }
        return outMatrix;
    }

    public static double[][] scaleMatrix(double[][] matrix, Layer.Size scale) {
        int m = matrix.length;
        int n = matrix[0].length;
        int sm = m / scale.x;
        int sn = n / scale.y;
        double[][] outMatrix = new double[sm][sn];
        if (sm * scale.x != m || sn * scale.y != n) {
            throw new RuntimeException("scale\u00b2\u00bb\u00c4\u00dc\u00d5\u00fb\u00b3\u00fdmatrix");
        }
        int size = scale.x * scale.y;
        for (int i = 0; i < sm; ++i) {
            for (int j = 0; j < sn; ++j) {
                double sum = 0.0;
                for (int si = i * scale.x; si < (i + 1) * scale.x; ++si) {
                    for (int sj = j * scale.y; sj < (j + 1) * scale.y; ++sj) {
                        sum += matrix[si][sj];
                    }
                }
                outMatrix[i][j] = sum / (double)size;
            }
        }
        return outMatrix;
    }

    public static double[][] convnFull(double[][] matrix, double[][] kernel) {
        int m = matrix.length;
        int n = matrix[0].length;
        int km = kernel.length;
        int kn = kernel[0].length;
        double[][] extendMatrix = new double[m + 2 * (km - 1)][n + 2 * (kn - 1)];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                extendMatrix[i + km - 1][j + kn - 1] = matrix[i][j];
            }
        }
        return Util.convnValid(extendMatrix, kernel);
    }

    public static double[][] convnValid(double[][] matrix, double[][] kernel) {
        int m = matrix.length;
        int n = matrix[0].length;
        int km = kernel.length;
        int kn = kernel[0].length;
        int kns = n - kn + 1;
        int kms = m - km + 1;
        double[][] outMatrix = new double[kms][kns];
        for (int i = 0; i < kms; ++i) {
            for (int j = 0; j < kns; ++j) {
                double sum = 0.0;
                for (int ki = 0; ki < km; ++ki) {
                    for (int kj = 0; kj < kn; ++kj) {
                        sum += matrix[i + ki][j + kj] * kernel[ki][kj];
                    }
                }
                outMatrix[i][j] = sum;
            }
        }
        return outMatrix;
    }

    public static double[][] convnValid(double[][][][] matrix, int mapNoX, double[][][][] kernel, int mapNoY) {
        int m = matrix.length;
        int n = matrix[0][mapNoX].length;
        int h = matrix[0][mapNoX][0].length;
        int km = kernel.length;
        int kn = kernel[0][mapNoY].length;
        int kh = kernel[0][mapNoY][0].length;
        int kms = m - km + 1;
        int kns = n - kn + 1;
        int khs = h - kh + 1;
        if (matrix.length != kernel.length) {
            throw new RuntimeException("\u00be\u00d8\u00d5\u00f3\u00d3\u00eb\u00be\u00ed\u00bb\u00fd\u00ba\u00cb\u00d4\u00da\u00b5\u00da\u00d2\u00bb\u00ce\u00ac\u00c9\u00cf\u00b2\u00bb\u00cd\u00ac");
        }
        double[][][] outMatrix = new double[kms][kns][khs];
        for (int i = 0; i < kms; ++i) {
            for (int j = 0; j < kns; ++j) {
                for (int k = 0; k < khs; ++k) {
                    double sum = 0.0;
                    for (int ki = 0; ki < km; ++ki) {
                        for (int kj = 0; kj < kn; ++kj) {
                            for (int kk = 0; kk < kh; ++kk) {
                                sum += matrix[i + ki][mapNoX][j + kj][k + kk] * kernel[ki][mapNoY][kj][kk];
                            }
                        }
                    }
                    outMatrix[i][j][k] = sum;
                }
            }
        }
        return outMatrix[0];
    }

    public static double sigmod(double x) {
        return 1.0 / (1.0 + Math.pow(Math.E, -x));
    }

    public static double sum(double[][] error) {
        int m = error.length;
        int n = error[0].length;
        double sum = 0.0;
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                sum += error[i][j];
            }
        }
        return sum;
    }

    public static double[][] sum(double[][][][] errors, int j) {
        int m = errors[0][j].length;
        int n = errors[0][j][0].length;
        double[][] result = new double[m][n];
        for (int mi = 0; mi < m; ++mi) {
            for (int nj = 0; nj < n; ++nj) {
                double sum = 0.0;
                for (int i = 0; i < errors.length; ++i) {
                    sum += errors[i][j][mi][nj];
                }
                result[mi][nj] = sum;
            }
        }
        return result;
    }

    public static int binaryArray2int(double[] array) {
        int[] d = new int[array.length];
        for (int i = 0; i < d.length; ++i) {
            d[i] = array[i] >= 0.500000001 ? 1 : 0;
        }
        String s = Arrays.toString(d);
        String binary = s.substring(1, s.length() - 1).replace(", ", "");
        int data = Integer.parseInt(binary, 2);
        return data;
    }

    private static void testConvn() {
        int count = 1;
        double[][] m = new double[5][5];
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[0].length; ++j) {
                m[i][j] = count++;
            }
        }
        double[][] k = new double[3][3];
        for (int i = 0; i < k.length; ++i) {
            for (int j = 0; j < k[0].length; ++j) {
                k[i][j] = 1.0;
            }
        }
        Util.printMatrix(m);
        double[][] out = Util.convnFull(m, k);
        Util.printMatrix(out);
    }

    private static void testScaleMatrix() {
        int count = 1;
        double[][] m = new double[16][16];
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[0].length; ++j) {
                m[i][j] = count++;
            }
        }
        double[][] out = Util.scaleMatrix(m, new Layer.Size(2, 2));
        Util.printMatrix(m);
        Util.printMatrix(out);
    }

    private static void testKronecker() {
        int count = 1;
        double[][] m = new double[5][5];
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[0].length; ++j) {
                m[i][j] = count++;
            }
        }
        double[][] out = Util.kronecker(m, new Layer.Size(2, 2));
        Util.printMatrix(m);
        System.out.println();
        Util.printMatrix(out);
    }

    private static void testMatrixProduct() {
        int count = 1;
        double[][] m = new double[5][5];
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[0].length; ++j) {
                m[i][j] = count++;
            }
        }
        double[][] k = new double[5][5];
        for (int i = 0; i < k.length; ++i) {
            for (int j = 0; j < k[0].length; ++j) {
                k[i][j] = j;
            }
        }
        Util.printMatrix(m);
        Util.printMatrix(k);
        double[][] out = Util.matrixOp(m, k, new Operator(){
            private static final long serialVersionUID = -680712567166604573L;

            @Override
            public double process(double value) {
                return value - 1.0;
            }
        }, new Operator(){
            private static final long serialVersionUID = -6335660830579545544L;

            @Override
            public double process(double value) {
                return -1.0 * value;
            }
        }, multiply);
        Util.printMatrix(out);
    }

    private static void testCloneMatrix() {
        int count = 1;
        double[][] m = new double[5][5];
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[0].length; ++j) {
                m[i][j] = count++;
            }
        }
        double[][] out = Util.cloneMatrix(m);
        Util.printMatrix(m);
        Util.printMatrix(out);
    }

    public static void testRot180() {
        double[][] matrix = new double[][]{{1.0, 2.0, 3.0, 4.0}, {4.0, 5.0, 6.0, 7.0}, {7.0, 8.0, 9.0, 10.0}};
        Util.printMatrix(matrix);
        Util.rot180(matrix);
        System.out.println();
        Util.printMatrix(matrix);
    }

    public static void main(String[] args) {
        System.out.println(Util.sigmod(0.727855957917715));
        Double a = 1.0;
        int b = 1;
        System.out.println(a.equals(b));
    }

    public static int getMaxIndex(double[] out) {
        double max = out[0];
        int index = 0;
        for (int i = 1; i < out.length; ++i) {
            if (!(out[i] > max)) continue;
            max = out[i];
            index = i;
        }
        return index;
    }

    public static String fomart(double[] data) {
        StringBuilder sb = new StringBuilder("[");
        for (double each : data) {
            sb.append(String.format("%4f,", each));
        }
        sb.append("]");
        return sb.toString();
    }

    static interface OperatorOnTwo
    extends Serializable {
        public double process(double var1, double var3);
    }

    public static interface Operator
    extends Serializable {
        public double process(double var1);
    }
}

