/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.OneOperandResultBaseInstr;
import org.jruby.ir.operands.Array;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ToAryInstr
extends OneOperandResultBaseInstr
implements FixedArityInstr {
    public ToAryInstr(Variable result2, Operand array2) {
        super(Operation.TO_ARY, result2, array2);
        assert (result2 != null) : "ToAryInstr result is null";
    }

    public Operand getArray() {
        return this.getOperand1();
    }

    @Override
    public boolean canBeDeletedFromScope(IRScope s2) {
        return true;
    }

    @Override
    public Operand simplifyAndGetResult(IRScope scope, Map<Operand, Operand> valueMap) {
        this.simplifyOperands(valueMap, false);
        Operand a = this.getArray().getValue(valueMap);
        return a instanceof Array ? a : null;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new ToAryInstr((Variable)this.result.cloneForInlining(ii), this.getArray().cloneForInlining(ii));
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getArray());
    }

    public static ToAryInstr decode(IRReaderDecoder d) {
        return new ToAryInstr(d.decodeVariable(), d.decodeOperand());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        return IRRuntimeHelpers.irToAry(context, (IRubyObject)this.getArray().retrieve(context, self2, currScope, currDynScope, temp));
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ToAryInstr(this);
    }
}

