/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.lang.reflect.Field;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.socket.Addrinfo;
import org.jruby.ext.socket.SocketUtilsIPV6;
import org.jruby.ext.socket.SubnetUtils;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class Ifaddr
extends RubyObject {
    private String name;
    private Boolean isUp;
    private Boolean isLoopback;
    private Boolean isPointToPoint;
    private InetAddress address;
    private InetAddress broadcast;
    private InterfaceAddress interfaceAddress;
    private NetworkInterface networkInterface;
    private boolean isLink;
    private String netmask;
    private int index;
    private String flagStatus;
    private Addrinfo addr;

    public static void createIfaddr(Ruby runtime2) {
        RubyClass ifaddr = runtime2.getClass("Socket").defineClassUnder("Ifaddr", runtime2.getData(), new ObjectAllocator(){

            @Override
            public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
                return new Ifaddr(runtime2, klazz);
            }
        });
        ifaddr.defineAnnotatedMethods(Ifaddr.class);
    }

    public Ifaddr(Ruby runtime2, RubyClass metaClass) {
        super(runtime2, metaClass);
    }

    public Ifaddr(Ruby runtime2, RubyClass metaClass, NetworkInterface ni, InterfaceAddress it) throws Exception {
        super(runtime2, metaClass);
        this.isUp = ni.isUp();
        this.name = ni.getDisplayName();
        this.isLoopback = ni.isLoopback();
        this.isPointToPoint = ni.isPointToPoint();
        this.networkInterface = ni;
        this.isLink = false;
        this.address = it.getAddress();
        this.broadcast = it.getBroadcast();
        this.interfaceAddress = it;
        this.setAddr(runtime2);
        this.setNetmask(it);
        this.setIndex(ni);
        this.setInspectString(ni);
    }

    public Ifaddr(Ruby runtime2, RubyClass metaClass, NetworkInterface ni) throws Exception {
        super(runtime2, metaClass);
        this.isUp = ni.isUp();
        this.name = ni.getDisplayName();
        this.isLoopback = ni.isLoopback();
        this.isPointToPoint = ni.isPointToPoint();
        this.networkInterface = ni;
        this.isLink = true;
        this.setAddr(runtime2);
        this.setIndex(ni);
        this.setInspectString(ni);
    }

    @JRubyMethod
    public IRubyObject inspect(ThreadContext context) {
        return context.runtime.newString("#<Socket::Ifaddr: " + this.name + " " + this.flagStatus + ">");
    }

    @JRubyMethod
    public IRubyObject name(ThreadContext context) {
        return context.runtime.newString(this.name);
    }

    @JRubyMethod
    public IRubyObject addr(ThreadContext context) {
        return this.addr;
    }

    @JRubyMethod
    public IRubyObject broadaddr(ThreadContext context) {
        if (this.broadcast != null && !this.isLink) {
            return new Addrinfo(context.runtime, context.runtime.getClass("Addrinfo"), this.broadcast);
        }
        try {
            if (this.isLink && !this.networkInterface.isLoopback()) {
                return new Addrinfo(context.runtime, context.runtime.getClass("Addrinfo"), this.networkInterface, true);
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject ifindex(ThreadContext context) {
        return context.runtime.newFixnum(this.index);
    }

    @JRubyMethod(notImplemented=true)
    public IRubyObject flags(ThreadContext context) {
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject netmask(ThreadContext context) throws UnknownHostException {
        if (this.netmask == null) {
            return context.nil;
        }
        return new Addrinfo(context.runtime, context.runtime.getClass("Addrinfo"), InetAddress.getByName(this.netmask));
    }

    @JRubyMethod(notImplemented=true)
    public IRubyObject dstaddr(ThreadContext context) {
        return context.nil;
    }

    private void setAddr(Ruby runtime2) {
        if (this.address != null && !this.isLink) {
            this.addr = new Addrinfo(runtime2, runtime2.getClass("Addrinfo"), this.address);
        }
        if (this.isLink) {
            this.addr = new Addrinfo(runtime2, runtime2.getClass("Addrinfo"), this.networkInterface, false);
        }
    }

    private void setNetmask(InterfaceAddress it) throws Exception {
        if ((this.isLoopback.booleanValue() || it.getNetworkPrefixLength() != 0) && this.address instanceof Inet4Address) {
            String subnet = this.ipAddress() + "/" + it.getNetworkPrefixLength();
            if (this.isLoopback.booleanValue()) {
                subnet = this.ipAddress() + "/8";
            }
            SubnetUtils utils = new SubnetUtils(subnet);
            this.netmask = utils.getInfo().getNetmask();
        } else if (it.getNetworkPrefixLength() != 0 && this.address instanceof Inet6Address) {
            this.netmask = SocketUtilsIPV6.getIPV6NetMask(this.ipAddress() + "/" + it.getNetworkPrefixLength());
        }
    }

    private void setIndex(NetworkInterface ni) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field2 = ni.getClass().getDeclaredField("index");
        field2.setAccessible(true);
        this.index = (Integer)field2.get(ni);
    }

    private void setInspectString(NetworkInterface nif) throws SocketException {
        String string2 = this.flagStatus = nif.isUp() ? "UP" : "DOWN";
        if (nif.isLoopback()) {
            this.flagStatus = this.flagStatus + ",LOOPBACK";
        }
        if (nif.isPointToPoint()) {
            this.flagStatus = this.flagStatus + ",PTP";
        }
        if (nif.isVirtual()) {
            this.flagStatus = this.flagStatus + ",VIRTUAL";
        }
        if (nif.supportsMulticast()) {
            this.flagStatus = this.flagStatus + ",MULTICAST";
        }
        this.flagStatus = this.flagStatus + ",MTU=" + nif.getMTU();
        byte[] mac = nif.getHardwareAddress();
        if (mac != null) {
            this.flagStatus = this.flagStatus + ",HWADDR=";
            for (int i2 = 0; i2 < mac.length; ++i2) {
                if (i2 > 0) {
                    this.flagStatus = this.flagStatus + ":";
                }
                this.flagStatus = this.flagStatus + String.format("%02x", mac[i2]);
            }
        }
        if (this.isLink) {
            this.flagStatus = this.flagStatus + " " + this.addr.packet_inspect();
        } else {
            if (!this.ipAddress().equals("")) {
                this.flagStatus = this.flagStatus + " " + this.ipAddress();
            }
            if (this.broadcast != null) {
                this.flagStatus = this.flagStatus + " broadcast=" + this.getBroadcastAsString();
            }
            if (this.netmask != null) {
                this.flagStatus = this.flagStatus + " netmask=" + this.netmask;
            }
        }
    }

    private String ipAddress() {
        if (this.address instanceof Inet4Address) {
            String addr2 = this.address.toString();
            return addr2.substring(1, addr2.length());
        }
        if (this.address instanceof Inet6Address) {
            String addr3 = this.address.toString();
            return addr3.substring(1, addr3.length()).split("%")[0];
        }
        return "";
    }

    private String getBroadcastAsString() {
        if (this.broadcast == null) {
            return "";
        }
        String brdc = this.broadcast.toString();
        return brdc.substring(1, brdc.length());
    }
}

