/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.semi_supervised.pr.constraints;

import cc.mallet.fst.semi_supervised.StateLabelMap;
import cc.mallet.fst.semi_supervised.pr.constraints.PRConstraint;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.FeatureVectorSequence;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntIntHashMap;
import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.IntObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.util.BitSet;

public class OneLabelL2PRConstraints
implements PRConstraint {
    protected IntObjectHashMap<OneLabelPRConstraint> constraints = new IntObjectHashMap();
    protected IntIntHashMap constraintIndices;
    protected StateLabelMap map;
    protected boolean normalized;
    protected IntArrayList cache;

    public OneLabelL2PRConstraints(boolean normalized) {
        this.constraintIndices = new IntIntHashMap();
        this.cache = new IntArrayList();
        this.normalized = normalized;
    }

    protected OneLabelL2PRConstraints(IntObjectHashMap<OneLabelPRConstraint> constraints, IntIntHashMap constraintIndices, StateLabelMap map, boolean normalized) {
        for (IntObjectCursor keyVal : constraints) {
            this.constraints.put(keyVal.key, (Object)((OneLabelPRConstraint)keyVal.value).copy());
        }
        this.constraintIndices = constraintIndices;
        this.map = map;
        this.cache = new IntArrayList();
        this.normalized = normalized;
    }

    @Override
    public PRConstraint copy() {
        return new OneLabelL2PRConstraints(this.constraints, this.constraintIndices, this.map, this.normalized);
    }

    public void addConstraint(int fi, double[] target, double weight) {
        this.constraints.put(fi, (Object)new OneLabelPRConstraint(target, weight));
        this.constraintIndices.put(fi, this.constraintIndices.size());
    }

    @Override
    public int numDimensions() {
        assert (this.map != null);
        return this.map.getNumLabels() * this.constraints.size();
    }

    public boolean isOneStateConstraint() {
        return true;
    }

    @Override
    public void setStateLabelMap(StateLabelMap map) {
        this.map = map;
    }

    @Override
    public void preProcess(FeatureVector fv) {
        this.cache.clear();
        for (int loc = 0; loc < fv.numLocations(); ++loc) {
            int fi = fv.indexAtLocation(loc);
            if (!this.constraints.containsKey(fi)) continue;
            this.cache.add(fi);
        }
    }

    @Override
    public BitSet preProcess(InstanceList data) {
        int ii = 0;
        BitSet bitSet = new BitSet(data.size());
        for (Instance instance : data) {
            FeatureVectorSequence fvs = (FeatureVectorSequence)instance.getData();
            for (int ip = 0; ip < fvs.size(); ++ip) {
                FeatureVector fv = fvs.get(ip);
                for (int loc = 0; loc < fv.numLocations(); ++loc) {
                    int fi = fv.indexAtLocation(loc);
                    if (!this.constraints.containsKey(fi)) continue;
                    ((OneLabelPRConstraint)this.constraints.get((int)fi)).count += 1.0;
                    bitSet.set(ii);
                }
            }
            ++ii;
        }
        return bitSet;
    }

    @Override
    public double getScore(FeatureVector input, int inputPosition, int srcIndex, int destIndex, double[] parameters) {
        double dot = 0.0;
        int li2 = this.map.getLabelIndex(destIndex);
        for (int i = 0; i < this.cache.size(); ++i) {
            int j = this.constraintIndices.get(this.cache.get(i));
            if (this.normalized) {
                dot += parameters[j + this.constraints.size() * li2] / ((OneLabelPRConstraint)this.constraints.get((int)this.cache.get((int)i))).count;
                continue;
            }
            dot += parameters[j + this.constraints.size() * li2];
        }
        return dot;
    }

    @Override
    public void incrementExpectations(FeatureVector input, int inputPosition, int srcIndex, int destIndex, double prob) {
        int li2 = this.map.getLabelIndex(destIndex);
        for (int i = 0; i < this.cache.size(); ++i) {
            int n = li2;
            ((OneLabelPRConstraint)this.constraints.get((int)this.cache.get((int)i))).expectation[n] = ((OneLabelPRConstraint)this.constraints.get((int)this.cache.get((int)i))).expectation[n] + prob;
        }
    }

    @Override
    public void getExpectations(double[] expectations) {
        assert (expectations.length == this.numDimensions());
        for (IntCursor fi : this.constraintIndices.keys()) {
            int ci = this.constraintIndices.get(fi.value);
            OneLabelPRConstraint constraint = (OneLabelPRConstraint)this.constraints.get(fi.value);
            for (int li = 0; li < constraint.expectation.length; ++li) {
                expectations[ci + li * this.constraints.size()] = constraint.expectation[li];
            }
        }
    }

    @Override
    public void addExpectations(double[] expectations) {
        assert (expectations.length == this.numDimensions());
        for (IntCursor fi : this.constraintIndices.keys()) {
            int ci = this.constraintIndices.get(fi.value);
            OneLabelPRConstraint constraint = (OneLabelPRConstraint)this.constraints.get(fi.value);
            for (int li = 0; li < constraint.expectation.length; ++li) {
                int n = li;
                constraint.expectation[n] = constraint.expectation[n] + expectations[ci + li * this.constraints.size()];
            }
        }
    }

    @Override
    public void zeroExpectations() {
        for (ObjectCursor fi : this.constraints.values()) {
            ((OneLabelPRConstraint)fi.value).expectation = new double[this.map.getNumLabels()];
        }
    }

    @Override
    public double getAuxiliaryValueContribution(double[] parameters) {
        double value = 0.0;
        for (IntObjectCursor fi : this.constraints) {
            int ci = this.constraintIndices.get(fi.key);
            for (int li = 0; li < this.map.getNumLabels(); ++li) {
                double param = parameters[ci + li * this.constraints.size()];
                value += ((OneLabelPRConstraint)fi.value).target[li] * param - param * param / (2.0 * ((OneLabelPRConstraint)fi.value).weight);
            }
        }
        return value;
    }

    @Override
    public double getCompleteValueContribution(double[] parameters) {
        double value = 0.0;
        for (IntObjectCursor fi : this.constraints) {
            OneLabelPRConstraint constraint = (OneLabelPRConstraint)fi.value;
            for (int li = 0; li < this.map.getNumLabels(); ++li) {
                if (this.normalized) {
                    value += constraint.weight * Math.pow(constraint.target[li] - constraint.expectation[li] / constraint.count, 2.0) / 2.0;
                    continue;
                }
                value += constraint.weight * Math.pow(constraint.target[li] - constraint.expectation[li], 2.0) / 2.0;
            }
        }
        return value;
    }

    @Override
    public void getGradient(double[] parameters, double[] gradient) {
        for (IntObjectCursor fi : this.constraints) {
            int ci = this.constraintIndices.get(fi.key);
            OneLabelPRConstraint constraint = (OneLabelPRConstraint)fi.value;
            for (int li = 0; li < this.map.getNumLabels(); ++li) {
                gradient[ci + li * this.constraints.size()] = this.normalized ? constraint.target[li] - constraint.expectation[li] / constraint.count - parameters[ci + li * this.constraints.size()] / constraint.weight : constraint.target[li] - constraint.expectation[li] - parameters[ci + li * this.constraints.size()] / constraint.weight;
            }
        }
    }

    protected class OneLabelPRConstraint {
        protected double[] target;
        protected double[] expectation;
        protected double count;
        protected double weight;

        public OneLabelPRConstraint(double[] target, double weight) {
            this.target = target;
            this.weight = weight;
            this.expectation = null;
            this.count = 0.0;
        }

        public OneLabelPRConstraint copy() {
            OneLabelPRConstraint copy = new OneLabelPRConstraint(this.target, this.weight);
            copy.count = this.count;
            copy.expectation = new double[this.target.length];
            return copy;
        }
    }
}

