/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.semi_supervised.pr.constraints;

import cc.mallet.fst.semi_supervised.StateLabelMap;
import cc.mallet.fst.semi_supervised.pr.constraints.PRConstraint;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.FeatureVectorSequence;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.cursors.IntObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;

public class OneLabelL2IndPRConstraints
implements PRConstraint {
    protected boolean normalized;
    protected int numDimensions;
    protected IntObjectHashMap<OneLabelL2IndPRConstraint> constraints;
    protected StateLabelMap map;
    protected IntArrayList cache;

    public OneLabelL2IndPRConstraints(boolean normalized) {
        this.normalized = normalized;
        this.numDimensions = 0;
        this.constraints = new IntObjectHashMap();
        this.map = null;
        this.cache = new IntArrayList();
    }

    protected OneLabelL2IndPRConstraints(IntObjectHashMap<OneLabelL2IndPRConstraint> constraints, StateLabelMap map, boolean normalized) {
        this.normalized = normalized;
        this.numDimensions = 0;
        this.constraints = new IntObjectHashMap();
        for (IntObjectCursor keyVal : constraints) {
            this.constraints.put(keyVal.key, (Object)((OneLabelL2IndPRConstraint)keyVal.value).copy());
            this.numDimensions += ((OneLabelL2IndPRConstraint)keyVal.value).getNumConstrainedLabels();
        }
        this.map = map;
        this.cache = new IntArrayList();
    }

    @Override
    public PRConstraint copy() {
        return new OneLabelL2IndPRConstraints(this.constraints, this.map, this.normalized);
    }

    public void addConstraint(int fi, int li, double target, double weight) {
        if (!this.constraints.containsKey(fi)) {
            this.constraints.put(fi, (Object)new OneLabelL2IndPRConstraint());
        }
        ((OneLabelL2IndPRConstraint)this.constraints.get(fi)).add(li, target, weight, this.numDimensions);
        ++this.numDimensions;
    }

    @Override
    public int numDimensions() {
        return this.numDimensions;
    }

    @Override
    public void setStateLabelMap(StateLabelMap map) {
        this.map = map;
    }

    @Override
    public void preProcess(FeatureVector fv) {
        this.cache.clear();
        for (int loc = 0; loc < fv.numLocations(); ++loc) {
            int fi = fv.indexAtLocation(loc);
            if (!this.constraints.containsKey(fi)) continue;
            this.cache.add(fi);
        }
    }

    @Override
    public BitSet preProcess(InstanceList data) {
        int ii = 0;
        BitSet bitSet = new BitSet(data.size());
        for (Instance instance : data) {
            FeatureVectorSequence fvs = (FeatureVectorSequence)instance.getData();
            for (int ip = 0; ip < fvs.size(); ++ip) {
                FeatureVector fv = fvs.get(ip);
                for (int loc = 0; loc < fv.numLocations(); ++loc) {
                    int fi = fv.indexAtLocation(loc);
                    if (!this.constraints.containsKey(fi)) continue;
                    ((OneLabelL2IndPRConstraint)this.constraints.get((int)fi)).count += 1.0;
                    bitSet.set(ii);
                }
            }
            ++ii;
        }
        return bitSet;
    }

    @Override
    public double getScore(FeatureVector input, int inputPosition, int srcIndex, int destIndex, double[] parameters) {
        double dot = 0.0;
        int li2 = this.map.getLabelIndex(destIndex);
        for (int i = 0; i < this.cache.size(); ++i) {
            int fi = this.cache.get(i);
            OneLabelL2IndPRConstraint constraint = (OneLabelL2IndPRConstraint)this.constraints.get(fi);
            dot += constraint.getScore(li2, parameters);
        }
        return dot;
    }

    @Override
    public void incrementExpectations(FeatureVector input, int inputPosition, int srcIndex, int destIndex, double prob) {
        int li2 = this.map.getLabelIndex(destIndex);
        for (int i = 0; i < this.cache.size(); ++i) {
            ((OneLabelL2IndPRConstraint)this.constraints.get(this.cache.get(i))).incrementExpectation(li2, prob);
        }
    }

    @Override
    public void getExpectations(double[] expectations) {
        assert (expectations.length == this.numDimensions()) : expectations.length + " " + this.numDimensions();
        for (ObjectCursor cursor : this.constraints.values()) {
            ((OneLabelL2IndPRConstraint)cursor.value).getExpectations(expectations);
        }
    }

    @Override
    public void addExpectations(double[] expectations) {
        assert (expectations.length == this.numDimensions());
        for (ObjectCursor cursor : this.constraints.values()) {
            ((OneLabelL2IndPRConstraint)cursor.value).addExpectations(expectations);
        }
    }

    @Override
    public void zeroExpectations() {
        for (ObjectCursor cursor : this.constraints.values()) {
            ((OneLabelL2IndPRConstraint)cursor.value).zeroExpectation();
        }
    }

    @Override
    public double getAuxiliaryValueContribution(double[] parameters) {
        double value = 0.0;
        for (ObjectCursor fi : this.constraints.values()) {
            OneLabelL2IndPRConstraint constraint = (OneLabelL2IndPRConstraint)fi.value;
            value += constraint.getProjectionValueContrib(parameters);
        }
        return value;
    }

    @Override
    public double getCompleteValueContribution(double[] parameters) {
        double value = 0.0;
        for (ObjectCursor fi : this.constraints.values()) {
            OneLabelL2IndPRConstraint constraint = (OneLabelL2IndPRConstraint)fi.value;
            value += constraint.getCompleteValueContrib();
        }
        return value;
    }

    @Override
    public void getGradient(double[] parameters, double[] gradient) {
        for (ObjectCursor fi : this.constraints.values()) {
            OneLabelL2IndPRConstraint constraint = (OneLabelL2IndPRConstraint)fi.value;
            constraint.getGradient(parameters, gradient);
        }
    }

    protected class OneLabelL2IndPRConstraint {
        protected int index = 0;
        protected double count = 0.0;
        protected ArrayList<Integer> labels = new ArrayList();
        protected ArrayList<Integer> paramIndices = new ArrayList();
        protected ArrayList<Double> targets = new ArrayList();
        protected ArrayList<Double> weights = new ArrayList();
        protected HashMap<Integer, Integer> labelMap = new HashMap();
        protected double[] expectation;

        public OneLabelL2IndPRConstraint copy() {
            OneLabelL2IndPRConstraint copy = new OneLabelL2IndPRConstraint();
            copy.index = this.index;
            copy.count = this.count;
            copy.labels = this.labels;
            copy.paramIndices = this.paramIndices;
            copy.targets = this.targets;
            copy.weights = this.weights;
            copy.labelMap = this.labelMap;
            copy.expectation = new double[this.index];
            return copy;
        }

        public void add(int label, double target, double weight, int paramIndex) {
            this.targets.add(target);
            this.weights.add(weight);
            this.labels.add(label);
            this.paramIndices.add(paramIndex);
            this.labelMap.put(label, this.index);
            ++this.index;
        }

        public void zeroExpectation() {
            this.expectation = new double[this.labels.size()];
        }

        public void getExpectations(double[] expectations) {
            for (int i = 0; i < this.paramIndices.size(); ++i) {
                expectations[this.paramIndices.get((int)i).intValue()] = this.expectation[i];
            }
        }

        public void addExpectations(double[] expectations) {
            for (int i = 0; i < this.paramIndices.size(); ++i) {
                int n = i;
                this.expectation[n] = this.expectation[n] + expectations[this.paramIndices.get(i)];
            }
        }

        public void incrementExpectation(int li, double value) {
            if (this.labelMap.containsKey(li)) {
                int i;
                int n = i = this.labelMap.get(li).intValue();
                this.expectation[n] = this.expectation[n] + value;
            }
        }

        public double getScore(int li, double[] parameters) {
            if (this.labelMap.containsKey(li)) {
                int i = this.labelMap.get(li);
                if (OneLabelL2IndPRConstraints.this.normalized) {
                    return parameters[this.paramIndices.get(i)] / this.count;
                }
                return parameters[this.paramIndices.get(i)];
            }
            return 0.0;
        }

        public double getProjectionValueContrib(double[] parameters) {
            double value = 0.0;
            for (int i = 0; i < this.paramIndices.size(); ++i) {
                double param = parameters[this.paramIndices.get(i)];
                value += this.targets.get(i) * param - param * param / (2.0 * this.weights.get(i));
            }
            return value;
        }

        public double getCompleteValueContrib() {
            double value = 0.0;
            for (int i = 0; i < this.paramIndices.size(); ++i) {
                if (OneLabelL2IndPRConstraints.this.normalized) {
                    value += this.weights.get(i) * Math.pow(this.targets.get(i) - this.expectation[i] / this.count, 2.0) / 2.0;
                    continue;
                }
                value += this.weights.get(i) * Math.pow(this.targets.get(i) - this.expectation[i], 2.0) / 2.0;
            }
            return value;
        }

        public void getGradient(double[] parameters, double[] gradient) {
            for (int i = 0; i < this.paramIndices.size(); ++i) {
                int pi = this.paramIndices.get(i);
                if (OneLabelL2IndPRConstraints.this.normalized) {
                    int n = pi;
                    gradient[n] = gradient[n] + (this.targets.get(i) - this.expectation[i] / this.count - parameters[pi] / this.weights.get(i));
                    continue;
                }
                int n = pi;
                gradient[n] = gradient[n] + (this.targets.get(i) - this.expectation[i] - parameters[pi] / this.weights.get(i));
            }
        }

        public int getNumConstrainedLabels() {
            return this.index;
        }
    }
}

