/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import org.ejml.data.Complex64F;
import org.ejml.data.ComplexPolar64F;

public class ComplexMath64F {
    public static void conj(Complex64F complex64F, Complex64F complex64F2) {
        complex64F2.real = complex64F.real;
        complex64F2.imaginary = -complex64F.imaginary;
    }

    public static void plus(Complex64F complex64F, Complex64F complex64F2, Complex64F complex64F3) {
        complex64F3.real = complex64F.real + complex64F2.real;
        complex64F3.imaginary = complex64F.imaginary + complex64F2.imaginary;
    }

    public static void minus(Complex64F complex64F, Complex64F complex64F2, Complex64F complex64F3) {
        complex64F3.real = complex64F.real - complex64F2.real;
        complex64F3.imaginary = complex64F.imaginary - complex64F2.imaginary;
    }

    public static void multiply(Complex64F complex64F, Complex64F complex64F2, Complex64F complex64F3) {
        complex64F3.real = complex64F.real * complex64F2.real - complex64F.imaginary * complex64F2.imaginary;
        complex64F3.imaginary = complex64F.real * complex64F2.imaginary + complex64F.imaginary * complex64F2.real;
    }

    public static void divide(Complex64F complex64F, Complex64F complex64F2, Complex64F complex64F3) {
        double d = complex64F2.getMagnitude2();
        complex64F3.real = (complex64F.real * complex64F2.real + complex64F.imaginary * complex64F2.imaginary) / d;
        complex64F3.imaginary = (complex64F.imaginary * complex64F2.real - complex64F.real * complex64F2.imaginary) / d;
    }

    public static void convert(Complex64F complex64F, ComplexPolar64F complexPolar64F) {
        complexPolar64F.r = complex64F.getMagnitude();
        complexPolar64F.theta = Math.atan2(complex64F.imaginary, complex64F.real);
    }

    public static void convert(ComplexPolar64F complexPolar64F, Complex64F complex64F) {
        complex64F.real = complexPolar64F.r * Math.cos(complexPolar64F.theta);
        complex64F.imaginary = complexPolar64F.r * Math.sin(complexPolar64F.theta);
    }

    public static void multiply(ComplexPolar64F complexPolar64F, ComplexPolar64F complexPolar64F2, ComplexPolar64F complexPolar64F3) {
        complexPolar64F3.r = complexPolar64F.r * complexPolar64F2.r;
        complexPolar64F3.theta = complexPolar64F.theta + complexPolar64F2.theta;
    }

    public static void divide(ComplexPolar64F complexPolar64F, ComplexPolar64F complexPolar64F2, ComplexPolar64F complexPolar64F3) {
        complexPolar64F3.r = complexPolar64F.r / complexPolar64F2.r;
        complexPolar64F3.theta = complexPolar64F.theta - complexPolar64F2.theta;
    }

    public static void pow(ComplexPolar64F complexPolar64F, int n, ComplexPolar64F complexPolar64F2) {
        complexPolar64F2.r = Math.pow(complexPolar64F.r, n);
        complexPolar64F2.theta = (double)n * complexPolar64F.theta;
    }

    public static void root(ComplexPolar64F complexPolar64F, int n, int n2, ComplexPolar64F complexPolar64F2) {
        complexPolar64F2.r = Math.pow(complexPolar64F.r, 1.0 / (double)n);
        complexPolar64F2.theta = (complexPolar64F.theta + 2.0 * (double)n2 * Math.PI) / (double)n;
    }

    public static void root(Complex64F complex64F, int n, int n2, Complex64F complex64F2) {
        double d = complex64F.getMagnitude();
        double d2 = Math.atan2(complex64F.imaginary, complex64F.real);
        d = Math.pow(d, 1.0 / (double)n);
        d2 = (d2 + 2.0 * (double)n2 * Math.PI) / (double)n;
        complex64F2.real = d * Math.cos(d2);
        complex64F2.imaginary = d * Math.sin(d2);
    }

    public static void sqrt(Complex64F complex64F, Complex64F complex64F2) {
        double d = complex64F.getMagnitude();
        double d2 = complex64F.real;
        complex64F2.real = Math.sqrt((d + d2) / 2.0);
        complex64F2.imaginary = Math.sqrt((d - d2) / 2.0);
        if (complex64F.imaginary < 0.0) {
            complex64F2.imaginary = -complex64F2.imaginary;
        }
    }
}

