/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import org.ejml.alg.dense.mult.CVectorVectorMult;
import org.ejml.data.CD1Matrix64F;
import org.ejml.data.CDenseMatrix64F;
import org.ejml.data.Complex64F;
import org.ejml.ops.CCommonOps;
import org.ejml.ops.CNormOps;

public class CSpecializedOps {
    public static CDenseMatrix64F pivotMatrix(CDenseMatrix64F cDenseMatrix64F, int[] nArray, int n, boolean bl) {
        if (cDenseMatrix64F == null) {
            cDenseMatrix64F = new CDenseMatrix64F(n, n);
        } else {
            if (cDenseMatrix64F.numCols != n || cDenseMatrix64F.numRows != n) {
                throw new IllegalArgumentException("Unexpected matrix dimension");
            }
            CCommonOps.fill(cDenseMatrix64F, 0.0, 0.0);
        }
        if (bl) {
            for (int i = 0; i < n; ++i) {
                cDenseMatrix64F.set(nArray[i], i, 1.0, 0.0);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                cDenseMatrix64F.set(i, nArray[i], 1.0, 0.0);
            }
        }
        return cDenseMatrix64F;
    }

    public static double elementDiagMaxMagnitude2(CDenseMatrix64F cDenseMatrix64F) {
        int n = Math.min(cDenseMatrix64F.numRows, cDenseMatrix64F.numCols);
        int n2 = cDenseMatrix64F.getRowStride();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            int n3 = i * n2 + i * 2;
            double d2 = cDenseMatrix64F.data[n3];
            double d3 = cDenseMatrix64F.data[n3 + 1];
            double d4 = d2 * d2 + d3 * d3;
            if (!(d4 > d)) continue;
            d = d4;
        }
        return d;
    }

    public static double qualityTriangular(CDenseMatrix64F cDenseMatrix64F) {
        int n = Math.min(cDenseMatrix64F.numRows, cDenseMatrix64F.numCols);
        double d = CSpecializedOps.elementDiagMaxMagnitude2(cDenseMatrix64F);
        if (d == 0.0) {
            return 0.0;
        }
        d = Math.sqrt(d);
        int n2 = cDenseMatrix64F.getRowStride();
        double d2 = 1.0;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            int n3 = i * n2 + i * 2;
            double d4 = cDenseMatrix64F.data[n3] / d;
            double d5 = cDenseMatrix64F.data[n3] / d;
            double d6 = d2 * d4 - d3 * d5;
            double d7 = d2 * d5 + d4 * d3;
            d2 = d6;
            d3 = d7;
        }
        return Math.sqrt(d2 * d2 + d3 * d3);
    }

    public static CDenseMatrix64F householder(CDenseMatrix64F cDenseMatrix64F, double d) {
        int n = cDenseMatrix64F.getDataLength() / 2;
        CDenseMatrix64F cDenseMatrix64F2 = new CDenseMatrix64F(n, n);
        CVectorVectorMult.outerProdH(cDenseMatrix64F, cDenseMatrix64F, cDenseMatrix64F2);
        CCommonOps.elementMultiply(cDenseMatrix64F2, -d, 0.0, cDenseMatrix64F2);
        for (int i = 0; i < n; ++i) {
            int n2 = (i * cDenseMatrix64F2.numCols + i) * 2;
            cDenseMatrix64F2.data[n2] = 1.0 + cDenseMatrix64F2.data[n2];
        }
        return cDenseMatrix64F2;
    }

    public static CDenseMatrix64F householderVector(CDenseMatrix64F cDenseMatrix64F) {
        double d;
        double d2;
        CDenseMatrix64F cDenseMatrix64F2 = cDenseMatrix64F.copy();
        double d3 = CCommonOps.elementMaxAbs(cDenseMatrix64F2);
        CCommonOps.elementDivide(cDenseMatrix64F2, d3, 0.0, (CD1Matrix64F)cDenseMatrix64F2);
        double d4 = CNormOps.normF(cDenseMatrix64F2);
        Complex64F complex64F = new Complex64F();
        cDenseMatrix64F2.get(0, 0, complex64F);
        if (complex64F.getMagnitude() == 0.0) {
            d2 = d4;
            d = 0.0;
        } else {
            d2 = complex64F.real / complex64F.getMagnitude() * d4;
            d = complex64F.imaginary / complex64F.getMagnitude() * d4;
        }
        cDenseMatrix64F2.set(0, 0, complex64F.real + d2, complex64F.imaginary + d);
        CCommonOps.elementDivide(cDenseMatrix64F2, cDenseMatrix64F2.getReal(0, 0), cDenseMatrix64F2.getImaginary(0, 0), (CD1Matrix64F)cDenseMatrix64F2);
        return cDenseMatrix64F2;
    }
}

