/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import org.ejml.alg.dense.decompose.chol.CholeskyDecompositionInner_CD64;
import org.ejml.alg.dense.mult.CVectorVectorMult;
import org.ejml.data.CD1Matrix64F;
import org.ejml.data.CDenseMatrix64F;
import org.ejml.data.Complex64F;
import org.ejml.data.ComplexMatrix64F;
import org.ejml.ops.CCommonOps;

public class CMatrixFeatures {
    public static boolean hasNaN(CD1Matrix64F cD1Matrix64F) {
        int n = cD1Matrix64F.getDataLength();
        for (int i = 0; i < n; ++i) {
            if (!Double.isNaN(cD1Matrix64F.data[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean hasUncountable(CD1Matrix64F cD1Matrix64F) {
        int n = cD1Matrix64F.getDataLength();
        for (int i = 0; i < n; ++i) {
            double d = cD1Matrix64F.data[i];
            if (!Double.isNaN(d) && !Double.isInfinite(d)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEquals(CD1Matrix64F cD1Matrix64F, CD1Matrix64F cD1Matrix64F2) {
        if (cD1Matrix64F.numRows != cD1Matrix64F2.numRows || cD1Matrix64F.numCols != cD1Matrix64F2.numCols) {
            return false;
        }
        int n = cD1Matrix64F.getDataLength();
        for (int i = 0; i < n; ++i) {
            if (cD1Matrix64F.data[i] == cD1Matrix64F2.data[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isEquals(CD1Matrix64F cD1Matrix64F, CD1Matrix64F cD1Matrix64F2, double d) {
        if (cD1Matrix64F.numRows != cD1Matrix64F2.numRows || cD1Matrix64F.numCols != cD1Matrix64F2.numCols) {
            return false;
        }
        if (d == 0.0) {
            return CMatrixFeatures.isEquals(cD1Matrix64F, cD1Matrix64F2);
        }
        int n = cD1Matrix64F.getDataLength();
        for (int i = 0; i < n; ++i) {
            if (d >= Math.abs(cD1Matrix64F.data[i] - cD1Matrix64F2.data[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isIdentical(CD1Matrix64F cD1Matrix64F, CD1Matrix64F cD1Matrix64F2, double d) {
        if (cD1Matrix64F.numRows != cD1Matrix64F2.numRows || cD1Matrix64F.numCols != cD1Matrix64F2.numCols) {
            return false;
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("Tolerance must be greater than or equal to zero.");
        }
        int n = cD1Matrix64F.getDataLength();
        for (int i = 0; i < n; ++i) {
            double d2 = cD1Matrix64F.data[i];
            double d3 = cD1Matrix64F2.data[i];
            double d4 = Math.abs(d2 - d3);
            if (d >= d4) continue;
            if (Double.isNaN(d2)) {
                return Double.isNaN(d3);
            }
            if (Double.isInfinite(d2)) {
                return d2 == d3;
            }
            return false;
        }
        return true;
    }

    public static boolean isIdentity(ComplexMatrix64F complexMatrix64F, double d) {
        Complex64F complex64F = new Complex64F();
        for (int i = 0; i < complexMatrix64F.getNumRows(); ++i) {
            for (int j = 0; j < complexMatrix64F.getNumCols(); ++j) {
                complexMatrix64F.get(i, j, complex64F);
                if (i == j) {
                    if (!(Math.abs(complex64F.real - 1.0) <= d)) {
                        return false;
                    }
                    if (Math.abs(complex64F.imaginary) <= d) continue;
                    return false;
                }
                if (!(Math.abs(complex64F.real) <= d)) {
                    return false;
                }
                if (Math.abs(complex64F.imaginary) <= d) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isHermitian(CDenseMatrix64F cDenseMatrix64F, double d) {
        if (cDenseMatrix64F.numCols != cDenseMatrix64F.numRows) {
            return false;
        }
        Complex64F complex64F = new Complex64F();
        Complex64F complex64F2 = new Complex64F();
        for (int i = 0; i < cDenseMatrix64F.numCols; ++i) {
            for (int j = i + 1; j < cDenseMatrix64F.numCols; ++j) {
                cDenseMatrix64F.get(i, j, complex64F);
                cDenseMatrix64F.get(j, i, complex64F2);
                if (Math.abs(complex64F.real - complex64F2.real) > d) {
                    return false;
                }
                if (!(Math.abs(complex64F.imaginary + complex64F2.imaginary) > d)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isUnitary(CDenseMatrix64F cDenseMatrix64F, double d) {
        if (cDenseMatrix64F.numRows < cDenseMatrix64F.numCols) {
            throw new IllegalArgumentException("The number of rows must be more than or equal to the number of columns");
        }
        Complex64F complex64F = new Complex64F();
        CDenseMatrix64F[] cDenseMatrix64FArray = CCommonOps.columnsToVector(cDenseMatrix64F, null);
        for (int i = 0; i < cDenseMatrix64FArray.length; ++i) {
            CDenseMatrix64F cDenseMatrix64F2 = cDenseMatrix64FArray[i];
            CVectorVectorMult.innerProdH(cDenseMatrix64F2, cDenseMatrix64F2, complex64F);
            if (Math.abs(complex64F.real - 1.0) > d) {
                return false;
            }
            if (Math.abs(complex64F.imaginary) > d) {
                return false;
            }
            for (int j = i + 1; j < cDenseMatrix64FArray.length; ++j) {
                CVectorVectorMult.innerProdH(cDenseMatrix64F2, cDenseMatrix64FArray[j], complex64F);
                if (complex64F.getMagnitude2() <= d * d) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isPositiveDefinite(CDenseMatrix64F cDenseMatrix64F) {
        if (cDenseMatrix64F.numCols != cDenseMatrix64F.numRows) {
            return false;
        }
        CholeskyDecompositionInner_CD64 choleskyDecompositionInner_CD64 = new CholeskyDecompositionInner_CD64(true);
        if (choleskyDecompositionInner_CD64.inputModified()) {
            cDenseMatrix64F = cDenseMatrix64F.copy();
        }
        return choleskyDecompositionInner_CD64.decompose(cDenseMatrix64F);
    }
}

