/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.data;

import org.ejml.data.FixedMatrix64F;
import org.ejml.data.Matrix;
import org.ejml.data.RealMatrix64F;
import org.ejml.ops.MatrixIO;

public class FixedMatrix6_64F
implements FixedMatrix64F {
    public double a1;
    public double a2;
    public double a3;
    public double a4;
    public double a5;
    public double a6;

    public FixedMatrix6_64F() {
    }

    public FixedMatrix6_64F(double d, double d2, double d3, double d4, double d5, double d6) {
        this.a1 = d;
        this.a2 = d2;
        this.a3 = d3;
        this.a4 = d4;
        this.a5 = d5;
        this.a6 = d6;
    }

    public FixedMatrix6_64F(FixedMatrix6_64F fixedMatrix6_64F) {
        this.a1 = fixedMatrix6_64F.a1;
        this.a2 = fixedMatrix6_64F.a2;
        this.a3 = fixedMatrix6_64F.a3;
        this.a4 = fixedMatrix6_64F.a4;
        this.a5 = fixedMatrix6_64F.a5;
        this.a6 = fixedMatrix6_64F.a6;
    }

    @Override
    public double get(int n, int n2) {
        return this.unsafe_get(n, n2);
    }

    @Override
    public double unsafe_get(int n, int n2) {
        if (n != 0 && n2 != 0) {
            throw new IllegalArgumentException("Row or column must be zero since this is a vector");
        }
        int n3 = Math.max(n, n2);
        if (n3 == 0) {
            return this.a1;
        }
        if (n3 == 1) {
            return this.a2;
        }
        if (n3 == 2) {
            return this.a3;
        }
        if (n3 == 3) {
            return this.a4;
        }
        if (n3 == 4) {
            return this.a5;
        }
        if (n3 == 5) {
            return this.a6;
        }
        throw new IllegalArgumentException("Out of range.  " + n3);
    }

    @Override
    public void set(int n, int n2, double d) {
        this.unsafe_set(n, n2, d);
    }

    @Override
    public void unsafe_set(int n, int n2, double d) {
        if (n != 0 && n2 != 0) {
            throw new IllegalArgumentException("Row or column must be zero since this is a vector");
        }
        int n3 = Math.max(n, n2);
        if (n3 == 0) {
            this.a1 = d;
        } else if (n3 == 1) {
            this.a2 = d;
        } else if (n3 == 2) {
            this.a3 = d;
        } else if (n3 == 3) {
            this.a4 = d;
        } else if (n3 == 4) {
            this.a5 = d;
        } else if (n3 == 5) {
            this.a6 = d;
        } else {
            throw new IllegalArgumentException("Out of range.  " + n3);
        }
    }

    @Override
    public void set(Matrix matrix) {
        RealMatrix64F realMatrix64F = (RealMatrix64F)matrix;
        if (realMatrix64F.getNumCols() == 1 && realMatrix64F.getNumRows() == 6) {
            this.a1 = realMatrix64F.get(0, 0);
            this.a2 = realMatrix64F.get(1, 0);
            this.a3 = realMatrix64F.get(2, 0);
            this.a4 = realMatrix64F.get(3, 0);
            this.a5 = realMatrix64F.get(4, 0);
            this.a6 = realMatrix64F.get(5, 0);
        } else if (realMatrix64F.getNumRows() == 1 && realMatrix64F.getNumCols() == 6) {
            this.a1 = realMatrix64F.get(0, 0);
            this.a2 = realMatrix64F.get(0, 1);
            this.a3 = realMatrix64F.get(0, 2);
            this.a4 = realMatrix64F.get(0, 3);
            this.a5 = realMatrix64F.get(0, 4);
            this.a6 = realMatrix64F.get(0, 5);
        } else {
            throw new IllegalArgumentException("Incompatible shape");
        }
    }

    @Override
    public int getNumRows() {
        return 6;
    }

    @Override
    public int getNumCols() {
        return 1;
    }

    @Override
    public int getNumElements() {
        return 6;
    }

    @Override
    public <T extends Matrix> T copy() {
        return (T)new FixedMatrix6_64F(this);
    }

    @Override
    public void print() {
        MatrixIO.print(System.out, this);
    }
}

