/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.mult;

import org.ejml.data.D1Matrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.ops.CommonOps;
import org.ejml.ops.MatrixDimensionException;

public class MatrixVectorMult {
    public static void mult(RowD1Matrix64F rowD1Matrix64F, D1Matrix64F d1Matrix64F, D1Matrix64F d1Matrix64F2) {
        if (d1Matrix64F2.numCols != 1) {
            throw new MatrixDimensionException("C is not a column vector");
        }
        if (d1Matrix64F2.numRows != rowD1Matrix64F.numRows) {
            throw new MatrixDimensionException("C is not the expected length");
        }
        if (d1Matrix64F.numRows == 1) {
            if (rowD1Matrix64F.numCols != d1Matrix64F.numCols) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else if (d1Matrix64F.numCols == 1) {
            if (rowD1Matrix64F.numCols != d1Matrix64F.numRows) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else {
            throw new MatrixDimensionException("B is not a vector");
        }
        if (rowD1Matrix64F.numCols == 0) {
            CommonOps.fill(d1Matrix64F2, 0.0);
            return;
        }
        int n = 0;
        int n2 = 0;
        double d = d1Matrix64F.get(0);
        for (int i = 0; i < rowD1Matrix64F.numRows; ++i) {
            double d2 = rowD1Matrix64F.get(n++) * d;
            for (int j = 1; j < rowD1Matrix64F.numCols; ++j) {
                d2 += rowD1Matrix64F.get(n++) * d1Matrix64F.get(j);
            }
            d1Matrix64F2.set(n2++, d2);
        }
    }

    public static void multAdd(RowD1Matrix64F rowD1Matrix64F, D1Matrix64F d1Matrix64F, D1Matrix64F d1Matrix64F2) {
        if (d1Matrix64F2.numCols != 1) {
            throw new MatrixDimensionException("C is not a column vector");
        }
        if (d1Matrix64F2.numRows != rowD1Matrix64F.numRows) {
            throw new MatrixDimensionException("C is not the expected length");
        }
        if (d1Matrix64F.numRows == 1) {
            if (rowD1Matrix64F.numCols != d1Matrix64F.numCols) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else if (d1Matrix64F.numCols == 1) {
            if (rowD1Matrix64F.numCols != d1Matrix64F.numRows) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else {
            throw new MatrixDimensionException("B is not a vector");
        }
        if (rowD1Matrix64F.numCols == 0) {
            return;
        }
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < rowD1Matrix64F.numRows; ++i) {
            double d = rowD1Matrix64F.get(n++) * d1Matrix64F.get(0);
            for (int j = 1; j < rowD1Matrix64F.numCols; ++j) {
                d += rowD1Matrix64F.get(n++) * d1Matrix64F.get(j);
            }
            d1Matrix64F2.plus(n2++, d);
        }
    }

    public static void multTransA_small(RowD1Matrix64F rowD1Matrix64F, D1Matrix64F d1Matrix64F, D1Matrix64F d1Matrix64F2) {
        if (d1Matrix64F2.numCols != 1) {
            throw new MatrixDimensionException("C is not a column vector");
        }
        if (d1Matrix64F2.numRows != rowD1Matrix64F.numCols) {
            throw new MatrixDimensionException("C is not the expected length");
        }
        if (d1Matrix64F.numRows == 1) {
            if (rowD1Matrix64F.numRows != d1Matrix64F.numCols) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else if (d1Matrix64F.numCols == 1) {
            if (rowD1Matrix64F.numRows != d1Matrix64F.numRows) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else {
            throw new MatrixDimensionException("B is not a vector");
        }
        int n = 0;
        for (int i = 0; i < rowD1Matrix64F.numCols; ++i) {
            double d = 0.0;
            int n2 = i;
            for (int j = 0; j < rowD1Matrix64F.numRows; ++j) {
                d += rowD1Matrix64F.get(n2) * d1Matrix64F.get(j);
                n2 += rowD1Matrix64F.numCols;
            }
            d1Matrix64F2.set(n++, d);
        }
    }

    public static void multTransA_reorder(RowD1Matrix64F rowD1Matrix64F, D1Matrix64F d1Matrix64F, D1Matrix64F d1Matrix64F2) {
        int n;
        if (d1Matrix64F2.numCols != 1) {
            throw new MatrixDimensionException("C is not a column vector");
        }
        if (d1Matrix64F2.numRows != rowD1Matrix64F.numCols) {
            throw new MatrixDimensionException("C is not the expected length");
        }
        if (d1Matrix64F.numRows == 1) {
            if (rowD1Matrix64F.numRows != d1Matrix64F.numCols) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else if (d1Matrix64F.numCols == 1) {
            if (rowD1Matrix64F.numRows != d1Matrix64F.numRows) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else {
            throw new MatrixDimensionException("B is not a vector");
        }
        if (rowD1Matrix64F.numRows == 0) {
            CommonOps.fill(d1Matrix64F2, 0.0);
            return;
        }
        double d = d1Matrix64F.get(0);
        for (n = 0; n < rowD1Matrix64F.numCols; ++n) {
            d1Matrix64F2.set(n, rowD1Matrix64F.get(n) * d);
        }
        n = rowD1Matrix64F.numCols;
        for (int i = 1; i < rowD1Matrix64F.numRows; ++i) {
            d = d1Matrix64F.get(i);
            for (int j = 0; j < rowD1Matrix64F.numCols; ++j) {
                d1Matrix64F2.plus(j, rowD1Matrix64F.get(n++) * d);
            }
        }
    }

    public static void multAddTransA_small(RowD1Matrix64F rowD1Matrix64F, D1Matrix64F d1Matrix64F, D1Matrix64F d1Matrix64F2) {
        if (d1Matrix64F2.numCols != 1) {
            throw new MatrixDimensionException("C is not a column vector");
        }
        if (d1Matrix64F2.numRows != rowD1Matrix64F.numCols) {
            throw new MatrixDimensionException("C is not the expected length");
        }
        if (d1Matrix64F.numRows == 1) {
            if (rowD1Matrix64F.numRows != d1Matrix64F.numCols) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else if (d1Matrix64F.numCols == 1) {
            if (rowD1Matrix64F.numRows != d1Matrix64F.numRows) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else {
            throw new MatrixDimensionException("B is not a vector");
        }
        int n = 0;
        for (int i = 0; i < rowD1Matrix64F.numCols; ++i) {
            double d = 0.0;
            int n2 = i;
            for (int j = 0; j < rowD1Matrix64F.numRows; ++j) {
                d += rowD1Matrix64F.get(n2) * d1Matrix64F.get(j);
                n2 += rowD1Matrix64F.numCols;
            }
            d1Matrix64F2.plus(n++, d);
        }
    }

    public static void multAddTransA_reorder(RowD1Matrix64F rowD1Matrix64F, D1Matrix64F d1Matrix64F, D1Matrix64F d1Matrix64F2) {
        if (d1Matrix64F2.numCols != 1) {
            throw new MatrixDimensionException("C is not a column vector");
        }
        if (d1Matrix64F2.numRows != rowD1Matrix64F.numCols) {
            throw new MatrixDimensionException("C is not the expected length");
        }
        if (d1Matrix64F.numRows == 1) {
            if (rowD1Matrix64F.numRows != d1Matrix64F.numCols) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else if (d1Matrix64F.numCols == 1) {
            if (rowD1Matrix64F.numRows != d1Matrix64F.numRows) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else {
            throw new MatrixDimensionException("B is not a vector");
        }
        if (rowD1Matrix64F.numRows == 0) {
            return;
        }
        int n = 0;
        for (int i = 0; i < rowD1Matrix64F.numRows; ++i) {
            double d = d1Matrix64F.get(i);
            for (int j = 0; j < rowD1Matrix64F.numCols; ++j) {
                d1Matrix64F2.plus(j, rowD1Matrix64F.get(n++) * d);
            }
        }
    }
}

