/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.mult;

import org.ejml.data.RowD1Matrix64F;
import org.ejml.ops.CommonOps;
import org.ejml.ops.MatrixDimensionException;

public class MatrixMatrixMult {
    public static void mult_reorder(RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F == rowD1Matrix64F3 || rowD1Matrix64F2 == rowD1Matrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (rowD1Matrix64F.numCols != rowD1Matrix64F2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (rowD1Matrix64F.numRows != rowD1Matrix64F3.numRows || rowD1Matrix64F2.numCols != rowD1Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (rowD1Matrix64F.numCols == 0 || rowD1Matrix64F.numRows == 0) {
            CommonOps.fill(rowD1Matrix64F3, 0.0);
            return;
        }
        int n = 0;
        int n2 = rowD1Matrix64F2.numRows * rowD1Matrix64F2.numCols;
        for (int i = 0; i < rowD1Matrix64F.numRows; ++i) {
            int n3 = i * rowD1Matrix64F.numCols;
            int n4 = 0;
            int n5 = n;
            int n6 = n4 + rowD1Matrix64F2.numCols;
            double d = rowD1Matrix64F.get(n3++);
            while (n4 < n6) {
                rowD1Matrix64F3.set(n5++, d * rowD1Matrix64F2.get(n4++));
            }
            while (n4 != n2) {
                n5 = n;
                n6 = n4 + rowD1Matrix64F2.numCols;
                d = rowD1Matrix64F.get(n3++);
                while (n4 < n6) {
                    rowD1Matrix64F3.plus(n5++, d * rowD1Matrix64F2.get(n4++));
                }
            }
            n += rowD1Matrix64F3.numCols;
        }
    }

    public static void mult_small(RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F == rowD1Matrix64F3 || rowD1Matrix64F2 == rowD1Matrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (rowD1Matrix64F.numCols != rowD1Matrix64F2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (rowD1Matrix64F.numRows != rowD1Matrix64F3.numRows || rowD1Matrix64F2.numCols != rowD1Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < rowD1Matrix64F.numRows; ++i) {
            for (int j = 0; j < rowD1Matrix64F2.numCols; ++j) {
                double d = 0.0;
                int n3 = n;
                int n4 = j;
                int n5 = n3 + rowD1Matrix64F2.numRows;
                while (n3 < n5) {
                    d += rowD1Matrix64F.get(n3++) * rowD1Matrix64F2.get(n4);
                    n4 += rowD1Matrix64F2.numCols;
                }
                rowD1Matrix64F3.set(n2++, d);
            }
            n += rowD1Matrix64F.numCols;
        }
    }

    public static void mult_aux(RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3, double[] dArray) {
        if (rowD1Matrix64F == rowD1Matrix64F3 || rowD1Matrix64F2 == rowD1Matrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (rowD1Matrix64F.numCols != rowD1Matrix64F2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (rowD1Matrix64F.numRows != rowD1Matrix64F3.numRows || rowD1Matrix64F2.numCols != rowD1Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (dArray == null) {
            dArray = new double[rowD1Matrix64F2.numRows];
        }
        for (int i = 0; i < rowD1Matrix64F2.numCols; ++i) {
            int n;
            for (n = 0; n < rowD1Matrix64F2.numRows; ++n) {
                dArray[n] = rowD1Matrix64F2.unsafe_get(n, i);
            }
            n = 0;
            for (int j = 0; j < rowD1Matrix64F.numRows; ++j) {
                double d = 0.0;
                int n2 = 0;
                while (n2 < rowD1Matrix64F2.numRows) {
                    d += rowD1Matrix64F.get(n++) * dArray[n2++];
                }
                rowD1Matrix64F3.set(j * rowD1Matrix64F3.numCols + i, d);
            }
        }
    }

    public static void multTransA_reorder(RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F == rowD1Matrix64F3 || rowD1Matrix64F2 == rowD1Matrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (rowD1Matrix64F.numRows != rowD1Matrix64F2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (rowD1Matrix64F.numCols != rowD1Matrix64F3.numRows || rowD1Matrix64F2.numCols != rowD1Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (rowD1Matrix64F.numCols == 0 || rowD1Matrix64F.numRows == 0) {
            CommonOps.fill(rowD1Matrix64F3, 0.0);
            return;
        }
        for (int i = 0; i < rowD1Matrix64F.numCols; ++i) {
            int n = i * rowD1Matrix64F3.numCols;
            double d = rowD1Matrix64F.get(i);
            int n2 = 0;
            int n3 = n2 + rowD1Matrix64F2.numCols;
            int n4 = n;
            while (n2 < n3) {
                rowD1Matrix64F3.set(n4++, d * rowD1Matrix64F2.get(n2++));
            }
            for (int j = 1; j < rowD1Matrix64F.numRows; ++j) {
                d = rowD1Matrix64F.unsafe_get(j, i);
                n3 = n2 + rowD1Matrix64F2.numCols;
                n4 = n;
                while (n2 < n3) {
                    rowD1Matrix64F3.plus(n4++, d * rowD1Matrix64F2.get(n2++));
                }
            }
        }
    }

    public static void multTransA_small(RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F == rowD1Matrix64F3 || rowD1Matrix64F2 == rowD1Matrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (rowD1Matrix64F.numRows != rowD1Matrix64F2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (rowD1Matrix64F.numCols != rowD1Matrix64F3.numRows || rowD1Matrix64F2.numCols != rowD1Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int n = 0;
        for (int i = 0; i < rowD1Matrix64F.numCols; ++i) {
            for (int j = 0; j < rowD1Matrix64F2.numCols; ++j) {
                int n2;
                int n3 = i;
                int n4 = n2 + rowD1Matrix64F2.numRows * rowD1Matrix64F2.numCols;
                double d = 0.0;
                for (n2 = j; n2 < n4; n2 += rowD1Matrix64F2.numCols) {
                    d += rowD1Matrix64F.get(n3) * rowD1Matrix64F2.get(n2);
                    n3 += rowD1Matrix64F.numCols;
                }
                rowD1Matrix64F3.set(n++, d);
            }
        }
    }

    public static void multTransAB(RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F == rowD1Matrix64F3 || rowD1Matrix64F2 == rowD1Matrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (rowD1Matrix64F.numRows != rowD1Matrix64F2.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (rowD1Matrix64F.numCols != rowD1Matrix64F3.numRows || rowD1Matrix64F2.numRows != rowD1Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int n = 0;
        for (int i = 0; i < rowD1Matrix64F.numCols; ++i) {
            int n2 = 0;
            for (int j = 0; j < rowD1Matrix64F2.numRows; ++j) {
                int n3 = i;
                int n4 = n2 + rowD1Matrix64F2.numCols;
                double d = 0.0;
                while (n2 < n4) {
                    d += rowD1Matrix64F.get(n3) * rowD1Matrix64F2.get(n2++);
                    n3 += rowD1Matrix64F.numCols;
                }
                rowD1Matrix64F3.set(n++, d);
            }
        }
    }

    public static void multTransAB_aux(RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3, double[] dArray) {
        if (rowD1Matrix64F == rowD1Matrix64F3 || rowD1Matrix64F2 == rowD1Matrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (rowD1Matrix64F.numRows != rowD1Matrix64F2.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (rowD1Matrix64F.numCols != rowD1Matrix64F3.numRows || rowD1Matrix64F2.numRows != rowD1Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (dArray == null) {
            dArray = new double[rowD1Matrix64F.numRows];
        }
        if (rowD1Matrix64F.numCols == 0 || rowD1Matrix64F.numRows == 0) {
            CommonOps.fill(rowD1Matrix64F3, 0.0);
            return;
        }
        int n = 0;
        for (int i = 0; i < rowD1Matrix64F.numCols; ++i) {
            int n2;
            for (n2 = 0; n2 < rowD1Matrix64F2.numCols; ++n2) {
                dArray[n2] = rowD1Matrix64F.unsafe_get(n2, i);
            }
            for (n2 = 0; n2 < rowD1Matrix64F2.numRows; ++n2) {
                double d = 0.0;
                for (int j = 0; j < rowD1Matrix64F2.numCols; ++j) {
                    d += dArray[j] * rowD1Matrix64F2.unsafe_get(n2, j);
                }
                rowD1Matrix64F3.set(n++, d);
            }
        }
    }

    public static void multTransB(RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F == rowD1Matrix64F3 || rowD1Matrix64F2 == rowD1Matrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (rowD1Matrix64F.numCols != rowD1Matrix64F2.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (rowD1Matrix64F.numRows != rowD1Matrix64F3.numRows || rowD1Matrix64F2.numRows != rowD1Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < rowD1Matrix64F.numRows; ++i) {
            int n3 = n2 + rowD1Matrix64F2.numCols;
            int n4 = 0;
            for (int j = 0; j < rowD1Matrix64F2.numRows; ++j) {
                int n5 = n2;
                double d = 0.0;
                while (n5 < n3) {
                    d += rowD1Matrix64F.get(n5++) * rowD1Matrix64F2.get(n4++);
                }
                rowD1Matrix64F3.set(n++, d);
            }
            n2 += rowD1Matrix64F.numCols;
        }
    }

    public static void multAdd_reorder(RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F == rowD1Matrix64F3 || rowD1Matrix64F2 == rowD1Matrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (rowD1Matrix64F.numCols != rowD1Matrix64F2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (rowD1Matrix64F.numRows != rowD1Matrix64F3.numRows || rowD1Matrix64F2.numCols != rowD1Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (rowD1Matrix64F.numCols == 0 || rowD1Matrix64F.numRows == 0) {
            return;
        }
        int n = 0;
        int n2 = rowD1Matrix64F2.numRows * rowD1Matrix64F2.numCols;
        for (int i = 0; i < rowD1Matrix64F.numRows; ++i) {
            int n3 = i * rowD1Matrix64F.numCols;
            int n4 = 0;
            int n5 = n;
            int n6 = n4 + rowD1Matrix64F2.numCols;
            double d = rowD1Matrix64F.get(n3++);
            while (n4 < n6) {
                rowD1Matrix64F3.plus(n5++, d * rowD1Matrix64F2.get(n4++));
            }
            while (n4 != n2) {
                n5 = n;
                n6 = n4 + rowD1Matrix64F2.numCols;
                d = rowD1Matrix64F.get(n3++);
                while (n4 < n6) {
                    rowD1Matrix64F3.plus(n5++, d * rowD1Matrix64F2.get(n4++));
                }
            }
            n += rowD1Matrix64F3.numCols;
        }
    }

    public static void multAdd_small(RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F == rowD1Matrix64F3 || rowD1Matrix64F2 == rowD1Matrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (rowD1Matrix64F.numCols != rowD1Matrix64F2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (rowD1Matrix64F.numRows != rowD1Matrix64F3.numRows || rowD1Matrix64F2.numCols != rowD1Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < rowD1Matrix64F.numRows; ++i) {
            for (int j = 0; j < rowD1Matrix64F2.numCols; ++j) {
                double d = 0.0;
                int n3 = n;
                int n4 = j;
                int n5 = n3 + rowD1Matrix64F2.numRows;
                while (n3 < n5) {
                    d += rowD1Matrix64F.get(n3++) * rowD1Matrix64F2.get(n4);
                    n4 += rowD1Matrix64F2.numCols;
                }
                rowD1Matrix64F3.plus(n2++, d);
            }
            n += rowD1Matrix64F.numCols;
        }
    }

    public static void multAdd_aux(RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3, double[] dArray) {
        if (rowD1Matrix64F == rowD1Matrix64F3 || rowD1Matrix64F2 == rowD1Matrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (rowD1Matrix64F.numCols != rowD1Matrix64F2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (rowD1Matrix64F.numRows != rowD1Matrix64F3.numRows || rowD1Matrix64F2.numCols != rowD1Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (dArray == null) {
            dArray = new double[rowD1Matrix64F2.numRows];
        }
        for (int i = 0; i < rowD1Matrix64F2.numCols; ++i) {
            int n;
            for (n = 0; n < rowD1Matrix64F2.numRows; ++n) {
                dArray[n] = rowD1Matrix64F2.unsafe_get(n, i);
            }
            n = 0;
            for (int j = 0; j < rowD1Matrix64F.numRows; ++j) {
                double d = 0.0;
                int n2 = 0;
                while (n2 < rowD1Matrix64F2.numRows) {
                    d += rowD1Matrix64F.get(n++) * dArray[n2++];
                }
                rowD1Matrix64F3.plus(j * rowD1Matrix64F3.numCols + i, d);
            }
        }
    }

    public static void multAddTransA_reorder(RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F == rowD1Matrix64F3 || rowD1Matrix64F2 == rowD1Matrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (rowD1Matrix64F.numRows != rowD1Matrix64F2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (rowD1Matrix64F.numCols != rowD1Matrix64F3.numRows || rowD1Matrix64F2.numCols != rowD1Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (rowD1Matrix64F.numCols == 0 || rowD1Matrix64F.numRows == 0) {
            return;
        }
        for (int i = 0; i < rowD1Matrix64F.numCols; ++i) {
            int n = i * rowD1Matrix64F3.numCols;
            double d = rowD1Matrix64F.get(i);
            int n2 = 0;
            int n3 = n2 + rowD1Matrix64F2.numCols;
            int n4 = n;
            while (n2 < n3) {
                rowD1Matrix64F3.plus(n4++, d * rowD1Matrix64F2.get(n2++));
            }
            for (int j = 1; j < rowD1Matrix64F.numRows; ++j) {
                d = rowD1Matrix64F.unsafe_get(j, i);
                n3 = n2 + rowD1Matrix64F2.numCols;
                n4 = n;
                while (n2 < n3) {
                    rowD1Matrix64F3.plus(n4++, d * rowD1Matrix64F2.get(n2++));
                }
            }
        }
    }

    public static void multAddTransA_small(RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F == rowD1Matrix64F3 || rowD1Matrix64F2 == rowD1Matrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (rowD1Matrix64F.numRows != rowD1Matrix64F2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (rowD1Matrix64F.numCols != rowD1Matrix64F3.numRows || rowD1Matrix64F2.numCols != rowD1Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int n = 0;
        for (int i = 0; i < rowD1Matrix64F.numCols; ++i) {
            for (int j = 0; j < rowD1Matrix64F2.numCols; ++j) {
                int n2;
                int n3 = i;
                int n4 = n2 + rowD1Matrix64F2.numRows * rowD1Matrix64F2.numCols;
                double d = 0.0;
                for (n2 = j; n2 < n4; n2 += rowD1Matrix64F2.numCols) {
                    d += rowD1Matrix64F.get(n3) * rowD1Matrix64F2.get(n2);
                    n3 += rowD1Matrix64F.numCols;
                }
                rowD1Matrix64F3.plus(n++, d);
            }
        }
    }

    public static void multAddTransAB(RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F == rowD1Matrix64F3 || rowD1Matrix64F2 == rowD1Matrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (rowD1Matrix64F.numRows != rowD1Matrix64F2.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (rowD1Matrix64F.numCols != rowD1Matrix64F3.numRows || rowD1Matrix64F2.numRows != rowD1Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int n = 0;
        for (int i = 0; i < rowD1Matrix64F.numCols; ++i) {
            int n2 = 0;
            for (int j = 0; j < rowD1Matrix64F2.numRows; ++j) {
                int n3 = i;
                int n4 = n2 + rowD1Matrix64F2.numCols;
                double d = 0.0;
                while (n2 < n4) {
                    d += rowD1Matrix64F.get(n3) * rowD1Matrix64F2.get(n2++);
                    n3 += rowD1Matrix64F.numCols;
                }
                rowD1Matrix64F3.plus(n++, d);
            }
        }
    }

    public static void multAddTransAB_aux(RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3, double[] dArray) {
        if (rowD1Matrix64F == rowD1Matrix64F3 || rowD1Matrix64F2 == rowD1Matrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (rowD1Matrix64F.numRows != rowD1Matrix64F2.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (rowD1Matrix64F.numCols != rowD1Matrix64F3.numRows || rowD1Matrix64F2.numRows != rowD1Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (dArray == null) {
            dArray = new double[rowD1Matrix64F.numRows];
        }
        if (rowD1Matrix64F.numCols == 0 || rowD1Matrix64F.numRows == 0) {
            return;
        }
        int n = 0;
        for (int i = 0; i < rowD1Matrix64F.numCols; ++i) {
            int n2;
            for (n2 = 0; n2 < rowD1Matrix64F2.numCols; ++n2) {
                dArray[n2] = rowD1Matrix64F.unsafe_get(n2, i);
            }
            for (n2 = 0; n2 < rowD1Matrix64F2.numRows; ++n2) {
                double d = 0.0;
                for (int j = 0; j < rowD1Matrix64F2.numCols; ++j) {
                    d += dArray[j] * rowD1Matrix64F2.unsafe_get(n2, j);
                }
                rowD1Matrix64F3.plus(n++, d);
            }
        }
    }

    public static void multAddTransB(RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F == rowD1Matrix64F3 || rowD1Matrix64F2 == rowD1Matrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (rowD1Matrix64F.numCols != rowD1Matrix64F2.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (rowD1Matrix64F.numRows != rowD1Matrix64F3.numRows || rowD1Matrix64F2.numRows != rowD1Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < rowD1Matrix64F.numRows; ++i) {
            int n3 = n2 + rowD1Matrix64F2.numCols;
            int n4 = 0;
            for (int j = 0; j < rowD1Matrix64F2.numRows; ++j) {
                int n5 = n2;
                double d = 0.0;
                while (n5 < n3) {
                    d += rowD1Matrix64F.get(n5++) * rowD1Matrix64F2.get(n4++);
                }
                rowD1Matrix64F3.plus(n++, d);
            }
            n2 += rowD1Matrix64F.numCols;
        }
    }

    public static void mult_reorder(double d, RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F == rowD1Matrix64F3 || rowD1Matrix64F2 == rowD1Matrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (rowD1Matrix64F.numCols != rowD1Matrix64F2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (rowD1Matrix64F.numRows != rowD1Matrix64F3.numRows || rowD1Matrix64F2.numCols != rowD1Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (rowD1Matrix64F.numCols == 0 || rowD1Matrix64F.numRows == 0) {
            CommonOps.fill(rowD1Matrix64F3, 0.0);
            return;
        }
        int n = 0;
        int n2 = rowD1Matrix64F2.numRows * rowD1Matrix64F2.numCols;
        for (int i = 0; i < rowD1Matrix64F.numRows; ++i) {
            int n3 = i * rowD1Matrix64F.numCols;
            int n4 = 0;
            int n5 = n;
            int n6 = n4 + rowD1Matrix64F2.numCols;
            double d2 = d * rowD1Matrix64F.get(n3++);
            while (n4 < n6) {
                rowD1Matrix64F3.set(n5++, d2 * rowD1Matrix64F2.get(n4++));
            }
            while (n4 != n2) {
                n5 = n;
                n6 = n4 + rowD1Matrix64F2.numCols;
                d2 = d * rowD1Matrix64F.get(n3++);
                while (n4 < n6) {
                    rowD1Matrix64F3.plus(n5++, d2 * rowD1Matrix64F2.get(n4++));
                }
            }
            n += rowD1Matrix64F3.numCols;
        }
    }

    public static void mult_small(double d, RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F == rowD1Matrix64F3 || rowD1Matrix64F2 == rowD1Matrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (rowD1Matrix64F.numCols != rowD1Matrix64F2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (rowD1Matrix64F.numRows != rowD1Matrix64F3.numRows || rowD1Matrix64F2.numCols != rowD1Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < rowD1Matrix64F.numRows; ++i) {
            for (int j = 0; j < rowD1Matrix64F2.numCols; ++j) {
                double d2 = 0.0;
                int n3 = n;
                int n4 = j;
                int n5 = n3 + rowD1Matrix64F2.numRows;
                while (n3 < n5) {
                    d2 += rowD1Matrix64F.get(n3++) * rowD1Matrix64F2.get(n4);
                    n4 += rowD1Matrix64F2.numCols;
                }
                rowD1Matrix64F3.set(n2++, d * d2);
            }
            n += rowD1Matrix64F.numCols;
        }
    }

    public static void mult_aux(double d, RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3, double[] dArray) {
        if (rowD1Matrix64F == rowD1Matrix64F3 || rowD1Matrix64F2 == rowD1Matrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (rowD1Matrix64F.numCols != rowD1Matrix64F2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (rowD1Matrix64F.numRows != rowD1Matrix64F3.numRows || rowD1Matrix64F2.numCols != rowD1Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (dArray == null) {
            dArray = new double[rowD1Matrix64F2.numRows];
        }
        for (int i = 0; i < rowD1Matrix64F2.numCols; ++i) {
            int n;
            for (n = 0; n < rowD1Matrix64F2.numRows; ++n) {
                dArray[n] = rowD1Matrix64F2.unsafe_get(n, i);
            }
            n = 0;
            for (int j = 0; j < rowD1Matrix64F.numRows; ++j) {
                double d2 = 0.0;
                int n2 = 0;
                while (n2 < rowD1Matrix64F2.numRows) {
                    d2 += rowD1Matrix64F.get(n++) * dArray[n2++];
                }
                rowD1Matrix64F3.set(j * rowD1Matrix64F3.numCols + i, d * d2);
            }
        }
    }

    public static void multTransA_reorder(double d, RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F == rowD1Matrix64F3 || rowD1Matrix64F2 == rowD1Matrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (rowD1Matrix64F.numRows != rowD1Matrix64F2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (rowD1Matrix64F.numCols != rowD1Matrix64F3.numRows || rowD1Matrix64F2.numCols != rowD1Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (rowD1Matrix64F.numCols == 0 || rowD1Matrix64F.numRows == 0) {
            CommonOps.fill(rowD1Matrix64F3, 0.0);
            return;
        }
        for (int i = 0; i < rowD1Matrix64F.numCols; ++i) {
            int n = i * rowD1Matrix64F3.numCols;
            double d2 = d * rowD1Matrix64F.get(i);
            int n2 = 0;
            int n3 = n2 + rowD1Matrix64F2.numCols;
            int n4 = n;
            while (n2 < n3) {
                rowD1Matrix64F3.set(n4++, d2 * rowD1Matrix64F2.get(n2++));
            }
            for (int j = 1; j < rowD1Matrix64F.numRows; ++j) {
                d2 = d * rowD1Matrix64F.unsafe_get(j, i);
                n3 = n2 + rowD1Matrix64F2.numCols;
                n4 = n;
                while (n2 < n3) {
                    rowD1Matrix64F3.plus(n4++, d2 * rowD1Matrix64F2.get(n2++));
                }
            }
        }
    }

    public static void multTransA_small(double d, RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F == rowD1Matrix64F3 || rowD1Matrix64F2 == rowD1Matrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (rowD1Matrix64F.numRows != rowD1Matrix64F2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (rowD1Matrix64F.numCols != rowD1Matrix64F3.numRows || rowD1Matrix64F2.numCols != rowD1Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int n = 0;
        for (int i = 0; i < rowD1Matrix64F.numCols; ++i) {
            for (int j = 0; j < rowD1Matrix64F2.numCols; ++j) {
                int n2;
                int n3 = i;
                int n4 = n2 + rowD1Matrix64F2.numRows * rowD1Matrix64F2.numCols;
                double d2 = 0.0;
                for (n2 = j; n2 < n4; n2 += rowD1Matrix64F2.numCols) {
                    d2 += rowD1Matrix64F.get(n3) * rowD1Matrix64F2.get(n2);
                    n3 += rowD1Matrix64F.numCols;
                }
                rowD1Matrix64F3.set(n++, d * d2);
            }
        }
    }

    public static void multTransAB(double d, RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F == rowD1Matrix64F3 || rowD1Matrix64F2 == rowD1Matrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (rowD1Matrix64F.numRows != rowD1Matrix64F2.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (rowD1Matrix64F.numCols != rowD1Matrix64F3.numRows || rowD1Matrix64F2.numRows != rowD1Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int n = 0;
        for (int i = 0; i < rowD1Matrix64F.numCols; ++i) {
            int n2 = 0;
            for (int j = 0; j < rowD1Matrix64F2.numRows; ++j) {
                int n3 = i;
                int n4 = n2 + rowD1Matrix64F2.numCols;
                double d2 = 0.0;
                while (n2 < n4) {
                    d2 += rowD1Matrix64F.get(n3) * rowD1Matrix64F2.get(n2++);
                    n3 += rowD1Matrix64F.numCols;
                }
                rowD1Matrix64F3.set(n++, d * d2);
            }
        }
    }

    public static void multTransAB_aux(double d, RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3, double[] dArray) {
        if (rowD1Matrix64F == rowD1Matrix64F3 || rowD1Matrix64F2 == rowD1Matrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (rowD1Matrix64F.numRows != rowD1Matrix64F2.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (rowD1Matrix64F.numCols != rowD1Matrix64F3.numRows || rowD1Matrix64F2.numRows != rowD1Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (dArray == null) {
            dArray = new double[rowD1Matrix64F.numRows];
        }
        if (rowD1Matrix64F.numCols == 0 || rowD1Matrix64F.numRows == 0) {
            CommonOps.fill(rowD1Matrix64F3, 0.0);
            return;
        }
        int n = 0;
        for (int i = 0; i < rowD1Matrix64F.numCols; ++i) {
            int n2;
            for (n2 = 0; n2 < rowD1Matrix64F2.numCols; ++n2) {
                dArray[n2] = rowD1Matrix64F.unsafe_get(n2, i);
            }
            for (n2 = 0; n2 < rowD1Matrix64F2.numRows; ++n2) {
                double d2 = 0.0;
                for (int j = 0; j < rowD1Matrix64F2.numCols; ++j) {
                    d2 += dArray[j] * rowD1Matrix64F2.unsafe_get(n2, j);
                }
                rowD1Matrix64F3.set(n++, d * d2);
            }
        }
    }

    public static void multTransB(double d, RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F == rowD1Matrix64F3 || rowD1Matrix64F2 == rowD1Matrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (rowD1Matrix64F.numCols != rowD1Matrix64F2.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (rowD1Matrix64F.numRows != rowD1Matrix64F3.numRows || rowD1Matrix64F2.numRows != rowD1Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < rowD1Matrix64F.numRows; ++i) {
            int n3 = n2 + rowD1Matrix64F2.numCols;
            int n4 = 0;
            for (int j = 0; j < rowD1Matrix64F2.numRows; ++j) {
                int n5 = n2;
                double d2 = 0.0;
                while (n5 < n3) {
                    d2 += rowD1Matrix64F.get(n5++) * rowD1Matrix64F2.get(n4++);
                }
                rowD1Matrix64F3.set(n++, d * d2);
            }
            n2 += rowD1Matrix64F.numCols;
        }
    }

    public static void multAdd_reorder(double d, RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F == rowD1Matrix64F3 || rowD1Matrix64F2 == rowD1Matrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (rowD1Matrix64F.numCols != rowD1Matrix64F2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (rowD1Matrix64F.numRows != rowD1Matrix64F3.numRows || rowD1Matrix64F2.numCols != rowD1Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (rowD1Matrix64F.numCols == 0 || rowD1Matrix64F.numRows == 0) {
            return;
        }
        int n = 0;
        int n2 = rowD1Matrix64F2.numRows * rowD1Matrix64F2.numCols;
        for (int i = 0; i < rowD1Matrix64F.numRows; ++i) {
            int n3 = i * rowD1Matrix64F.numCols;
            int n4 = 0;
            int n5 = n;
            int n6 = n4 + rowD1Matrix64F2.numCols;
            double d2 = d * rowD1Matrix64F.get(n3++);
            while (n4 < n6) {
                rowD1Matrix64F3.plus(n5++, d2 * rowD1Matrix64F2.get(n4++));
            }
            while (n4 != n2) {
                n5 = n;
                n6 = n4 + rowD1Matrix64F2.numCols;
                d2 = d * rowD1Matrix64F.get(n3++);
                while (n4 < n6) {
                    rowD1Matrix64F3.plus(n5++, d2 * rowD1Matrix64F2.get(n4++));
                }
            }
            n += rowD1Matrix64F3.numCols;
        }
    }

    public static void multAdd_small(double d, RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F == rowD1Matrix64F3 || rowD1Matrix64F2 == rowD1Matrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (rowD1Matrix64F.numCols != rowD1Matrix64F2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (rowD1Matrix64F.numRows != rowD1Matrix64F3.numRows || rowD1Matrix64F2.numCols != rowD1Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < rowD1Matrix64F.numRows; ++i) {
            for (int j = 0; j < rowD1Matrix64F2.numCols; ++j) {
                double d2 = 0.0;
                int n3 = n;
                int n4 = j;
                int n5 = n3 + rowD1Matrix64F2.numRows;
                while (n3 < n5) {
                    d2 += rowD1Matrix64F.get(n3++) * rowD1Matrix64F2.get(n4);
                    n4 += rowD1Matrix64F2.numCols;
                }
                rowD1Matrix64F3.plus(n2++, d * d2);
            }
            n += rowD1Matrix64F.numCols;
        }
    }

    public static void multAdd_aux(double d, RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3, double[] dArray) {
        if (rowD1Matrix64F == rowD1Matrix64F3 || rowD1Matrix64F2 == rowD1Matrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (rowD1Matrix64F.numCols != rowD1Matrix64F2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (rowD1Matrix64F.numRows != rowD1Matrix64F3.numRows || rowD1Matrix64F2.numCols != rowD1Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (dArray == null) {
            dArray = new double[rowD1Matrix64F2.numRows];
        }
        for (int i = 0; i < rowD1Matrix64F2.numCols; ++i) {
            int n;
            for (n = 0; n < rowD1Matrix64F2.numRows; ++n) {
                dArray[n] = rowD1Matrix64F2.unsafe_get(n, i);
            }
            n = 0;
            for (int j = 0; j < rowD1Matrix64F.numRows; ++j) {
                double d2 = 0.0;
                int n2 = 0;
                while (n2 < rowD1Matrix64F2.numRows) {
                    d2 += rowD1Matrix64F.get(n++) * dArray[n2++];
                }
                rowD1Matrix64F3.plus(j * rowD1Matrix64F3.numCols + i, d * d2);
            }
        }
    }

    public static void multAddTransA_reorder(double d, RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F == rowD1Matrix64F3 || rowD1Matrix64F2 == rowD1Matrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (rowD1Matrix64F.numRows != rowD1Matrix64F2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (rowD1Matrix64F.numCols != rowD1Matrix64F3.numRows || rowD1Matrix64F2.numCols != rowD1Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (rowD1Matrix64F.numCols == 0 || rowD1Matrix64F.numRows == 0) {
            return;
        }
        for (int i = 0; i < rowD1Matrix64F.numCols; ++i) {
            int n = i * rowD1Matrix64F3.numCols;
            double d2 = d * rowD1Matrix64F.get(i);
            int n2 = 0;
            int n3 = n2 + rowD1Matrix64F2.numCols;
            int n4 = n;
            while (n2 < n3) {
                rowD1Matrix64F3.plus(n4++, d2 * rowD1Matrix64F2.get(n2++));
            }
            for (int j = 1; j < rowD1Matrix64F.numRows; ++j) {
                d2 = d * rowD1Matrix64F.unsafe_get(j, i);
                n3 = n2 + rowD1Matrix64F2.numCols;
                n4 = n;
                while (n2 < n3) {
                    rowD1Matrix64F3.plus(n4++, d2 * rowD1Matrix64F2.get(n2++));
                }
            }
        }
    }

    public static void multAddTransA_small(double d, RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F == rowD1Matrix64F3 || rowD1Matrix64F2 == rowD1Matrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (rowD1Matrix64F.numRows != rowD1Matrix64F2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (rowD1Matrix64F.numCols != rowD1Matrix64F3.numRows || rowD1Matrix64F2.numCols != rowD1Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int n = 0;
        for (int i = 0; i < rowD1Matrix64F.numCols; ++i) {
            for (int j = 0; j < rowD1Matrix64F2.numCols; ++j) {
                int n2;
                int n3 = i;
                int n4 = n2 + rowD1Matrix64F2.numRows * rowD1Matrix64F2.numCols;
                double d2 = 0.0;
                for (n2 = j; n2 < n4; n2 += rowD1Matrix64F2.numCols) {
                    d2 += rowD1Matrix64F.get(n3) * rowD1Matrix64F2.get(n2);
                    n3 += rowD1Matrix64F.numCols;
                }
                rowD1Matrix64F3.plus(n++, d * d2);
            }
        }
    }

    public static void multAddTransAB(double d, RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F == rowD1Matrix64F3 || rowD1Matrix64F2 == rowD1Matrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (rowD1Matrix64F.numRows != rowD1Matrix64F2.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (rowD1Matrix64F.numCols != rowD1Matrix64F3.numRows || rowD1Matrix64F2.numRows != rowD1Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int n = 0;
        for (int i = 0; i < rowD1Matrix64F.numCols; ++i) {
            int n2 = 0;
            for (int j = 0; j < rowD1Matrix64F2.numRows; ++j) {
                int n3 = i;
                int n4 = n2 + rowD1Matrix64F2.numCols;
                double d2 = 0.0;
                while (n2 < n4) {
                    d2 += rowD1Matrix64F.get(n3) * rowD1Matrix64F2.get(n2++);
                    n3 += rowD1Matrix64F.numCols;
                }
                rowD1Matrix64F3.plus(n++, d * d2);
            }
        }
    }

    public static void multAddTransAB_aux(double d, RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3, double[] dArray) {
        if (rowD1Matrix64F == rowD1Matrix64F3 || rowD1Matrix64F2 == rowD1Matrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (rowD1Matrix64F.numRows != rowD1Matrix64F2.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (rowD1Matrix64F.numCols != rowD1Matrix64F3.numRows || rowD1Matrix64F2.numRows != rowD1Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (dArray == null) {
            dArray = new double[rowD1Matrix64F.numRows];
        }
        if (rowD1Matrix64F.numCols == 0 || rowD1Matrix64F.numRows == 0) {
            return;
        }
        int n = 0;
        for (int i = 0; i < rowD1Matrix64F.numCols; ++i) {
            int n2;
            for (n2 = 0; n2 < rowD1Matrix64F2.numCols; ++n2) {
                dArray[n2] = rowD1Matrix64F.unsafe_get(n2, i);
            }
            for (n2 = 0; n2 < rowD1Matrix64F2.numRows; ++n2) {
                double d2 = 0.0;
                for (int j = 0; j < rowD1Matrix64F2.numCols; ++j) {
                    d2 += dArray[j] * rowD1Matrix64F2.unsafe_get(n2, j);
                }
                rowD1Matrix64F3.plus(n++, d * d2);
            }
        }
    }

    public static void multAddTransB(double d, RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F == rowD1Matrix64F3 || rowD1Matrix64F2 == rowD1Matrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (rowD1Matrix64F.numCols != rowD1Matrix64F2.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (rowD1Matrix64F.numRows != rowD1Matrix64F3.numRows || rowD1Matrix64F2.numRows != rowD1Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < rowD1Matrix64F.numRows; ++i) {
            int n3 = n2 + rowD1Matrix64F2.numCols;
            int n4 = 0;
            for (int j = 0; j < rowD1Matrix64F2.numRows; ++j) {
                int n5 = n2;
                double d2 = 0.0;
                while (n5 < n3) {
                    d2 += rowD1Matrix64F.get(n5++) * rowD1Matrix64F2.get(n4++);
                }
                rowD1Matrix64F3.plus(n++, d * d2);
            }
            n2 += rowD1Matrix64F.numCols;
        }
    }
}

