/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.mult;

import org.ejml.data.CDenseMatrix64F;
import org.ejml.ops.CCommonOps;
import org.ejml.ops.MatrixDimensionException;

public class CMatrixMatrixMult {
    public static void mult_reorder(CDenseMatrix64F cDenseMatrix64F, CDenseMatrix64F cDenseMatrix64F2, CDenseMatrix64F cDenseMatrix64F3) {
        if (cDenseMatrix64F == cDenseMatrix64F3 || cDenseMatrix64F2 == cDenseMatrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (cDenseMatrix64F.numCols != cDenseMatrix64F2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (cDenseMatrix64F.numRows != cDenseMatrix64F3.numRows || cDenseMatrix64F2.numCols != cDenseMatrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (cDenseMatrix64F.numCols == 0 || cDenseMatrix64F.numRows == 0) {
            CCommonOps.fill(cDenseMatrix64F3, 0.0, 0.0);
            return;
        }
        int n = 0;
        int n2 = cDenseMatrix64F.getRowStride();
        int n3 = cDenseMatrix64F2.getRowStride();
        int n4 = cDenseMatrix64F3.getRowStride();
        int n5 = cDenseMatrix64F2.numRows * n3;
        for (int i = 0; i < cDenseMatrix64F.numRows; ++i) {
            double d;
            double d2;
            int n6 = i * n2;
            int n7 = 0;
            int n8 = n;
            int n9 = n7 + n3;
            double d3 = cDenseMatrix64F.data[n6++];
            double d4 = cDenseMatrix64F.data[n6++];
            while (n7 < n9) {
                d2 = cDenseMatrix64F2.data[n7++];
                d = cDenseMatrix64F2.data[n7++];
                cDenseMatrix64F3.data[n8++] = d3 * d2 - d4 * d;
                cDenseMatrix64F3.data[n8++] = d3 * d + d4 * d2;
            }
            while (n7 != n5) {
                n8 = n;
                n9 = n7 + n3;
                d3 = cDenseMatrix64F.data[n6++];
                d4 = cDenseMatrix64F.data[n6++];
                while (n7 < n9) {
                    d2 = cDenseMatrix64F2.data[n7++];
                    d = cDenseMatrix64F2.data[n7++];
                    int n10 = n8++;
                    cDenseMatrix64F3.data[n10] = cDenseMatrix64F3.data[n10] + (d3 * d2 - d4 * d);
                    int n11 = n8++;
                    cDenseMatrix64F3.data[n11] = cDenseMatrix64F3.data[n11] + (d3 * d + d4 * d2);
                }
            }
            n += n4;
        }
    }

    public static void mult_small(CDenseMatrix64F cDenseMatrix64F, CDenseMatrix64F cDenseMatrix64F2, CDenseMatrix64F cDenseMatrix64F3) {
        if (cDenseMatrix64F == cDenseMatrix64F3 || cDenseMatrix64F2 == cDenseMatrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (cDenseMatrix64F.numCols != cDenseMatrix64F2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (cDenseMatrix64F.numRows != cDenseMatrix64F3.numRows || cDenseMatrix64F2.numCols != cDenseMatrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int n = 0;
        int n2 = 0;
        int n3 = cDenseMatrix64F.getRowStride();
        int n4 = cDenseMatrix64F2.getRowStride();
        for (int i = 0; i < cDenseMatrix64F.numRows; ++i) {
            for (int j = 0; j < cDenseMatrix64F2.numCols; ++j) {
                double d = 0.0;
                double d2 = 0.0;
                int n5 = n;
                int n6 = j * 2;
                int n7 = n5 + n3;
                while (n5 < n7) {
                    double d3 = cDenseMatrix64F.data[n5++];
                    double d4 = cDenseMatrix64F.data[n5++];
                    double d5 = cDenseMatrix64F2.data[n6];
                    double d6 = cDenseMatrix64F2.data[n6 + 1];
                    d += d3 * d5 - d4 * d6;
                    d2 += d3 * d6 + d4 * d5;
                    n6 += n4;
                }
                cDenseMatrix64F3.data[n2++] = d;
                cDenseMatrix64F3.data[n2++] = d2;
            }
            n += n3;
        }
    }

    public static void multAdd_reorder(CDenseMatrix64F cDenseMatrix64F, CDenseMatrix64F cDenseMatrix64F2, CDenseMatrix64F cDenseMatrix64F3) {
        if (cDenseMatrix64F == cDenseMatrix64F3 || cDenseMatrix64F2 == cDenseMatrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (cDenseMatrix64F.numCols != cDenseMatrix64F2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (cDenseMatrix64F.numRows != cDenseMatrix64F3.numRows || cDenseMatrix64F2.numCols != cDenseMatrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (cDenseMatrix64F.numCols == 0 || cDenseMatrix64F.numRows == 0) {
            return;
        }
        int n = 0;
        int n2 = cDenseMatrix64F.getRowStride();
        int n3 = cDenseMatrix64F2.getRowStride();
        int n4 = cDenseMatrix64F3.getRowStride();
        int n5 = cDenseMatrix64F2.numRows * n3;
        for (int i = 0; i < cDenseMatrix64F.numRows; ++i) {
            double d;
            double d2;
            int n6 = i * n2;
            int n7 = 0;
            int n8 = n;
            int n9 = n7 + n3;
            double d3 = cDenseMatrix64F.data[n6++];
            double d4 = cDenseMatrix64F.data[n6++];
            while (n7 < n9) {
                d2 = cDenseMatrix64F2.data[n7++];
                d = cDenseMatrix64F2.data[n7++];
                int n10 = n8++;
                cDenseMatrix64F3.data[n10] = cDenseMatrix64F3.data[n10] + (d3 * d2 - d4 * d);
                int n11 = n8++;
                cDenseMatrix64F3.data[n11] = cDenseMatrix64F3.data[n11] + (d3 * d + d4 * d2);
            }
            while (n7 != n5) {
                n8 = n;
                n9 = n7 + n3;
                d3 = cDenseMatrix64F.data[n6++];
                d4 = cDenseMatrix64F.data[n6++];
                while (n7 < n9) {
                    d2 = cDenseMatrix64F2.data[n7++];
                    d = cDenseMatrix64F2.data[n7++];
                    int n12 = n8++;
                    cDenseMatrix64F3.data[n12] = cDenseMatrix64F3.data[n12] + (d3 * d2 - d4 * d);
                    int n13 = n8++;
                    cDenseMatrix64F3.data[n13] = cDenseMatrix64F3.data[n13] + (d3 * d + d4 * d2);
                }
            }
            n += n4;
        }
    }

    public static void multAdd_small(CDenseMatrix64F cDenseMatrix64F, CDenseMatrix64F cDenseMatrix64F2, CDenseMatrix64F cDenseMatrix64F3) {
        if (cDenseMatrix64F == cDenseMatrix64F3 || cDenseMatrix64F2 == cDenseMatrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (cDenseMatrix64F.numCols != cDenseMatrix64F2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (cDenseMatrix64F.numRows != cDenseMatrix64F3.numRows || cDenseMatrix64F2.numCols != cDenseMatrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int n = 0;
        int n2 = 0;
        int n3 = cDenseMatrix64F.getRowStride();
        int n4 = cDenseMatrix64F2.getRowStride();
        for (int i = 0; i < cDenseMatrix64F.numRows; ++i) {
            for (int j = 0; j < cDenseMatrix64F2.numCols; ++j) {
                double d = 0.0;
                double d2 = 0.0;
                int n5 = n;
                int n6 = j * 2;
                int n7 = n5 + n3;
                while (n5 < n7) {
                    double d3 = cDenseMatrix64F.data[n5++];
                    double d4 = cDenseMatrix64F.data[n5++];
                    double d5 = cDenseMatrix64F2.data[n6];
                    double d6 = cDenseMatrix64F2.data[n6 + 1];
                    d += d3 * d5 - d4 * d6;
                    d2 += d3 * d6 + d4 * d5;
                    n6 += n4;
                }
                int n8 = n2++;
                cDenseMatrix64F3.data[n8] = cDenseMatrix64F3.data[n8] + d;
                int n9 = n2++;
                cDenseMatrix64F3.data[n9] = cDenseMatrix64F3.data[n9] + d2;
            }
            n += n3;
        }
    }

    public static void mult_reorder(double d, double d2, CDenseMatrix64F cDenseMatrix64F, CDenseMatrix64F cDenseMatrix64F2, CDenseMatrix64F cDenseMatrix64F3) {
        if (cDenseMatrix64F == cDenseMatrix64F3 || cDenseMatrix64F2 == cDenseMatrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (cDenseMatrix64F.numCols != cDenseMatrix64F2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (cDenseMatrix64F.numRows != cDenseMatrix64F3.numRows || cDenseMatrix64F2.numCols != cDenseMatrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (cDenseMatrix64F.numCols == 0 || cDenseMatrix64F.numRows == 0) {
            CCommonOps.fill(cDenseMatrix64F3, 0.0, 0.0);
            return;
        }
        int n = 0;
        int n2 = cDenseMatrix64F.getRowStride();
        int n3 = cDenseMatrix64F2.getRowStride();
        int n4 = cDenseMatrix64F3.getRowStride();
        int n5 = cDenseMatrix64F2.numRows * n3;
        for (int i = 0; i < cDenseMatrix64F.numRows; ++i) {
            double d3;
            double d4;
            int n6 = i * n2;
            int n7 = 0;
            int n8 = n;
            int n9 = n7 + n3;
            double d5 = cDenseMatrix64F.data[n6++];
            double d6 = cDenseMatrix64F.data[n6++];
            double d7 = d * d5 - d2 * d6;
            double d8 = d * d6 + d2 * d5;
            while (n7 < n9) {
                d4 = cDenseMatrix64F2.data[n7++];
                d3 = cDenseMatrix64F2.data[n7++];
                cDenseMatrix64F3.data[n8++] = d7 * d4 - d8 * d3;
                cDenseMatrix64F3.data[n8++] = d7 * d3 + d8 * d4;
            }
            while (n7 != n5) {
                n8 = n;
                n9 = n7 + n3;
                d5 = cDenseMatrix64F.data[n6++];
                d6 = cDenseMatrix64F.data[n6++];
                d7 = d * d5 - d2 * d6;
                d8 = d * d6 + d2 * d5;
                while (n7 < n9) {
                    d4 = cDenseMatrix64F2.data[n7++];
                    d3 = cDenseMatrix64F2.data[n7++];
                    int n10 = n8++;
                    cDenseMatrix64F3.data[n10] = cDenseMatrix64F3.data[n10] + (d7 * d4 - d8 * d3);
                    int n11 = n8++;
                    cDenseMatrix64F3.data[n11] = cDenseMatrix64F3.data[n11] + (d7 * d3 + d8 * d4);
                }
            }
            n += n4;
        }
    }

    public static void mult_small(double d, double d2, CDenseMatrix64F cDenseMatrix64F, CDenseMatrix64F cDenseMatrix64F2, CDenseMatrix64F cDenseMatrix64F3) {
        if (cDenseMatrix64F == cDenseMatrix64F3 || cDenseMatrix64F2 == cDenseMatrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (cDenseMatrix64F.numCols != cDenseMatrix64F2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (cDenseMatrix64F.numRows != cDenseMatrix64F3.numRows || cDenseMatrix64F2.numCols != cDenseMatrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int n = 0;
        int n2 = 0;
        int n3 = cDenseMatrix64F.getRowStride();
        int n4 = cDenseMatrix64F2.getRowStride();
        for (int i = 0; i < cDenseMatrix64F.numRows; ++i) {
            for (int j = 0; j < cDenseMatrix64F2.numCols; ++j) {
                double d3 = 0.0;
                double d4 = 0.0;
                int n5 = n;
                int n6 = j * 2;
                int n7 = n5 + n3;
                while (n5 < n7) {
                    double d5 = cDenseMatrix64F.data[n5++];
                    double d6 = cDenseMatrix64F.data[n5++];
                    double d7 = cDenseMatrix64F2.data[n6];
                    double d8 = cDenseMatrix64F2.data[n6 + 1];
                    d3 += d5 * d7 - d6 * d8;
                    d4 += d5 * d8 + d6 * d7;
                    n6 += n4;
                }
                cDenseMatrix64F3.data[n2++] = d * d3 - d2 * d4;
                cDenseMatrix64F3.data[n2++] = d * d4 + d2 * d3;
            }
            n += n3;
        }
    }

    public static void multAdd_reorder(double d, double d2, CDenseMatrix64F cDenseMatrix64F, CDenseMatrix64F cDenseMatrix64F2, CDenseMatrix64F cDenseMatrix64F3) {
        if (cDenseMatrix64F == cDenseMatrix64F3 || cDenseMatrix64F2 == cDenseMatrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (cDenseMatrix64F.numCols != cDenseMatrix64F2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (cDenseMatrix64F.numRows != cDenseMatrix64F3.numRows || cDenseMatrix64F2.numCols != cDenseMatrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (cDenseMatrix64F.numCols == 0 || cDenseMatrix64F.numRows == 0) {
            return;
        }
        int n = 0;
        int n2 = cDenseMatrix64F.getRowStride();
        int n3 = cDenseMatrix64F2.getRowStride();
        int n4 = cDenseMatrix64F3.getRowStride();
        int n5 = cDenseMatrix64F2.numRows * n3;
        for (int i = 0; i < cDenseMatrix64F.numRows; ++i) {
            double d3;
            double d4;
            int n6 = i * n2;
            int n7 = 0;
            int n8 = n;
            int n9 = n7 + n3;
            double d5 = cDenseMatrix64F.data[n6++];
            double d6 = cDenseMatrix64F.data[n6++];
            double d7 = d * d5 - d2 * d6;
            double d8 = d * d6 + d2 * d5;
            while (n7 < n9) {
                d4 = cDenseMatrix64F2.data[n7++];
                d3 = cDenseMatrix64F2.data[n7++];
                int n10 = n8++;
                cDenseMatrix64F3.data[n10] = cDenseMatrix64F3.data[n10] + (d7 * d4 - d8 * d3);
                int n11 = n8++;
                cDenseMatrix64F3.data[n11] = cDenseMatrix64F3.data[n11] + (d7 * d3 + d8 * d4);
            }
            while (n7 != n5) {
                n8 = n;
                n9 = n7 + n3;
                d5 = cDenseMatrix64F.data[n6++];
                d6 = cDenseMatrix64F.data[n6++];
                d7 = d * d5 - d2 * d6;
                d8 = d * d6 + d2 * d5;
                while (n7 < n9) {
                    d4 = cDenseMatrix64F2.data[n7++];
                    d3 = cDenseMatrix64F2.data[n7++];
                    int n12 = n8++;
                    cDenseMatrix64F3.data[n12] = cDenseMatrix64F3.data[n12] + (d7 * d4 - d8 * d3);
                    int n13 = n8++;
                    cDenseMatrix64F3.data[n13] = cDenseMatrix64F3.data[n13] + (d7 * d3 + d8 * d4);
                }
            }
            n += n4;
        }
    }

    public static void multAdd_small(double d, double d2, CDenseMatrix64F cDenseMatrix64F, CDenseMatrix64F cDenseMatrix64F2, CDenseMatrix64F cDenseMatrix64F3) {
        if (cDenseMatrix64F == cDenseMatrix64F3 || cDenseMatrix64F2 == cDenseMatrix64F3) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (cDenseMatrix64F.numCols != cDenseMatrix64F2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (cDenseMatrix64F.numRows != cDenseMatrix64F3.numRows || cDenseMatrix64F2.numCols != cDenseMatrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int n = 0;
        int n2 = 0;
        int n3 = cDenseMatrix64F.getRowStride();
        int n4 = cDenseMatrix64F2.getRowStride();
        for (int i = 0; i < cDenseMatrix64F.numRows; ++i) {
            for (int j = 0; j < cDenseMatrix64F2.numCols; ++j) {
                double d3 = 0.0;
                double d4 = 0.0;
                int n5 = n;
                int n6 = j * 2;
                int n7 = n5 + n3;
                while (n5 < n7) {
                    double d5 = cDenseMatrix64F.data[n5++];
                    double d6 = cDenseMatrix64F.data[n5++];
                    double d7 = cDenseMatrix64F2.data[n6];
                    double d8 = cDenseMatrix64F2.data[n6 + 1];
                    d3 += d5 * d7 - d6 * d8;
                    d4 += d5 * d8 + d6 * d7;
                    n6 += n4;
                }
                int n8 = n2++;
                cDenseMatrix64F3.data[n8] = cDenseMatrix64F3.data[n8] + (d * d3 - d2 * d4);
                int n9 = n2++;
                cDenseMatrix64F3.data[n9] = cDenseMatrix64F3.data[n9] + (d * d4 + d2 * d3);
            }
            n += n3;
        }
    }
}

