/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.qr;

import org.ejml.alg.dense.decompose.CTriangularSolver;
import org.ejml.alg.dense.linsol.LinearSolverAbstract_CD64;
import org.ejml.data.CDenseMatrix64F;
import org.ejml.interfaces.decomposition.QRDecomposition;
import org.ejml.ops.CCommonOps;
import org.ejml.ops.CSpecializedOps;

public class LinearSolverQr_CD64
extends LinearSolverAbstract_CD64 {
    private QRDecomposition<CDenseMatrix64F> decomposer;
    protected int maxRows = -1;
    protected int maxCols = -1;
    protected CDenseMatrix64F Q;
    protected CDenseMatrix64F Qt;
    protected CDenseMatrix64F R;
    private CDenseMatrix64F Y;
    private CDenseMatrix64F Z;

    public LinearSolverQr_CD64(QRDecomposition<CDenseMatrix64F> qRDecomposition) {
        this.decomposer = qRDecomposition;
    }

    public void setMaxSize(int n, int n2) {
        this.maxRows = n;
        this.maxCols = n2;
        this.Q = new CDenseMatrix64F(n, n);
        this.Qt = new CDenseMatrix64F(n, n);
        this.R = new CDenseMatrix64F(n, n2);
        this.Y = new CDenseMatrix64F(n, 1);
        this.Z = new CDenseMatrix64F(n, 1);
    }

    @Override
    public boolean setA(CDenseMatrix64F cDenseMatrix64F) {
        if (cDenseMatrix64F.numRows > this.maxRows || cDenseMatrix64F.numCols > this.maxCols) {
            this.setMaxSize(cDenseMatrix64F.numRows, cDenseMatrix64F.numCols);
        }
        this._setA(cDenseMatrix64F);
        if (!this.decomposer.decompose(cDenseMatrix64F)) {
            return false;
        }
        this.Q.reshape(this.numRows, this.numRows);
        this.R.reshape(this.numRows, this.numCols);
        this.decomposer.getQ(this.Q, false);
        this.decomposer.getR(this.R, false);
        CCommonOps.transposeConjugate(this.Q, this.Qt);
        return true;
    }

    @Override
    public double quality() {
        return CSpecializedOps.qualityTriangular(this.R);
    }

    @Override
    public void solve(CDenseMatrix64F cDenseMatrix64F, CDenseMatrix64F cDenseMatrix64F2) {
        if (cDenseMatrix64F2.numRows != this.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for X");
        }
        if (cDenseMatrix64F.numRows != this.numRows || cDenseMatrix64F.numCols != cDenseMatrix64F2.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for B");
        }
        int n = cDenseMatrix64F.numCols;
        this.Y.reshape(this.numRows, 1);
        this.Z.reshape(this.numRows, 1);
        for (int i = 0; i < n; ++i) {
            int n2;
            for (n2 = 0; n2 < this.numRows; ++n2) {
                int n3 = cDenseMatrix64F.getIndex(n2, i);
                this.Y.data[n2 * 2] = cDenseMatrix64F.data[n3];
                this.Y.data[n2 * 2 + 1] = cDenseMatrix64F.data[n3 + 1];
            }
            CCommonOps.mult(this.Qt, this.Y, this.Z);
            CTriangularSolver.solveU(this.R.data, this.Z.data, this.numCols);
            for (n2 = 0; n2 < this.numCols; ++n2) {
                cDenseMatrix64F2.set(n2, i, this.Z.data[n2 * 2], this.Z.data[n2 * 2 + 1]);
            }
        }
    }

    @Override
    public boolean modifiesA() {
        return this.decomposer.inputModified();
    }

    @Override
    public boolean modifiesB() {
        return false;
    }

    @Override
    public QRDecomposition<CDenseMatrix64F> getDecomposition() {
        return this.decomposer;
    }

    public QRDecomposition<CDenseMatrix64F> getDecomposer() {
        return this.decomposer;
    }

    public CDenseMatrix64F getQ() {
        return this.Q;
    }

    public CDenseMatrix64F getR() {
        return this.R;
    }
}

