/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.qr;

import org.ejml.alg.dense.decompose.CTriangularSolver;
import org.ejml.alg.dense.decompose.qr.QRDecompositionHouseholderColumn_CD64;
import org.ejml.alg.dense.decompose.qr.QrHelperFunctions_CD64;
import org.ejml.alg.dense.linsol.LinearSolverAbstract_CD64;
import org.ejml.data.CDenseMatrix64F;
import org.ejml.ops.CSpecializedOps;

public class LinearSolverQrHouseCol_CD64
extends LinearSolverAbstract_CD64 {
    private QRDecompositionHouseholderColumn_CD64 decomposer;
    private CDenseMatrix64F a = new CDenseMatrix64F(1, 1);
    private CDenseMatrix64F temp = new CDenseMatrix64F(1, 1);
    protected int maxRows = -1;
    protected int maxCols = -1;
    private double[][] QR;
    private CDenseMatrix64F R = new CDenseMatrix64F(1, 1);
    private double[] gammas;

    public LinearSolverQrHouseCol_CD64() {
        this.decomposer = new QRDecompositionHouseholderColumn_CD64();
    }

    public void setMaxSize(int n, int n2) {
        this.maxRows = n;
        this.maxCols = n2;
    }

    @Override
    public boolean setA(CDenseMatrix64F cDenseMatrix64F) {
        if (cDenseMatrix64F.numRows < cDenseMatrix64F.numCols) {
            throw new IllegalArgumentException("Can't solve for wide systems.  More variables than equations.");
        }
        if (cDenseMatrix64F.numRows > this.maxRows || cDenseMatrix64F.numCols > this.maxCols) {
            this.setMaxSize(cDenseMatrix64F.numRows, cDenseMatrix64F.numCols);
        }
        this.R.reshape(cDenseMatrix64F.numCols, cDenseMatrix64F.numCols);
        this.a.reshape(cDenseMatrix64F.numRows, 1);
        this.temp.reshape(cDenseMatrix64F.numRows, 1);
        this._setA(cDenseMatrix64F);
        if (!this.decomposer.decompose(cDenseMatrix64F)) {
            return false;
        }
        this.gammas = this.decomposer.getGammas();
        this.QR = this.decomposer.getQR();
        this.decomposer.getR(this.R, true);
        return true;
    }

    @Override
    public double quality() {
        return CSpecializedOps.qualityTriangular(this.R);
    }

    @Override
    public void solve(CDenseMatrix64F cDenseMatrix64F, CDenseMatrix64F cDenseMatrix64F2) {
        if (cDenseMatrix64F2.numRows != this.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for X: X rows = " + cDenseMatrix64F2.numRows + " expected = " + this.numCols);
        }
        if (cDenseMatrix64F.numRows != this.numRows || cDenseMatrix64F.numCols != cDenseMatrix64F2.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for B");
        }
        int n = cDenseMatrix64F.numCols;
        for (int i = 0; i < n; ++i) {
            int n2;
            for (n2 = 0; n2 < this.numRows; ++n2) {
                int n3 = (n2 * n + i) * 2;
                this.a.data[n2 * 2] = cDenseMatrix64F.data[n3];
                this.a.data[n2 * 2 + 1] = cDenseMatrix64F.data[n3 + 1];
            }
            for (n2 = 0; n2 < this.numCols; ++n2) {
                double[] dArray = this.QR[n2];
                double d = dArray[n2 * 2];
                double d2 = dArray[n2 * 2 + 1];
                dArray[n2 * 2] = 1.0;
                dArray[n2 * 2 + 1] = 0.0;
                QrHelperFunctions_CD64.rank1UpdateMultR(this.a, dArray, 0, this.gammas[n2], 0, n2, this.numRows, this.temp.data);
                dArray[n2 * 2] = d;
                dArray[n2 * 2 + 1] = d2;
            }
            CTriangularSolver.solveU(this.R.data, this.a.data, this.numCols);
            for (n2 = 0; n2 < this.numCols; ++n2) {
                int n4 = (n2 * n + i) * 2;
                cDenseMatrix64F2.data[n4] = this.a.data[n2 * 2];
                cDenseMatrix64F2.data[n4 + 1] = this.a.data[n2 * 2 + 1];
            }
        }
    }

    @Override
    public boolean modifiesA() {
        return false;
    }

    @Override
    public boolean modifiesB() {
        return false;
    }

    @Override
    public QRDecompositionHouseholderColumn_CD64 getDecomposition() {
        return this.decomposer;
    }
}

