/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.lu;

import org.ejml.alg.dense.decomposition.lu.LUDecompositionBase_D64;
import org.ejml.alg.dense.linsol.LinearSolverAbstract_D64;
import org.ejml.data.DenseMatrix64F;

public abstract class LinearSolverLuBase_D64
extends LinearSolverAbstract_D64 {
    protected LUDecompositionBase_D64 decomp;

    public LinearSolverLuBase_D64(LUDecompositionBase_D64 lUDecompositionBase_D64) {
        this.decomp = lUDecompositionBase_D64;
    }

    @Override
    public boolean setA(DenseMatrix64F denseMatrix64F) {
        this._setA(denseMatrix64F);
        return this.decomp.decompose(denseMatrix64F);
    }

    @Override
    public double quality() {
        return this.decomp.quality();
    }

    @Override
    public void invert(DenseMatrix64F denseMatrix64F) {
        double[] dArray = this.decomp._getVV();
        DenseMatrix64F denseMatrix64F2 = this.decomp.getLU();
        if (denseMatrix64F.numCols != denseMatrix64F2.numCols || denseMatrix64F.numRows != denseMatrix64F2.numRows) {
            throw new IllegalArgumentException("Unexpected matrix dimension");
        }
        int n = this.A.numCols;
        double[] dArray2 = denseMatrix64F.data;
        for (int i = 0; i < n; ++i) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                dArray[n2] = n2 == i ? 1.0 : 0.0;
            }
            this.decomp._solveVectorInternal(dArray);
            n2 = i;
            int n3 = 0;
            while (n3 < n) {
                dArray2[n2] = dArray[n3];
                ++n3;
                n2 += n;
            }
        }
    }

    public void improveSol(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        if (denseMatrix64F.numCols != denseMatrix64F2.numCols) {
            throw new IllegalArgumentException("bad shapes");
        }
        double[] dArray = this.A.data;
        double[] dArray2 = denseMatrix64F.data;
        double[] dArray3 = denseMatrix64F2.data;
        int n = denseMatrix64F.numCols;
        int n2 = denseMatrix64F.numCols;
        double[] dArray4 = this.decomp._getVV();
        for (int i = 0; i < n; ++i) {
            int n3;
            for (n3 = 0; n3 < n2; ++n3) {
                double d = -dArray2[n3 * n + i];
                for (int j = 0; j < n2; ++j) {
                    d += dArray[n3 * n2 + j] * dArray3[j * n + i];
                }
                dArray4[n3] = d;
            }
            this.decomp._solveVectorInternal(dArray4);
            for (n3 = 0; n3 < n2; ++n3) {
                int n4 = n3 * n + i;
                dArray3[n4] = dArray3[n4] - dArray4[n3];
            }
        }
    }

    @Override
    public boolean modifiesA() {
        return false;
    }

    @Override
    public boolean modifiesB() {
        return false;
    }

    @Override
    public LUDecompositionBase_D64 getDecomposition() {
        return this.decomp;
    }
}

