/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.chol;

import java.util.Arrays;
import org.ejml.alg.dense.decompose.CTriangularSolver;
import org.ejml.alg.dense.decompose.chol.CholeskyDecompositionCommon_CD64;
import org.ejml.alg.dense.linsol.LinearSolverAbstract_CD64;
import org.ejml.data.CDenseMatrix64F;
import org.ejml.interfaces.decomposition.CholeskyDecomposition;
import org.ejml.ops.CSpecializedOps;

public class LinearSolverChol_CD64
extends LinearSolverAbstract_CD64 {
    CholeskyDecompositionCommon_CD64 decomposer;
    int n;
    double[] vv = new double[0];
    double[] t;

    public LinearSolverChol_CD64(CholeskyDecompositionCommon_CD64 choleskyDecompositionCommon_CD64) {
        this.decomposer = choleskyDecompositionCommon_CD64;
    }

    @Override
    public boolean setA(CDenseMatrix64F cDenseMatrix64F) {
        if (cDenseMatrix64F.numRows != cDenseMatrix64F.numCols) {
            throw new IllegalArgumentException("Matrix must be square");
        }
        this._setA(cDenseMatrix64F);
        if (this.decomposer.decompose(cDenseMatrix64F)) {
            this.n = cDenseMatrix64F.numCols;
            if (this.vv.length < this.n * 2) {
                this.vv = new double[this.n * 2];
            }
            this.t = this.decomposer._getT().data;
            return true;
        }
        return false;
    }

    @Override
    public double quality() {
        return CSpecializedOps.qualityTriangular(this.decomposer._getT());
    }

    @Override
    public void solve(CDenseMatrix64F cDenseMatrix64F, CDenseMatrix64F cDenseMatrix64F2) {
        if (cDenseMatrix64F.numCols != cDenseMatrix64F2.numCols || cDenseMatrix64F.numRows != this.n || cDenseMatrix64F2.numRows != this.n) {
            throw new IllegalArgumentException("Unexpected matrix size");
        }
        int n = cDenseMatrix64F.numCols;
        double[] dArray = cDenseMatrix64F.data;
        double[] dArray2 = cDenseMatrix64F2.data;
        if (this.decomposer.isLower()) {
            for (int i = 0; i < n; ++i) {
                int n2;
                for (n2 = 0; n2 < this.n; ++n2) {
                    this.vv[n2 * 2] = dArray[(n2 * n + i) * 2];
                    this.vv[n2 * 2 + 1] = dArray[(n2 * n + i) * 2 + 1];
                }
                this.solveInternalL();
                for (n2 = 0; n2 < this.n; ++n2) {
                    dArray2[(n2 * n + i) * 2] = this.vv[n2 * 2];
                    dArray2[(n2 * n + i) * 2 + 1] = this.vv[n2 * 2 + 1];
                }
            }
        } else {
            throw new RuntimeException("Implement");
        }
    }

    private void solveInternalL() {
        CTriangularSolver.solveL_diagReal(this.t, this.vv, this.n);
        CTriangularSolver.solveConjTranL_diagReal(this.t, this.vv, this.n);
    }

    @Override
    public void invert(CDenseMatrix64F cDenseMatrix64F) {
        if (cDenseMatrix64F.numRows != this.n || cDenseMatrix64F.numCols != this.n) {
            throw new RuntimeException("Unexpected matrix dimension");
        }
        if (cDenseMatrix64F.data == this.t) {
            throw new IllegalArgumentException("Passing in the same matrix that was decomposed.");
        }
        if (!this.decomposer.isLower()) {
            throw new RuntimeException("Implement");
        }
        this.setToInverseL(cDenseMatrix64F.data);
    }

    public void setToInverseL(double[] dArray) {
        for (int i = 0; i < this.n; ++i) {
            Arrays.fill(this.vv, 0.0);
            this.vv[i * 2] = 1.0;
            CTriangularSolver.solveL_diagReal(this.t, this.vv, this.n);
            CTriangularSolver.solveConjTranL_diagReal(this.t, this.vv, this.n);
            for (int j = 0; j < this.n; ++j) {
                dArray[(j * this.numCols + i) * 2] = this.vv[j * 2];
                dArray[(j * this.numCols + i) * 2 + 1] = this.vv[j * 2 + 1];
            }
        }
    }

    @Override
    public boolean modifiesA() {
        return this.decomposer.inputModified();
    }

    @Override
    public boolean modifiesB() {
        return false;
    }

    @Override
    public CholeskyDecomposition<CDenseMatrix64F> getDecomposition() {
        return this.decomposer;
    }
}

