/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.svd;

import org.ejml.alg.dense.decomposition.bidiagonal.BidiagonalDecompositionRow_D64;
import org.ejml.alg.dense.decomposition.svd.SvdImplicitQrAlgorithmSmart;
import org.ejml.alg.dense.decomposition.svd.implicitqr.SvdImplicitQrAlgorithm;
import org.ejml.data.DenseMatrix64F;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.ops.CommonOps;

public class SvdImplicitQrDecompose_UltimateS
implements SingularValueDecomposition<DenseMatrix64F> {
    private int numRows;
    private int numCols;
    private int smallSide;
    private BidiagonalDecompositionRow_D64 bidiag = new BidiagonalDecompositionRow_D64();
    private SvdImplicitQrAlgorithm qralg = new SvdImplicitQrAlgorithmSmart();
    private double[] diag;
    private double[] off;
    private DenseMatrix64F Ut;
    private DenseMatrix64F Vt;
    private double[] singularValues;
    private int numSingular;
    private boolean compact;
    private boolean computeU;
    private boolean computeV;
    private boolean prefComputeU;
    private boolean prefComputeV;
    private double[] diagOld;
    private double[] offOld;
    private DenseMatrix64F A_mod = new DenseMatrix64F(1, 1);

    public SvdImplicitQrDecompose_UltimateS(boolean bl, boolean bl2, boolean bl3) {
        this.compact = bl;
        this.prefComputeU = bl2;
        this.prefComputeV = bl3;
    }

    @Override
    public double[] getSingularValues() {
        return this.singularValues;
    }

    @Override
    public int numberOfSingularValues() {
        return this.numSingular;
    }

    @Override
    public boolean isCompact() {
        return this.compact;
    }

    @Override
    public DenseMatrix64F getU(DenseMatrix64F denseMatrix64F, boolean bl) {
        if (!this.prefComputeU) {
            throw new IllegalArgumentException("As requested U was not computed.");
        }
        if (bl) {
            return this.Ut;
        }
        denseMatrix64F = new DenseMatrix64F(this.Ut.numCols, this.Ut.numRows);
        CommonOps.transpose(this.Ut, denseMatrix64F);
        return denseMatrix64F;
    }

    @Override
    public DenseMatrix64F getV(DenseMatrix64F denseMatrix64F, boolean bl) {
        if (!this.prefComputeV) {
            throw new IllegalArgumentException("As requested V was not computed.");
        }
        if (bl) {
            return this.Vt;
        }
        denseMatrix64F = new DenseMatrix64F(this.Vt.numCols, this.Vt.numRows);
        CommonOps.transpose(this.Vt, denseMatrix64F);
        return denseMatrix64F;
    }

    @Override
    public DenseMatrix64F getW(DenseMatrix64F denseMatrix64F) {
        int n;
        int n2 = this.compact ? this.numSingular : this.numRows;
        int n3 = n = this.compact ? this.numSingular : this.numCols;
        if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(n2, n);
        } else {
            denseMatrix64F.reshape(n2, n, false);
            denseMatrix64F.zero();
        }
        for (int i = 0; i < this.numSingular; ++i) {
            denseMatrix64F.data[i * denseMatrix64F.numCols + i] = this.singularValues[i];
        }
        return denseMatrix64F;
    }

    @Override
    public boolean decompose(DenseMatrix64F denseMatrix64F) {
        boolean bl = denseMatrix64F.numCols > denseMatrix64F.numRows;
        this.init(denseMatrix64F, bl);
        if (this.computeSingularValues(denseMatrix64F, bl)) {
            return false;
        }
        if ((this.computeU || this.computeV) && this.computeUandV(bl)) {
            return false;
        }
        this.makeSingularPositive();
        return true;
    }

    @Override
    public boolean inputModified() {
        return false;
    }

    private void init(DenseMatrix64F denseMatrix64F, boolean bl) {
        if (bl) {
            this.computeU = this.prefComputeV;
            this.computeV = this.prefComputeU;
        } else {
            this.computeU = this.prefComputeU;
            this.computeV = this.prefComputeV;
        }
        this.numRows = denseMatrix64F.numRows;
        this.numCols = denseMatrix64F.numCols;
        this.smallSide = Math.min(this.numRows, this.numCols);
        if (this.diagOld == null || this.diagOld.length < this.smallSide) {
            this.diagOld = new double[this.smallSide];
            this.offOld = new double[this.smallSide - 1];
            this.diag = new double[this.smallSide];
            this.off = new double[this.smallSide - 1];
        }
    }

    private boolean computeUandV(boolean bl) {
        long l = System.currentTimeMillis();
        if (this.computeU) {
            this.Ut = this.bidiag.getU(this.Ut, true, this.compact);
        }
        if (this.computeV) {
            this.Vt = this.bidiag.getV(this.Vt, true, this.compact);
        }
        if (bl) {
            this.qralg.initParam(this.numCols, this.numRows);
        } else {
            this.qralg.initParam(this.numRows, this.numCols);
        }
        this.diagOld = this.qralg.swapDiag(this.diagOld);
        this.offOld = this.qralg.swapOff(this.offOld);
        this.qralg.setFastValues(false);
        if (this.computeU) {
            this.qralg.setUt(this.Ut);
        }
        if (this.computeV) {
            this.qralg.setVt(this.Vt);
        }
        CommonOps.setIdentity(this.Ut);
        CommonOps.setIdentity(this.Vt);
        long l2 = System.currentTimeMillis();
        if (!this.qralg.process(this.diagOld)) {
            return true;
        }
        long l3 = System.currentTimeMillis();
        System.out.println("  bidiag UV " + (l2 - l) + " qr UV " + (l3 - l2));
        if (bl) {
            DenseMatrix64F denseMatrix64F = this.Vt;
            this.Vt = this.Ut;
            this.Ut = denseMatrix64F;
        }
        return false;
    }

    private boolean computeSingularValues(DenseMatrix64F denseMatrix64F, boolean bl) {
        long l = System.currentTimeMillis();
        if (this.bidiagonalization(denseMatrix64F, bl)) {
            return false;
        }
        long l2 = System.currentTimeMillis();
        this.bidiag.getDiagonal(this.diag, this.off);
        this.qralg.setMatrix(this.numRows, this.numCols, this.diag, this.off);
        System.arraycopy(this.diag, 0, this.diagOld, 0, this.smallSide);
        System.arraycopy(this.off, 0, this.offOld, 0, this.smallSide - 1);
        this.qralg.setFastValues(true);
        this.qralg.setUt(null);
        this.qralg.setVt(null);
        boolean bl2 = !this.qralg.process();
        long l3 = System.currentTimeMillis();
        System.out.println("  bidiag " + (l2 - l) + " qr W " + (l3 - l2));
        return bl2;
    }

    private boolean bidiagonalization(DenseMatrix64F denseMatrix64F, boolean bl) {
        if (bl) {
            this.A_mod.reshape(denseMatrix64F.numCols, denseMatrix64F.numRows, false);
            CommonOps.transpose(denseMatrix64F, this.A_mod);
        } else {
            this.A_mod.reshape(denseMatrix64F.numRows, denseMatrix64F.numCols, false);
            this.A_mod.set(denseMatrix64F);
        }
        return !this.bidiag.decompose(this.A_mod);
    }

    private void makeSingularPositive() {
        this.numSingular = this.qralg.getNumberOfSingularValues();
        this.singularValues = this.qralg.getSingularValues();
        for (int i = 0; i < this.numSingular; ++i) {
            double d = this.singularValues[i];
            if (!(d < 0.0)) continue;
            this.singularValues[i] = -d;
            if (!this.computeU) continue;
            int n = i * this.Ut.numCols;
            int n2 = n + this.Ut.numCols;
            for (int j = n; j < n2; ++j) {
                this.Ut.data[j] = -this.Ut.data[j];
            }
        }
    }

    @Override
    public int numRows() {
        return this.numRows;
    }

    @Override
    public int numCols() {
        return this.numCols;
    }
}

