/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.qr;

import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class QrUpdate {
    private DenseMatrix64F Q;
    private DenseMatrix64F R;
    private DenseMatrix64F U_tran;
    private DenseMatrix64F Qm;
    private double[] r_row;
    private int maxCols;
    private int maxRows;
    private int m;
    private int n;
    private int m_m;
    private boolean autoGrow;

    public QrUpdate(int n, int n2) {
        this.autoGrow = false;
        this.declareInternalData(n, n2);
    }

    public QrUpdate(int n, int n2, boolean bl) {
        this.autoGrow = bl;
        this.declareInternalData(n, n2);
    }

    public QrUpdate() {
        this.autoGrow = true;
    }

    public void declareInternalData(int n, int n2) {
        this.maxRows = n;
        this.maxCols = n2;
        this.U_tran = new DenseMatrix64F(n, n);
        this.Qm = new DenseMatrix64F(n, n);
        this.r_row = new double[n2];
    }

    public void addRow(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, double[] dArray, int n, boolean bl) {
        this.setQR(denseMatrix64F, denseMatrix64F2, 1);
        this.m_m = this.m + 1;
        if (denseMatrix64F.data.length < this.m_m * this.m_m) {
            throw new IllegalArgumentException("Q matrix does not have enough data to grow");
        }
        if (bl && denseMatrix64F2.data.length < this.m_m * this.n) {
            throw new IllegalArgumentException("R matrix does not have enough data to grow");
        }
        if (bl) {
            denseMatrix64F2.reshape(this.m_m, this.n, false);
        }
        this.U_tran.reshape(this.m_m, this.m_m, false);
        this.applyFirstGivens(dArray);
        this.applyLaterGivens();
        this.updateInsertQ(n);
        this.R = null;
        this.Q = null;
    }

    public void deleteRow(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, int n, boolean bl) {
        this.setQR(denseMatrix64F, denseMatrix64F2, 0);
        if (this.m - 1 < this.n) {
            throw new IllegalArgumentException("Removing any row would make the system under determined.");
        }
        this.m_m = this.m - 1;
        this.U_tran.reshape(this.m, this.m, false);
        if (bl) {
            denseMatrix64F2.reshape(this.m_m, this.n, false);
        }
        this.computeRemoveGivens(n);
        this.updateRemoveQ(n);
        this.updateRemoveR();
        this.R = null;
        this.Q = null;
    }

    private void setQR(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, int n) {
        if (denseMatrix64F.numRows != denseMatrix64F.numCols) {
            throw new IllegalArgumentException("Q should be square.");
        }
        this.Q = denseMatrix64F;
        this.R = denseMatrix64F2;
        this.m = denseMatrix64F.numRows;
        this.n = denseMatrix64F2.numCols;
        if (this.m + n > this.maxRows || this.n > this.maxCols) {
            if (this.autoGrow) {
                this.declareInternalData(this.m + n, this.n);
            } else {
                throw new IllegalArgumentException("Autogrow has been set to false and the maximum number of rows or columns has been exceeded.");
            }
        }
    }

    private void updateInsertQ(int n) {
        int n2;
        double d;
        int n3;
        int n4;
        this.Qm.set(this.Q);
        this.Q.reshape(this.m_m, this.m_m, false);
        for (n4 = 0; n4 < n; ++n4) {
            for (n3 = 0; n3 < this.m_m; ++n3) {
                d = 0.0;
                for (n2 = 0; n2 < this.m; ++n2) {
                    d += this.Qm.data[n4 * this.m + n2] * this.U_tran.data[n3 * this.m_m + n2 + 1];
                }
                this.Q.data[n4 * this.m_m + n3] = d;
            }
        }
        for (n4 = 0; n4 < this.m_m; ++n4) {
            this.Q.data[n * this.m_m + n4] = this.U_tran.data[n4 * this.m_m];
        }
        for (n4 = n + 1; n4 < this.m_m; ++n4) {
            for (n3 = 0; n3 < this.m_m; ++n3) {
                d = 0.0;
                for (n2 = 0; n2 < this.m; ++n2) {
                    d += this.Qm.data[(n4 - 1) * this.m + n2] * this.U_tran.data[n3 * this.m_m + n2 + 1];
                }
                this.Q.data[n4 * this.m_m + n3] = d;
            }
        }
    }

    private void updateRemoveQ(int n) {
        int n2;
        double d;
        int n3;
        int n4;
        this.Qm.set(this.Q);
        this.Q.reshape(this.m_m, this.m_m, false);
        for (n4 = 0; n4 < n; ++n4) {
            for (n3 = 1; n3 < this.m; ++n3) {
                d = 0.0;
                for (n2 = 0; n2 < this.m; ++n2) {
                    d += this.Qm.data[n4 * this.m + n2] * this.U_tran.data[n3 * this.m + n2];
                }
                this.Q.data[n4 * this.m_m + n3 - 1] = d;
            }
        }
        for (n4 = n + 1; n4 < this.m; ++n4) {
            for (n3 = 1; n3 < this.m; ++n3) {
                d = 0.0;
                for (n2 = 0; n2 < this.m; ++n2) {
                    d += this.Qm.data[n4 * this.m + n2] * this.U_tran.data[n3 * this.m + n2];
                }
                this.Q.data[(n4 - 1) * this.m_m + n3 - 1] = d;
            }
        }
    }

    private void updateRemoveR() {
        for (int i = 1; i < this.n + 1; ++i) {
            for (int j = 0; j < this.n; ++j) {
                double d = 0.0;
                for (int k = i - 1; k <= j; ++k) {
                    d += this.U_tran.data[i * this.m + k] * this.R.data[k * this.n + j];
                }
                this.R.data[(i - 1) * this.n + j] = d;
            }
        }
    }

    private void applyFirstGivens(double[] dArray) {
        double d;
        double d2;
        double d3 = dArray[0];
        double d4 = this.R.data[0];
        double d5 = d3 * d3 + d4 * d4;
        if (d5 != 0.0) {
            d5 = Math.sqrt(d5);
            d2 = d3 / d5;
            d = d4 / d5;
        } else {
            d2 = 1.0;
            d = 0.0;
        }
        this.R.data[0] = d5;
        for (int i = 1; i < this.n; ++i) {
            double d6 = dArray[i];
            double d7 = this.R.data[i];
            this.R.data[i] = d2 * d6 + d * d7;
            this.r_row[i] = d2 * d7 - d * d6;
        }
        CommonOps.setIdentity(this.U_tran);
        this.U_tran.data[0] = d2;
        this.U_tran.data[1] = d;
        this.U_tran.data[this.m_m] = -d;
        this.U_tran.data[this.m_m + 1] = d2;
    }

    private void applyLaterGivens() {
        for (int i = 1; i < this.n; ++i) {
            double d;
            double d2;
            int n;
            double d3;
            double d4;
            double d5 = this.r_row[i];
            double d6 = this.R.data[this.n * i + i];
            double d7 = d5 * d5 + d6 * d6;
            if (d7 != 0.0) {
                d7 = Math.sqrt(d7);
                d4 = d5 / d7;
                d3 = d6 / d7;
            } else {
                d4 = 1.0;
                d3 = 0.0;
            }
            this.R.data[this.n * i + i] = d7;
            for (n = i + 1; n < this.n; ++n) {
                d2 = this.r_row[n];
                d = this.R.data[this.n * i + n];
                this.R.data[this.n * i + n] = d4 * d2 + d3 * d;
                this.r_row[n] = d4 * d - d3 * d2;
            }
            for (n = 0; n <= i + 1; ++n) {
                d2 = this.U_tran.data[i * this.m_m + n];
                d = this.U_tran.data[(i + 1) * this.m_m + n];
                this.U_tran.data[i * this.m_m + n] = d4 * d2 + d3 * d;
                this.U_tran.data[(i + 1) * this.m_m + n] = d4 * d - d3 * d2;
            }
        }
    }

    private void computeRemoveGivens(int n) {
        CommonOps.setIdentity(this.U_tran);
        double d = this.Q.data[n * this.m + this.m - 1];
        for (int i = this.m - 2; i >= 0; --i) {
            double d2;
            double d3;
            double d4 = this.Q.data[n * this.m + i];
            double d5 = d4 * d4 + d * d;
            if (d5 != 0.0) {
                d5 = Math.sqrt(d5);
                d3 = d4 / d5;
                d2 = d / d5;
            } else {
                d3 = 1.0;
                d2 = 0.0;
            }
            d = d5;
            for (int j = i; j < this.m; ++j) {
                double d6 = this.U_tran.data[i * this.m + j];
                double d7 = this.U_tran.data[(i + 1) * this.m + j];
                this.U_tran.data[i * this.m + j] = d3 * d6 + d2 * d7;
                this.U_tran.data[(i + 1) * this.m + j] = d3 * d7 - d2 * d6;
            }
        }
    }

    public DenseMatrix64F getU_tran() {
        return this.U_tran;
    }
}

