/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.chol;

import org.ejml.data.DenseMatrix64F;

class CholeskyBlockHelper_D64 {
    private DenseMatrix64F L;
    private double[] el;

    public CholeskyBlockHelper_D64(int n) {
        this.L = new DenseMatrix64F(n, n);
        this.el = this.L.data;
    }

    public boolean decompose(DenseMatrix64F denseMatrix64F, int n, int n2) {
        double[] dArray = denseMatrix64F.data;
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            for (int j = i; j < n2; ++j) {
                double d2;
                double d3 = dArray[n + i * denseMatrix64F.numCols + j];
                int n3 = i * n2;
                int n4 = j * n2;
                int n5 = n3 + i;
                while (n3 < n5) {
                    d3 -= this.el[n3] * this.el[n4];
                    ++n3;
                    ++n4;
                }
                if (i == j) {
                    double d4;
                    if (d3 <= 0.0) {
                        return false;
                    }
                    this.el[i * n2 + i] = d4 = Math.sqrt(d3);
                    dArray[n + i * denseMatrix64F.numCols + i] = d4;
                    d = 1.0 / d4;
                    continue;
                }
                this.el[j * n2 + i] = d2 = d3 * d;
                dArray[n + j * denseMatrix64F.numCols + i] = d2;
            }
        }
        return true;
    }

    public DenseMatrix64F getL() {
        return this.L;
    }
}

