/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decompose.chol;

import org.ejml.UtilEjml;
import org.ejml.alg.dense.decompose.chol.CholeskyDecompositionCommon_CD64;

public class CholeskyDecompositionInner_CD64
extends CholeskyDecompositionCommon_CD64 {
    double tolerance = UtilEjml.EPS;

    public CholeskyDecompositionInner_CD64() {
        super(true);
    }

    public CholeskyDecompositionInner_CD64(boolean bl) {
        super(bl);
    }

    public void setTolerance(double d) {
        this.tolerance = d;
    }

    @Override
    protected boolean decomposeLower() {
        int n;
        int n2;
        if (this.n == 0) {
            throw new IllegalArgumentException("Cholesky is undefined for 0 by 0 matrix");
        }
        double d = 0.0;
        int n3 = this.n * 2;
        for (n2 = 0; n2 < this.n; ++n2) {
            for (n = n2; n < this.n; ++n) {
                int n4;
                int n5;
                double d2 = this.t[n2 * n3 + n * 2];
                double d3 = this.t[n2 * n3 + n * 2 + 1];
                if (n2 == n) {
                    if (Math.abs(d3) > this.tolerance * Math.abs(d2)) {
                        return false;
                    }
                    n5 = n2 * n3 + n2 * 2;
                    n4 = n2 * n3;
                    while (n4 < n5) {
                        double d4 = this.t[n4++];
                        double d5 = this.t[n4++];
                        d2 -= d4 * d4 + d5 * d5;
                    }
                    if (d2 <= 0.0) {
                        return false;
                    }
                    this.t[n2 * n3 + n2 * 2] = d = Math.sqrt(d2);
                    this.t[n2 * n3 + n2 * 2 + 1] = 0.0;
                    continue;
                }
                n5 = n2 * n3;
                n4 = n * n3;
                int n6 = n5 + n2 * 2;
                while (n5 < n6) {
                    double d6 = this.t[n5++];
                    double d7 = this.t[n5++];
                    double d8 = this.t[n4++];
                    double d9 = this.t[n4++];
                    d2 -= d6 * d8 + d7 * d9;
                    d3 -= d6 * d9 - d8 * d7;
                }
                this.t[n * n3 + n2 * 2] = d2 / d;
                this.t[n * n3 + n2 * 2 + 1] = d3 / d;
            }
        }
        for (n2 = 1; n2 < this.n; ++n2) {
            for (n = 0; n < n2; ++n) {
                this.t[n2 * n3 + n * 2 + 1] = -this.t[n2 * n3 + n * 2 + 1];
            }
        }
        return true;
    }

    @Override
    protected boolean decomposeUpper() {
        if (this.n == 0) {
            throw new IllegalArgumentException("Cholesky is undefined for 0 by 0 matrix");
        }
        double d = 0.0;
        int n = this.n * 2;
        for (int i = 0; i < this.n; ++i) {
            for (int j = i; j < this.n; ++j) {
                double d2;
                double d3;
                int n2;
                double d4 = this.t[i * n + j * 2];
                double d5 = this.t[i * n + j * 2 + 1];
                if (i == j) {
                    if (Math.abs(d5) > this.tolerance * Math.abs(d4)) {
                        return false;
                    }
                    for (n2 = 0; n2 < i; ++n2) {
                        d3 = this.t[n2 * n + i * 2];
                        d2 = this.t[n2 * n + i * 2 + 1];
                        d4 -= d3 * d3 + d2 * d2;
                    }
                    if (d4 <= 0.0) {
                        return false;
                    }
                    this.t[i * n + i * 2] = d = Math.sqrt(d4);
                    this.t[i * n + i * 2 + 1] = 0.0;
                    continue;
                }
                for (n2 = 0; n2 < i; ++n2) {
                    d3 = this.t[n2 * n + i * 2];
                    d2 = this.t[n2 * n + i * 2 + 1];
                    double d6 = this.t[n2 * n + j * 2];
                    double d7 = this.t[n2 * n + j * 2 + 1];
                    d4 -= d3 * d6 + d2 * d7;
                    d5 -= d3 * d7 - d6 * d2;
                }
                this.t[i * n + j * 2] = d4 / d;
                this.t[i * n + j * 2 + 1] = d5 / d;
            }
        }
        return true;
    }
}

