/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.blockd3;

import java.util.Random;
import org.ejml.alg.generic.GenericMatrixOps;
import org.ejml.data.BlockD3Matrix64F;
import org.ejml.data.DenseMatrix64F;

public class BlockD3MatrixOps {
    public static BlockD3Matrix64F convert(DenseMatrix64F denseMatrix64F, int n) {
        BlockD3Matrix64F blockD3Matrix64F = new BlockD3Matrix64F(denseMatrix64F.numRows, denseMatrix64F.numCols, n);
        BlockD3MatrixOps.convert(denseMatrix64F, blockD3Matrix64F);
        return blockD3Matrix64F;
    }

    public static BlockD3Matrix64F convert(DenseMatrix64F denseMatrix64F) {
        BlockD3Matrix64F blockD3Matrix64F = new BlockD3Matrix64F(denseMatrix64F.numRows, denseMatrix64F.numCols);
        BlockD3MatrixOps.convert(denseMatrix64F, blockD3Matrix64F);
        return blockD3Matrix64F;
    }

    public static void convert(DenseMatrix64F denseMatrix64F, BlockD3Matrix64F blockD3Matrix64F) {
        if (denseMatrix64F.numRows != blockD3Matrix64F.numRows || denseMatrix64F.numCols != blockD3Matrix64F.numCols) {
            throw new IllegalArgumentException("Must be the same size.");
        }
        for (int i = 0; i < blockD3Matrix64F.numRows; i += blockD3Matrix64F.blockLength) {
            int n = Math.min(blockD3Matrix64F.blockLength, blockD3Matrix64F.numRows - i);
            for (int j = 0; j < blockD3Matrix64F.numCols; j += blockD3Matrix64F.blockLength) {
                int n2 = Math.min(blockD3Matrix64F.blockLength, blockD3Matrix64F.numCols - j);
                int n3 = i * blockD3Matrix64F.numCols + j;
                double[] dArray = blockD3Matrix64F.blocks[i / blockD3Matrix64F.blockLength][j / blockD3Matrix64F.blockLength];
                int n4 = 0;
                for (int k = 0; k < n; ++k) {
                    int n5 = n3;
                    int n6 = n5 + n2;
                    int n7 = n4;
                    while (n5 != n6) {
                        dArray[n7++] = denseMatrix64F.data[n5++];
                    }
                    n3 += blockD3Matrix64F.numCols;
                    n4 += blockD3Matrix64F.blockLength;
                }
            }
        }
    }

    public static void convert(BlockD3Matrix64F blockD3Matrix64F, DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F.numRows != blockD3Matrix64F.numRows || denseMatrix64F.numCols != blockD3Matrix64F.numCols) {
            throw new IllegalArgumentException("Must be the same size.");
        }
        for (int i = 0; i < blockD3Matrix64F.numRows; i += blockD3Matrix64F.blockLength) {
            int n = Math.min(blockD3Matrix64F.blockLength, blockD3Matrix64F.numRows - i);
            for (int j = 0; j < blockD3Matrix64F.numCols; j += blockD3Matrix64F.blockLength) {
                int n2 = Math.min(blockD3Matrix64F.blockLength, blockD3Matrix64F.numCols - j);
                int n3 = 0;
                int n4 = i * denseMatrix64F.numCols + j;
                double[] dArray = blockD3Matrix64F.blocks[i / blockD3Matrix64F.blockLength][j / blockD3Matrix64F.blockLength];
                for (int k = 0; k < n; ++k) {
                    int n5 = n4;
                    int n6 = n3;
                    int n7 = n6 + n2;
                    while (n6 != n7) {
                        denseMatrix64F.data[n5++] = dArray[n6++];
                    }
                    n4 += denseMatrix64F.numCols;
                    n3 += blockD3Matrix64F.blockLength;
                }
            }
        }
    }

    public static BlockD3Matrix64F random(int n, int n2, double d, double d2, Random random, int n3) {
        BlockD3Matrix64F blockD3Matrix64F = new BlockD3Matrix64F(n, n2, n3);
        GenericMatrixOps.setRandom(blockD3Matrix64F, d, d2, random);
        return blockD3Matrix64F;
    }

    public static void mult(BlockD3Matrix64F blockD3Matrix64F, BlockD3Matrix64F blockD3Matrix64F2, BlockD3Matrix64F blockD3Matrix64F3) {
        if (blockD3Matrix64F.numCols != blockD3Matrix64F2.numRows) {
            throw new IllegalArgumentException("Rows in A are incompatible with columns in B");
        }
        if (blockD3Matrix64F.numRows != blockD3Matrix64F3.numRows) {
            throw new IllegalArgumentException("Rows in A are incompatible with rows in C");
        }
        if (blockD3Matrix64F2.numCols != blockD3Matrix64F3.numCols) {
            throw new IllegalArgumentException("Columns in B are incompatible with columns in C");
        }
        if (blockD3Matrix64F.blockLength != blockD3Matrix64F2.blockLength || blockD3Matrix64F.blockLength != blockD3Matrix64F3.blockLength) {
            throw new IllegalArgumentException("Block lengths are not all the same.");
        }
        int n = blockD3Matrix64F.blockLength;
        for (int i = 0; i < blockD3Matrix64F.numRows; i += n) {
            int n2 = Math.min(n, blockD3Matrix64F.numRows - i);
            int n3 = i / n;
            for (int j = 0; j < blockD3Matrix64F2.numCols; j += n) {
                int n4 = Math.min(n, blockD3Matrix64F2.numCols - j);
                int n5 = j / n;
                double[] dArray = blockD3Matrix64F3.blocks[n3][n5];
                for (int k = 0; k < blockD3Matrix64F.numCols; k += n) {
                    int n6 = Math.min(n, blockD3Matrix64F.numCols - k);
                    int n7 = k / n;
                    double[] dArray2 = blockD3Matrix64F.blocks[n3][n7];
                    double[] dArray3 = blockD3Matrix64F2.blocks[n7][n5];
                    if (k == 0) {
                        BlockD3MatrixOps.multBlockSet(dArray2, dArray3, dArray, n2, n6, n4, n);
                        continue;
                    }
                    BlockD3MatrixOps.multBlockAdd(dArray2, dArray3, dArray, n2, n6, n4, n);
                }
            }
        }
    }

    private static void multBlockAdd(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2, int n3, int n4) {
        for (int i = 0; i < n2; ++i) {
            int n5 = i * n4;
            int n6 = n5 + n3;
            for (int j = 0; j < n; ++j) {
                int n7 = j * n4;
                double d = dArray[n7 + i];
                int n8 = n5;
                while (n8 != n6) {
                    int n9 = n7++;
                    dArray3[n9] = dArray3[n9] + d * dArray2[n8++];
                }
            }
        }
    }

    private static void multBlockSet(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        while (n6 < n) {
            for (int i = 0; i < n3; ++i) {
                double d = 0.0;
                int n7 = i;
                int n8 = n5;
                int n9 = n8 + n2;
                while (n8 != n9) {
                    d += dArray[n8] * dArray2[n7];
                    ++n8;
                    n7 += n4;
                }
                dArray3[n5 + i] = d;
            }
            ++n6;
            n5 += n4;
        }
    }
}

