/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.block.decomposition.chol;

import org.ejml.alg.block.BlockInnerRankUpdate;
import org.ejml.alg.block.BlockMatrixOps;
import org.ejml.alg.block.BlockTriangularSolver;
import org.ejml.alg.block.decomposition.chol.InnerCholesky_B64;
import org.ejml.data.BlockMatrix64F;
import org.ejml.data.Complex64F;
import org.ejml.data.D1Submatrix64F;
import org.ejml.interfaces.decomposition.CholeskyDecomposition;

public class CholeskyOuterForm_B64
implements CholeskyDecomposition<BlockMatrix64F> {
    private boolean lower = false;
    private BlockMatrix64F T;
    private D1Submatrix64F subA = new D1Submatrix64F();
    private D1Submatrix64F subB = new D1Submatrix64F();
    private D1Submatrix64F subC = new D1Submatrix64F();
    private Complex64F det = new Complex64F();

    public CholeskyOuterForm_B64(boolean bl) {
        this.lower = bl;
    }

    @Override
    public boolean decompose(BlockMatrix64F blockMatrix64F) {
        if (blockMatrix64F.numCols != blockMatrix64F.numRows) {
            throw new IllegalArgumentException("A must be square");
        }
        this.T = blockMatrix64F;
        if (this.lower) {
            return this.decomposeLower();
        }
        return this.decomposeUpper();
    }

    private boolean decomposeLower() {
        int n = this.T.blockLength;
        this.subA.set(this.T);
        this.subB.set(this.T);
        this.subC.set(this.T);
        for (int i = 0; i < this.T.numCols; i += n) {
            int n2 = Math.min(n, this.T.numCols - i);
            this.subA.col0 = i;
            this.subA.col1 = i + n2;
            this.subA.row0 = this.subA.col0;
            this.subA.row1 = this.subA.col1;
            this.subB.col0 = i;
            this.subB.col1 = i + n2;
            this.subB.row0 = i + n2;
            this.subB.row1 = this.T.numRows;
            this.subC.col0 = i + n2;
            this.subC.col1 = this.T.numRows;
            this.subC.row0 = i + n2;
            this.subC.row1 = this.T.numRows;
            if (!InnerCholesky_B64.lower(this.subA)) {
                return false;
            }
            if (n2 != n) continue;
            BlockTriangularSolver.solveBlock(n, false, this.subA, this.subB, false, true);
            BlockInnerRankUpdate.symmRankNMinus_L(n, this.subC, this.subB);
        }
        BlockMatrixOps.zeroTriangle(true, this.T);
        return true;
    }

    private boolean decomposeUpper() {
        int n = this.T.blockLength;
        this.subA.set(this.T);
        this.subB.set(this.T);
        this.subC.set(this.T);
        for (int i = 0; i < this.T.numCols; i += n) {
            int n2 = Math.min(n, this.T.numCols - i);
            this.subA.col0 = i;
            this.subA.col1 = i + n2;
            this.subA.row0 = this.subA.col0;
            this.subA.row1 = this.subA.col1;
            this.subB.col0 = i + n2;
            this.subB.col1 = this.T.numCols;
            this.subB.row0 = i;
            this.subB.row1 = i + n2;
            this.subC.col0 = i + n2;
            this.subC.col1 = this.T.numCols;
            this.subC.row0 = i + n2;
            this.subC.row1 = this.T.numCols;
            if (!InnerCholesky_B64.upper(this.subA)) {
                return false;
            }
            if (n2 != n) continue;
            BlockTriangularSolver.solveBlock(n, true, this.subA, this.subB, true, false);
            BlockInnerRankUpdate.symmRankNMinus_U(n, this.subC, this.subB);
        }
        BlockMatrixOps.zeroTriangle(false, this.T);
        return true;
    }

    @Override
    public boolean isLower() {
        return this.lower;
    }

    @Override
    public BlockMatrix64F getT(BlockMatrix64F blockMatrix64F) {
        if (blockMatrix64F == null) {
            return this.T;
        }
        blockMatrix64F.set(this.T);
        return blockMatrix64F;
    }

    @Override
    public Complex64F computeDeterminant() {
        double d = 1.0;
        int n = this.T.blockLength;
        for (int i = 0; i < this.T.numCols; i += n) {
            int n2 = Math.min(n, this.T.numCols - i);
            int n3 = i * this.T.numCols + i * n2;
            for (int j = 0; j < n2; ++j) {
                d *= this.T.data[n3];
                n3 += n2 + 1;
            }
        }
        this.det.real = d * d;
        this.det.imaginary = 0.0;
        return this.det;
    }

    @Override
    public boolean inputModified() {
        return true;
    }
}

