/*
 * Decompiled with CFR 0.152.
 */
package jhpro.engine3d;

import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import jhpro.engine3d.FacetedObject;
import jhpro.engine3d.Object3d;

public class Window3d
extends Panel
implements Runnable {
    private static final long serialVersionUID = 1L;
    private Thread winThread;
    private boolean ready;
    public boolean offScreenOk;
    Image offScreen;
    Graphics offGraphics;
    Dimension offScreenSize;
    Object3d object3d;
    int prevx;
    int prevy;
    float xthetaSum;
    float ythetaSum;
    boolean new_spin_request;
    private static boolean spinDesired = true;
    public static int spinDelay = 20;
    public static Dimension winSize;
    private boolean spinPauseStorageState;
    String modelName;
    int ImageSize;
    static boolean startScreenShown;
    private FacetedObject model = null;

    Window3d() {
        this.winThread = null;
        this.object3d = null;
        this.new_spin_request = false;
        super.resize(300, 300);
    }

    Window3d(int p_ImageSize) {
        this.ImageSize = p_ImageSize;
        winSize = new Dimension(this.ImageSize, this.ImageSize);
        this.ythetaSum = 0.0f;
        this.xthetaSum = 0.0f;
        super.setBackground(Color.white);
        this.modelName = "cam.off";
        super.resize(this.ImageSize, this.ImageSize);
    }

    Window3d(int p_ImageSize, String modelName) {
        this.ImageSize = p_ImageSize;
        winSize = new Dimension(this.ImageSize, this.ImageSize);
        this.ythetaSum = 0.0f;
        this.xthetaSum = 0.0f;
        super.setBackground(Color.white);
        this.modelName = modelName;
    }

    Window3d(int p_ImageSize, FacetedObject model) {
        this.ImageSize = p_ImageSize;
        this.model = model;
        winSize = new Dimension(this.ImageSize, this.ImageSize);
        this.ythetaSum = 0.0f;
        this.xthetaSum = 0.0f;
        super.setBackground(Color.white);
        this.modelName = "not set";
    }

    public void init() {
        super.setBackground(Color.white);
    }

    public void displayStartMessage() {
        Graphics g = super.getGraphics();
        g.setFont(new Font("Helvetica", 1, 20));
        g.drawString("Loading  ... ", 20, 100);
    }

    public void Start() {
        if (this.winThread == null) {
            this.winThread = new Thread(this);
            this.winThread.setPriority(7);
            this.winThread.start();
            this.ready = true;
        }
    }

    public void Stop() {
        this.winThread.stop();
        this.winThread = null;
    }

    public void loadModel(String modelName) {
        if (this.object3d == null) {
            this.object3d = new Object3d(winSize);
        }
        this.object3d.loadModel(modelName);
    }

    public void loadModel(FacetedObject ob) {
        if (this.object3d == null) {
            this.object3d = new Object3d(winSize);
        }
        this.object3d.loadModel(ob);
    }

    @Override
    public void run() {
        while (!this.ready) {
        }
        if (this.model == null) {
            this.loadModel(this.modelName);
        } else {
            this.loadModel(this.model);
        }
        super.repaint();
        this.spin_it();
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (this.winThread != null) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.new_spin_request) continue;
            this.new_spin_request = false;
            this.spin_it();
        }
    }

    public void spin_it() {
        int limit = 100;
        boolean i = false;
        while (spinDesired) {
            this.object3d.spin();
            super.repaint();
            if (spinDelay <= 0) continue;
            try {
                Thread.sleep(spinDelay);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public boolean mouseDown(Event e, int x, int y) {
        this.prevx = x;
        this.prevy = y;
        this.rotatePause();
        return true;
    }

    @Override
    public boolean mouseUp(Event e, int x, int y) {
        this.ythetaSum = 0.0f;
        this.xthetaSum = 0.0f;
        this.rotateResume();
        return true;
    }

    @Override
    public boolean mouseDrag(Event e, int x, int y) {
        float xtheta = (float)(y - this.prevy) * 360.0f / (float)super.size().width;
        float ytheta = (float)(this.prevx - x) * 360.0f / (float)super.size().height;
        this.object3d.setMatrixRotation(xtheta, ytheta);
        if (this.object3d.painted) {
            this.object3d.painted = false;
            super.repaint();
        }
        this.prevx = x;
        this.prevy = y;
        this.xthetaSum += xtheta;
        this.ythetaSum += ytheta;
        return true;
    }

    public boolean rotatePause() {
        this.spinPauseStorageState = spinDesired;
        spinDesired = false;
        return this.spinPauseStorageState;
    }

    public boolean rotateResume() {
        spinDesired = this.spinPauseStorageState;
        this.new_spin_request = this.spinPauseStorageState;
        return this.spinPauseStorageState;
    }

    public boolean commandAction(Event e) {
        if (e.target instanceof Checkbox) {
            boolean b = ((Checkbox)e.target).getState();
            if (b) {
                this.new_spin_request = true;
                spinDesired = true;
            } else {
                spinDesired = false;
            }
            return true;
        }
        return true;
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
        if (this.object3d != null) {
            this.object3d.setPainted();
        }
    }

    private synchronized Image createOffScreenImage(Dimension dim) {
        boolean wantNewOffScreenImage = false;
        if (this.offScreen == null) {
            wantNewOffScreenImage = true;
        } else if (this.offScreenSize.width != dim.width || this.offScreenSize.height != dim.height) {
            wantNewOffScreenImage = true;
        }
        if (wantNewOffScreenImage) {
            this.offScreen = super.createImage(dim.width, dim.height);
            this.offScreenSize = dim;
            this.offGraphics = this.offScreen.getGraphics();
        }
        return this.offScreen;
    }

    @Override
    public synchronized void update(Graphics g) {
        Dimension dim = super.size();
        if (this.offScreen == null) {
            this.createOffScreenImage(dim);
        }
        this.offGraphics.setColor(Color.white);
        this.offGraphics.fillRect(0, 0, dim.width, dim.height);
        if (!startScreenShown) {
            startScreenShown = true;
            this.displayStartMessage();
        } else {
            this.object3d.paintOffscreen(this.offGraphics, dim.width, dim.height);
            g.drawImage(this.offScreen, 0, 0, null);
        }
    }

    static {
        startScreenShown = false;
    }
}

