/*
 * Decompiled with CFR 0.152.
 */
package jhpro.engine3d;

import java.awt.Color;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import jhpro.engine3d.Drawable;
import jhpro.engine3d.FileFetch;
import jhpro.engine3d.Matrix3d;
import jhpro.engine3d.MeshObject;
import jhpro.engine3d.Volume;

public class Model3D
extends MeshObject
implements Drawable {
    float[] vert;
    int[] tvert;
    int nvert;
    int maxvert;
    short[][] con;
    int ncon;
    int maxcon;
    private Volume boundingVolume;
    String modelFilename;
    static Color[] gr;

    Model3D() {
    }

    Model3D(String modelName, int v) throws IOException {
        BufferedReader is;
        this.modelFilename = modelName;
        int polyvert = 0;
        this.nvert = 0;
        try {
            is = FileFetch.openFile(this.modelFilename);
        }
        catch (Exception e) {
            System.out.println("Error ( loadModel ) " + e);
            throw new IOException("load model error: " + e);
        }
        StreamTokenizer st = new StreamTokenizer(is);
        st.whitespaceChars(32, 44);
        st.eolIsSignificant(true);
        st.commentChar(35);
        block7: while (true) {
            switch (st.nextToken()) {
                case 10: {
                    break;
                }
                case -1: {
                    break;
                }
                case -3: {
                    if ("point".equals(st.sval)) {
                        st.nextToken();
                        st.eolIsSignificant(false);
                        double x = 0.0;
                        double y = 0.0;
                        double z = 0.0;
                        polyvert = 0;
                        st.nextToken();
                        while (st.ttype != -3) {
                            if (st.ttype == -2) {
                                x = st.nval;
                                if (st.nextToken() == -2) {
                                    y = st.nval;
                                    if (st.nextToken() == -2) {
                                        z = st.nval;
                                        this.addVert((float)x, (float)y, (float)z);
                                        ++polyvert;
                                    }
                                }
                            }
                            st.nextToken();
                        }
                        st.eolIsSignificant(true);
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block7;
                            st.nextToken();
                        }
                    }
                    if ("coordIndex".equals(st.sval)) {
                        st.nextToken();
                        int n = 0;
                        int prev = 0;
                        int first_vof = 0;
                        boolean starting_face = true;
                        st.eolIsSignificant(false);
                        while (st.nextToken() == -2) {
                            n = (int)st.nval + this.nvert - polyvert + 1;
                            if (starting_face) {
                                starting_face = false;
                                first_vof = n;
                            } else if (st.nval != -1.0) {
                                this.add(prev - 1, n - 1);
                            } else {
                                this.add(prev - 1, first_vof - 1);
                                starting_face = true;
                            }
                            prev = n;
                        }
                        st.eolIsSignificant(true);
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block7;
                            st.nextToken();
                        }
                    }
                    while (st.nextToken() != 10 && st.ttype != -1) {
                    }
                    continue block7;
                }
            }
        }
    }

    Model3D(String modelName) throws IOException {
        BufferedReader is;
        this.modelFilename = modelName;
        try {
            is = FileFetch.openFile(this.modelFilename);
        }
        catch (Exception e) {
            System.out.println("Error ( loadModel ) " + e);
            throw new IOException("load model error: " + e);
        }
        StreamTokenizer st = new StreamTokenizer(is);
        st.eolIsSignificant(true);
        st.commentChar(35);
        while (true) {
            switch (st.nextToken()) {
                default: {
                    break;
                }
                case 10: {
                }
                case -3: 
            }
            if ("v".equals(st.sval)) {
                double x = 0.0;
                double y = 0.0;
                double z = 0.0;
                if (st.nextToken() == -2) {
                    x = st.nval;
                    if (st.nextToken() == -2) {
                        y = st.nval;
                        if (st.nextToken() == -2) {
                            z = st.nval;
                        }
                    }
                }
                this.addVert((float)x, (float)y, (float)z);
                while (st.ttype != 10 && st.ttype != -1) {
                    st.nextToken();
                }
            }
            if ("f".equals(st.sval) || "fo".equals(st.sval) || "l".equals(st.sval)) {
                int start = -1;
                int prev = -1;
                int n = -1;
                while (true) {
                    if (st.nextToken() == -2) {
                        n = (int)st.nval;
                        if (prev >= 0) {
                            this.add(prev - 1, n - 1);
                        }
                        if (start < 0) {
                            start = n;
                        }
                        prev = n;
                    }
                    if (st.ttype != 47) break;
                    st.nextToken();
                }
                if (start >= 0) {
                    this.add(start - 1, prev - 1);
                }
                if (st.ttype != 10) break;
            }
            do {
                if (st.nextToken() != 10) continue;
            } while (st.ttype != -1);
        }
        is.close();
        if (st.ttype != -1) {
            throw new IOException("File parsing error: " + st.toString());
        }
    }

    private int addVert(float x, float y, float z) {
        int i = this.nvert;
        if (i >= this.maxvert) {
            if (this.vert == null) {
                this.maxvert = 100;
                this.vert = new float[this.maxvert * 3];
            } else {
                this.maxvert *= 2;
                float[] nv = new float[this.maxvert * 3];
                System.arraycopy(this.vert, 0, nv, 0, this.vert.length);
                this.vert = nv;
            }
        }
        this.vert[i *= 3] = x;
        this.vert[i + 1] = y;
        this.vert[i + 2] = z;
        return this.nvert++;
    }

    private void add(int p1, int p2) {
        if (p1 >= this.nvert || p2 >= this.nvert) {
            return;
        }
        if (this.ncon >= this.maxcon) {
            if (this.con == null) {
                this.maxcon = 100;
                this.con = new short[this.maxcon][2];
            } else {
                this.maxcon *= 2;
                short[][] nv = new short[this.maxcon][2];
                for (int n = 0; n < this.con.length; ++n) {
                    nv[n][0] = this.con[n][0];
                    nv[n][1] = this.con[n][1];
                }
                this.con = nv;
            }
        }
        if (p1 > p2) {
            int t = p1;
            p1 = p2;
            p2 = t;
        }
        this.con[this.ncon][0] = (short)p1;
        this.con[this.ncon][1] = (short)p2;
        ++this.ncon;
    }

    @Override
    public void transform(Matrix3d mat) {
        if (this.nvert <= 0) {
            return;
        }
        if (this.tvert == null || this.tvert.length < this.nvert * 3) {
            this.tvert = new int[this.nvert * 3];
        }
        mat.transform(this.vert, this.tvert, this.nvert);
    }

    @Override
    public synchronized void Paint(Graphics g) {
        if (this.vert == null || this.nvert <= 0) {
            return;
        }
        if (gr == null) {
            gr = new Color[16];
            for (int i = 0; i < 16; ++i) {
                int grey = (int)(170.0 * (1.0 - Math.pow((double)i / 15.0, 2.3)));
                Model3D.gr[15 - i] = new Color(0, grey, grey);
            }
        }
        int lg = -1;
        if (this.ncon <= 0 || this.nvert <= 0) {
            return;
        }
        for (int i = 0; i < this.ncon; ++i) {
            int p1 = 3 * this.con[i][0];
            int p2 = 3 * this.con[i][1];
            int grey = this.tvert[p1 + 2] + this.tvert[p2 + 2];
            if (grey < 0) {
                grey = 0;
            }
            if (grey > 15) {
                grey = 15;
            }
            if (lg != grey) {
                lg = grey;
                g.setColor(gr[grey]);
            }
            g.drawLine(this.tvert[p1], this.tvert[p1 + 1], this.tvert[p2], this.tvert[p2 + 1]);
        }
    }

    @Override
    public Volume getVolume() {
        return this.boundingVolume;
    }

    @Override
    public Volume determineBoundingBox() {
        this.boundingVolume = Volume.determineBoundingBox(this.vert, this.nvert);
        return this.boundingVolume;
    }

    @Override
    public String toString() {
        String s = "File: \"" + this.modelFilename + "\" has: \n " + this.nvert + " verticies " + this.ncon + " connections ";
        return s;
    }
}

