/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.text.drawable.cells;

import java.awt.Font;
import java.util.List;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.PlaneAxis;
import org.jzy3d.plot3d.primitives.pickable.PickableTexture;
import org.jzy3d.plot3d.primitives.textured.DrawableTexture;
import org.jzy3d.plot3d.rendering.textures.BufferedImageTexture;
import org.jzy3d.plot3d.rendering.textures.SharedTexture;
import org.jzy3d.plot3d.text.drawable.cells.TextCellRenderer;

public class DrawableTextCell
extends PickableTexture {
    protected static Font DEFAULT_FONT = new Font("Serif", 0, 16);

    public DrawableTextCell(int n, String text, Coord2d position, Coord2d dim) {
        super(DrawableTextCell.makeImage(n, text), PlaneAxis.Z, 0.0f, DrawableTextCell.makeMapping(dim), Color.WHITE);
        this.setPlanePosition(position);
    }

    public DrawableTextCell(TextCellRenderer renderer, Coord2d position, Coord2d dim) {
        super(renderer.getImage(), PlaneAxis.Z, 0.0f, DrawableTextCell.makeMapping(dim), Color.WHITE);
        this.setPlanePosition(position);
    }

    public DrawableTextCell(BufferedImageTexture image, Coord2d position, Coord2d dim) {
        this(image, PlaneAxis.Z, 0.0f, DrawableTextCell.makeMapping(dim), Color.WHITE);
        this.setPlanePosition(position);
    }

    public DrawableTextCell(SharedTexture resource, PlaneAxis orientation, float axisValue, List<Coord2d> coords, Color filter) {
        super(resource, orientation, axisValue, coords, filter);
    }

    public void setCellRenderer(TextCellRenderer renderer) {
        this.setResource(renderer.getImage());
    }

    protected static BufferedImageTexture makeImage(int n, String text) {
        return new TextCellRenderer(n, text, DEFAULT_FONT).getImage();
    }

    protected static List<Coord2d> makeMapping(Coord2d dim) {
        return DrawableTexture.getManualTextureMapping(dim.x, dim.y, dim.x / 2.0f, dim.y / 2.0f);
    }
}

