/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.view.annotation;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.TicToc;
import org.jzy3d.plot3d.primitives.LineStrip;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.rendering.view.View;

public class CameraPathAnnotation
extends LineStrip {
    protected View view;
    protected TicToc timer = new TicToc();

    public CameraPathAnnotation(View view, Color color) {
        this.view = view;
        this.setWireframeColor(color);
        this.setWidth(1.0f);
        this.timer.tic();
    }

    @Override
    public void draw(GL gl, GLU glu, Camera cam) {
        this.updateCameraPath();
        super.draw(gl, glu, cam);
    }

    public void updateCameraPath() {
        if (this.timer.toc() > 0.1) {
            Coord3d scaling = this.view.getLastViewScaling();
            Coord3d xyz = this.view.getCamera().getEye().div(scaling);
            Point p = new Point(xyz, this.getWireframeColor());
            this.add(p);
            this.timer.tic();
        }
    }
}

