/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.view;

import org.jzy3d.plot3d.rendering.canvas.ICanvas;
import org.jzy3d.plot3d.rendering.view.ViewportMode;

public class ViewportConfiguration {
    protected int width;
    protected int height;
    protected int x;
    protected int y;
    protected ViewportMode mode;

    public ViewportConfiguration(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public ViewportConfiguration(int width, int height, int x, int y) {
        this.width = width;
        this.height = height;
        this.x = x;
        this.y = y;
    }

    public ViewportConfiguration(ICanvas canvas) {
        this.width = canvas.getRendererWidth();
        this.height = canvas.getRendererHeight();
        this.x = 0;
        this.y = 0;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public float ratio() {
        return (float)this.width / (float)this.height;
    }

    public ViewportMode getMode() {
        return this.mode;
    }

    public void setMode(ViewportMode mode) {
        this.mode = mode;
    }

    public String toString() {
        return "(ViewPort) width=" + this.width + " height=" + this.height + " x=" + this.x + " y=" + this.y;
    }
}

