/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.view;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import org.jzy3d.maths.Rectangle;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.view.ViewportConfiguration;
import org.jzy3d.plot3d.rendering.view.ViewportMode;

public abstract class AbstractViewportManager {
    protected ViewportConfiguration lastViewPort;
    private static final float AREA_LEFT = -100.0f;
    private static final float AREA_RIGHT = 100.0f;
    private static final float AREA_TOP = 100.0f;
    private static final float AREA_DOWN = -100.0f;
    private static final float GRID_STEPS = 10.0f;
    private static final float OFFSET = 0.1f;
    protected int screenLeft = 0;
    protected int screenBottom = 0;
    protected int screenXOffset = 0;
    protected int screenYOffset = 0;
    protected int screenWidth = 0;
    protected int screenHeight = 0;
    protected int screenSquaredDim = 0;
    protected boolean screenGridDisplayed = false;
    protected ViewportMode mode = ViewportMode.RECTANGLE_NO_STRETCH;
    protected float ratioWidth;
    protected float ratioHeight;

    public void setViewPort(int width, int height) {
        this.setViewPort(width, height, 0.0f, 1.0f);
    }

    public ViewportMode getMode() {
        return this.mode;
    }

    public void setViewportMode(ViewportMode mode) {
        this.mode = mode;
    }

    public void setViewPort(int width, int height, float left, float right) {
        if (left >= right) {
            throw new IllegalArgumentException("left must be inferior to right : " + left + " | " + right);
        }
        this.screenWidth = (int)((right - left) * (float)width);
        this.screenHeight = height;
        this.screenLeft = (int)(left * (float)width);
        this.screenBottom = 0;
    }

    public void setViewPort(ViewportConfiguration viewport) {
        this.screenWidth = viewport.getWidth();
        this.screenHeight = viewport.getHeight();
        this.screenLeft = viewport.getX();
        this.screenBottom = viewport.getY();
    }

    public ViewportConfiguration getLastViewPort() {
        return this.lastViewPort;
    }

    protected ViewportConfiguration applyViewport(GL gl, GLU glu) {
        if (ViewportMode.STRETCH_TO_FILL.equals((Object)this.mode) || ViewportMode.RECTANGLE_NO_STRETCH.equals((Object)this.mode)) {
            this.screenXOffset = this.screenLeft;
            this.screenYOffset = 0;
            gl.glViewport(this.screenXOffset, this.screenYOffset, this.screenWidth, this.screenHeight);
            this.lastViewPort = new ViewportConfiguration(this.screenWidth, this.screenHeight, this.screenXOffset, this.screenYOffset);
            this.lastViewPort.setMode(this.mode);
        } else if (ViewportMode.SQUARE.equals((Object)this.mode)) {
            this.screenSquaredDim = Math.min(this.screenWidth, this.screenHeight);
            this.screenXOffset = this.screenLeft + this.screenWidth / 2 - this.screenSquaredDim / 2;
            this.screenYOffset = this.screenBottom + this.screenHeight / 2 - this.screenSquaredDim / 2;
            gl.glViewport(this.screenXOffset, this.screenYOffset, this.screenSquaredDim, this.screenSquaredDim);
            this.lastViewPort = new ViewportConfiguration(this.screenSquaredDim, this.screenSquaredDim, this.screenXOffset, this.screenYOffset);
            this.lastViewPort.setMode(this.mode);
        } else {
            throw new IllegalArgumentException("unknown mode " + (Object)((Object)this.mode));
        }
        if (this.screenGridDisplayed) {
            this.renderSubScreenGrid(gl, glu);
        }
        return this.lastViewPort;
    }

    public Rectangle getRectangle() {
        if (ViewportMode.STRETCH_TO_FILL.equals((Object)this.mode) || ViewportMode.RECTANGLE_NO_STRETCH.equals((Object)this.mode)) {
            return new Rectangle(this.screenXOffset, this.screenYOffset, this.screenWidth, this.screenHeight);
        }
        return new Rectangle(this.screenXOffset, this.screenYOffset, this.screenSquaredDim, this.screenSquaredDim);
    }

    public void setScreenGridDisplayed(boolean status) {
        this.screenGridDisplayed = status;
    }

    protected void renderSubScreenGrid(GL gl, GLU glu) {
        if (this.screenWidth <= 0) {
            return;
        }
        if (!gl.isGL2()) {
            this.renderSubScreenGridGLES(gl, glu);
            return;
        }
        gl.getGL2().glMatrixMode(5889);
        gl.getGL2().glPushMatrix();
        gl.getGL2().glLoadIdentity();
        if (ViewportMode.STRETCH_TO_FILL.equals((Object)this.mode) || ViewportMode.RECTANGLE_NO_STRETCH.equals((Object)this.mode)) {
            int screenXoffset = this.screenLeft;
            int screenYoffset = 0;
            gl.getGL2().glViewport(screenXoffset, screenYoffset, this.screenWidth, this.screenHeight);
        } else {
            int dimension = Math.min(this.screenWidth, this.screenHeight);
            int screenXoffset = this.screenLeft + this.screenWidth / 2 - dimension / 2;
            int screenYoffset = this.screenHeight / 2 - dimension / 2;
            gl.glViewport(screenXoffset, screenYoffset, dimension, dimension);
        }
        gl.getGL2().glOrtho(-100.0, 100.0, -100.0, 100.0, -1.0, 1.0);
        gl.getGL2().glMatrixMode(5888);
        gl.getGL2().glPushMatrix();
        gl.getGL2().glLoadIdentity();
        gl.getGL2().glColor3f(1.0f, 0.5f, 0.5f);
        gl.getGL2().glLineWidth(1.0f);
        float step = 20.0f;
        for (float i = -100.0f; i <= 100.0f; i += step) {
            float x = i;
            if (x == -100.0f) {
                x += 0.1f;
            }
            gl.getGL2().glBegin(1);
            gl.getGL2().glVertex3f(x, -100.0f, 1.0f);
            gl.getGL2().glVertex3f(x, 100.0f, 1.0f);
            gl.getGL2().glEnd();
        }
        step = 20.0f;
        for (float j = -100.0f; j <= 100.0f; j += step) {
            float y = j;
            if (y == 100.0f) {
                y -= 0.1f;
            }
            gl.getGL2().glBegin(1);
            gl.getGL2().glVertex3f(-100.0f, y, 1.0f);
            gl.getGL2().glVertex3f(100.0f, y, 1.0f);
            gl.getGL2().glEnd();
        }
        gl.getGL2().glPopMatrix();
        gl.getGL2().glMatrixMode(5889);
        gl.getGL2().glPopMatrix();
    }

    private void renderSubScreenGridGLES(GL gl, GLU glu) {
        if (this.screenWidth <= 0) {
            return;
        }
        GLES2CompatUtils.glMatrixMode(5889);
        GLES2CompatUtils.glPushMatrix();
        GLES2CompatUtils.glLoadIdentity();
        if (ViewportMode.STRETCH_TO_FILL.equals((Object)this.mode) || ViewportMode.RECTANGLE_NO_STRETCH.equals((Object)this.mode)) {
            int screenXoffset = this.screenLeft;
            int screenYoffset = 0;
            GLES2CompatUtils.glViewport(screenXoffset, screenYoffset, this.screenWidth, this.screenHeight);
        } else {
            int dimension = Math.min(this.screenWidth, this.screenHeight);
            int screenXoffset = this.screenLeft + this.screenWidth / 2 - dimension / 2;
            int screenYoffset = this.screenHeight / 2 - dimension / 2;
            GLES2CompatUtils.glViewport(screenXoffset, screenYoffset, dimension, dimension);
        }
        GLES2CompatUtils.glOrtho(-100.0f, 100.0f, -100.0f, 100.0f, -1.0f, 1.0f);
        GLES2CompatUtils.glMatrixMode(5888);
        GLES2CompatUtils.glPushMatrix();
        GLES2CompatUtils.glLoadIdentity();
        GLES2CompatUtils.glColor3f(1.0f, 0.5f, 0.5f);
        GLES2CompatUtils.glLineWidth(1.0f);
        float step = 20.0f;
        for (float i = -100.0f; i <= 100.0f; i += step) {
            float x = i;
            if (x == -100.0f) {
                x += 0.1f;
            }
            GLES2CompatUtils.glBegin(1);
            GLES2CompatUtils.glVertex3f(x, -100.0f, 1.0f);
            GLES2CompatUtils.glVertex3f(x, 100.0f, 1.0f);
            GLES2CompatUtils.glEnd();
        }
        step = 20.0f;
        for (float j = -100.0f; j <= 100.0f; j += step) {
            float y = j;
            if (y == 100.0f) {
                y -= 0.1f;
            }
            GLES2CompatUtils.glBegin(1);
            GLES2CompatUtils.glVertex3f(-100.0f, y, 1.0f);
            GLES2CompatUtils.glVertex3f(100.0f, y, 1.0f);
            GLES2CompatUtils.glEnd();
        }
        GLES2CompatUtils.glPopMatrix();
        GLES2CompatUtils.glMatrixMode(5889);
        GLES2CompatUtils.glPopMatrix();
    }
}

