/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.view;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import java.awt.Image;
import java.nio.ByteBuffer;
import org.jzy3d.maths.Dimension;
import org.jzy3d.plot3d.rendering.image.GLImage;
import org.jzy3d.plot3d.rendering.view.AbstractViewportManager;
import org.jzy3d.plot3d.rendering.view.IImageViewport;
import org.jzy3d.plot3d.rendering.view.ImageRenderer;
import org.jzy3d.plot3d.rendering.view.ViewportMode;

public class AWTImageViewport
extends AbstractViewportManager
implements IImageViewport {
    private ByteBuffer imageData = null;
    protected Image imageObj;
    protected int imageHeight;
    protected int imageWidth;

    public AWTImageViewport() {
        this.setViewportMode(ViewportMode.RECTANGLE_NO_STRETCH);
    }

    @Override
    public void render(GL gl, GLU glu) {
        if (gl.isGL2()) {
            gl.getGL2().glMatrixMode(5889);
            gl.getGL2().glPushMatrix();
            gl.getGL2().glLoadIdentity();
            this.applyViewport(gl, glu);
            gl.getGL2().glOrtho(0.0, this.screenWidth, 0.0, this.screenHeight, -1.0, 1.0);
            gl.getGL2().glMatrixMode(5888);
            gl.getGL2().glPushMatrix();
            gl.getGL2().glLoadIdentity();
            ImageRenderer.renderImage(gl, this.imageData, this.imageWidth, this.imageHeight, this.screenWidth, this.screenHeight, -0.75f);
            gl.getGL2().glPopMatrix();
            gl.getGL2().glMatrixMode(5889);
            gl.getGL2().glPopMatrix();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(Image image, int width, int height) {
        if (image != null) {
            Image image2 = image;
            synchronized (image2) {
                ByteBuffer b = GLImage.getImageAsGlByteBuffer(image, width, height);
                this.setImage(image, width, height, b);
            }
        }
    }

    public void setImage(Image image, int width, int height, ByteBuffer buffer) {
        this.imageObj = image;
        this.imageHeight = height;
        this.imageWidth = width;
        this.imageData = buffer;
    }

    public void setImage(Image image) {
        if (image != null) {
            this.setImage(image, image.getWidth(null), image.getHeight(null));
        }
    }

    public Image getImage() {
        return this.imageObj;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getPreferedSize() {
        return new Dimension(1, 1);
    }
}

