/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.scene;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import java.util.ArrayList;
import java.util.List;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.TicToc;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.IGLBindedResource;
import org.jzy3d.plot3d.primitives.selectable.Selectable;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.legends.ILegend;
import org.jzy3d.plot3d.rendering.ordering.AbstractOrderingStrategy;
import org.jzy3d.plot3d.rendering.ordering.DefaultOrderingStrategy;
import org.jzy3d.plot3d.rendering.scene.Decomposition;
import org.jzy3d.plot3d.rendering.scene.Scene;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.rendering.view.View;
import org.jzy3d.plot3d.transform.Transform;

public class Graph {
    protected TicToc t = new TicToc();
    protected List<AbstractDrawable> components;
    protected Scene scene;
    protected Transform transform;
    protected boolean VERBOSE = false;
    protected AbstractOrderingStrategy strategy;
    protected boolean sort = true;

    public Graph(Scene scene) {
        this(scene, new DefaultOrderingStrategy(), true);
    }

    public Graph(Scene scene, boolean sort) {
        this(scene, new DefaultOrderingStrategy(), sort);
    }

    public Graph(Scene scene, AbstractOrderingStrategy strategy) {
        this(scene, strategy, true);
    }

    public Graph(Scene scene, AbstractOrderingStrategy strategy, boolean sort) {
        this.scene = scene;
        this.strategy = strategy;
        this.sort = sort;
        this.components = new ArrayList<AbstractDrawable>();
    }

    public synchronized void dispose() {
        for (AbstractDrawable c : this.components) {
            if (c == null) continue;
            c.dispose();
        }
        this.components.clear();
        this.scene = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AbstractDrawable drawable, boolean updateViews) {
        Graph graph = this;
        synchronized (graph) {
            this.components.add(drawable);
        }
        if (updateViews) {
            for (View view : this.scene.views) {
                view.updateBounds();
            }
        }
    }

    public void add(AbstractDrawable drawable) {
        this.add(drawable, true);
    }

    public void add(List<? extends AbstractDrawable> drawables, boolean updateViews) {
        for (AbstractDrawable abstractDrawable : drawables) {
            this.add(abstractDrawable, false);
        }
        if (updateViews) {
            for (View view : this.scene.views) {
                view.updateBounds();
            }
        }
    }

    public void add(List<? extends AbstractDrawable> drawables) {
        this.add(drawables, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(AbstractDrawable drawable, boolean updateViews) {
        boolean output = false;
        Graph graph = this;
        synchronized (graph) {
            output = this.components.remove(drawable);
        }
        BoundingBox3d bbox = this.getBounds();
        for (View view : this.scene.views) {
            view.lookToBox(bbox);
            if (!updateViews) continue;
            view.shoot();
        }
        return output;
    }

    public boolean remove(AbstractDrawable drawable) {
        return this.remove(drawable, true);
    }

    public List<AbstractDrawable> getAll() {
        return this.components;
    }

    public synchronized List<IGLBindedResource> getAllGLBindedResources() {
        ArrayList<IGLBindedResource> out = new ArrayList<IGLBindedResource>();
        for (AbstractDrawable c : this.components) {
            if (!(c instanceof IGLBindedResource)) continue;
            out.add((IGLBindedResource)((Object)c));
        }
        return out;
    }

    public void mountAllGLBindedResources(GL gl) {
        List<IGLBindedResource> all = this.getAllGLBindedResources();
        for (IGLBindedResource r : all) {
            if (r.hasMountedOnce()) continue;
            r.mount(gl);
        }
    }

    public void draw(GL gl, GLU glu, Camera camera) {
        this.draw(gl, glu, camera, this.components, this.sort);
    }

    protected synchronized void draw(GL gl, GLU glu, Camera camera, List<AbstractDrawable> components, boolean sort) {
        this.glMatrixMode(gl);
        if (!sort) {
            this.drawSimple(gl, glu, camera, components);
        } else {
            this.drawDecomposition(gl, glu, camera);
        }
    }

    public void glMatrixMode(GL gl) {
        if (gl.isGL2()) {
            gl.getGL2().glMatrixMode(5888);
        } else {
            GLES2CompatUtils.glMatrixMode(5888);
        }
    }

    public void drawSimple(GL gl, GLU glu, Camera camera, List<AbstractDrawable> components) {
        for (AbstractDrawable d : components) {
            if (!d.isDisplayed()) continue;
            d.draw(gl, glu, camera);
        }
    }

    public void drawDecomposition(GL gl, GLU glu, Camera camera) {
        List<AbstractDrawable> monotypes = this.getDecomposition();
        this.strategy.sort(monotypes, camera);
        for (AbstractDrawable d : monotypes) {
            if (!d.isDisplayed()) continue;
            d.draw(gl, glu, camera);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbstractDrawable> getDecomposition() {
        ArrayList<AbstractDrawable> monotypes;
        List<AbstractDrawable> list = this.components;
        synchronized (list) {
            monotypes = Decomposition.getDecomposition(this.components);
        }
        return monotypes;
    }

    public synchronized void project(GL gl, GLU glu, Camera camera) {
        for (AbstractDrawable d : this.components) {
            if (!(d instanceof Selectable)) continue;
            ((Selectable)((Object)d)).project(gl, glu, camera);
        }
    }

    public AbstractOrderingStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(AbstractOrderingStrategy strategy) {
        this.strategy = strategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setTransform(Transform transform) {
        this.transform = transform;
        List<AbstractDrawable> list = this.components;
        synchronized (list) {
            for (AbstractDrawable c : this.components) {
                if (c == null) continue;
                c.setTransform(transform);
            }
        }
    }

    public Transform getTransform() {
        return this.transform;
    }

    public synchronized BoundingBox3d getBounds() {
        if (this.components.size() == 0) {
            return new BoundingBox3d(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
        BoundingBox3d box = new BoundingBox3d();
        for (AbstractDrawable c : this.components) {
            BoundingBox3d drawableBounds;
            if (c == null || c.getBounds() == null || (drawableBounds = c.getBounds()).isReset()) continue;
            box.add(drawableBounds);
        }
        return box;
    }

    public synchronized List<ILegend> getLegends() {
        ArrayList<ILegend> list = new ArrayList<ILegend>();
        for (AbstractDrawable c : this.components) {
            if (c == null || !c.hasLegend() || !c.isLegendDisplayed()) continue;
            list.add(c.getLegend());
        }
        return list;
    }

    public synchronized int hasLegends() {
        int k = 0;
        for (AbstractDrawable c : this.components) {
            if (c == null || !c.hasLegend() || !c.isLegendDisplayed()) continue;
            ++k;
        }
        return k;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String toString() {
        String output = "(Graph) #elements:" + this.components.size() + ":\n";
        int k = 0;
        List<AbstractDrawable> list = this.components;
        synchronized (list) {
            for (AbstractDrawable c : this.components) {
                if (c != null) {
                    output = output + " Graph element [" + k++ + "]:" + c.toString(1) + "\n";
                    continue;
                }
                output = output + " Graph element [" + k++ + "] (null)\n";
            }
        }
        return output;
    }

    public boolean isSort() {
        return this.sort;
    }

    public void setSort(boolean sort) {
        this.sort = sort;
    }

    public Scene getScene() {
        return this.scene;
    }
}

