/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.lights;

import com.jogamp.opengl.GL;
import java.util.ArrayList;
import java.util.List;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.rendering.lights.Light;
import org.jzy3d.plot3d.rendering.lights.LightSwitch;

public class LightSet {
    protected List<Light> lights;
    protected boolean lazyLightInit = false;

    public LightSet() {
        this.lights = new ArrayList<Light>();
    }

    public LightSet(List<Light> lights) {
        this.lights = lights;
    }

    public void init(GL gl) {
        gl.glEnable(2903);
    }

    public void apply(GL gl, Coord3d scale) {
        if (this.lazyLightInit) {
            this.initLight(gl);
            for (Light light : this.lights) {
                LightSwitch.enable(gl, light.getId());
            }
            this.lazyLightInit = false;
        }
        for (Light light : this.lights) {
            light.apply(gl, scale);
        }
    }

    public void enableLightIfThereAreLights(GL gl) {
        this.enable(gl, true);
    }

    public void enable(GL gl, boolean onlyIfAtLeastOneLight) {
        if (onlyIfAtLeastOneLight) {
            if (this.lights.size() > 0) {
                gl.glEnable(2896);
            }
        } else {
            gl.glEnable(2896);
        }
    }

    public void disable(GL gl) {
        gl.glDisable(2896);
    }

    public Light get(int id) {
        return this.lights.get(id);
    }

    public void add(Light light) {
        if (this.lights.size() == 0) {
            this.queryLazyLightInit();
        }
        this.lights.add(light);
    }

    public void remove(Light light) {
        this.lights.remove(light);
    }

    protected void queryLazyLightInit() {
        this.lazyLightInit = true;
    }

    protected void initLight(GL gl) {
        gl.glEnable(2903);
        gl.glEnable(2896);
        if (gl.isGL2()) {
            gl.getGL2().glLightModeli(2898, 1);
        }
    }
}

