/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.log;

import com.jogamp.opengl.GL;
import java.util.ArrayList;
import java.util.List;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.LightPoint;
import org.jzy3d.plot3d.primitives.ScatterPoint;
import org.jzy3d.plot3d.primitives.log.GlVertexExecutor;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.transform.space.SpaceTransformer;

public class AxeTransformableScatterPoint
extends ScatterPoint {
    SpaceTransformer transformers;

    public AxeTransformableScatterPoint(SpaceTransformer transformers) {
        this.bbox = new BoundingBox3d();
        this.setWidth(1.0f);
        this.setPoints(new ArrayList<LightPoint>());
        this.transformers = transformers;
    }

    public AxeTransformableScatterPoint(List<LightPoint> points, float width, SpaceTransformer transformers) {
        this.bbox = new BoundingBox3d();
        this.setPoints(points);
        this.setWidth(width);
        this.transformers = transformers;
    }

    @Override
    public void drawGLES2() {
        GLES2CompatUtils.glPointSize(this.width);
        GLES2CompatUtils.glBegin(0);
        if (this.points != null) {
            for (LightPoint p : this.points) {
                GLES2CompatUtils.glColor4f(p.rgb.r, p.rgb.g, p.rgb.b, p.rgb.a);
                GLES2CompatUtils.glVertex3f(this.transformers.getX().compute(p.xyz.x), this.transformers.getY().compute(p.xyz.y), this.transformers.getZ().compute(p.xyz.z));
            }
        }
        GLES2CompatUtils.glEnd();
    }

    @Override
    public void drawGL2(GL gl) {
        gl.getGL2().glPointSize(this.width);
        gl.getGL2().glBegin(0);
        if (this.points != null) {
            for (LightPoint p : this.points) {
                gl.getGL2().glColor4f(p.rgb.r, p.rgb.g, p.rgb.b, p.rgb.a);
                GlVertexExecutor.Vertex(gl, new Coord3d(p.xyz.x, p.xyz.y, p.xyz.z), this.transformers);
            }
        }
        gl.getGL2().glEnd();
    }

    @Override
    public void updateBounds() {
        this.bbox.reset();
        for (LightPoint c : this.points) {
            this.bbox.add(this.transformers.compute(c.xyz));
        }
    }
}

