/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.log;

import java.util.List;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.algorithms.interpolation.IInterpolator;
import org.jzy3d.plot3d.primitives.LineStripInterpolated;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.primitives.log.AxeTransformableLineStrip;
import org.jzy3d.plot3d.primitives.log.AxeTransformablePoint;
import org.jzy3d.plot3d.transform.space.SpaceTransformer;

public class AxeTransformableLineStripInterpolated
extends LineStripInterpolated {
    SpaceTransformer transformers;

    public AxeTransformableLineStripInterpolated(IInterpolator interpolator, List<Coord3d> controlPoints, int resolution, SpaceTransformer transformers) {
        this.transformers = transformers;
        this.controlCoords = controlPoints;
        this.resolution = resolution;
        this.interpolatedCoords = interpolator.interpolate(controlPoints, resolution);
        this.interpolatedPoints = this.toPoints(this.interpolatedCoords, Color.BLUE, 3.0f);
        this.controlPoints = this.toPoints(this.controlCoords, Color.RED, 5.0f);
        this.line = new AxeTransformableLineStrip(this.interpolatedCoords, transformers);
        this.line.setWireframeColor(Color.BLACK);
        this.add(this.line);
        this.add(this.controlPoints);
        this.add(this.interpolatedPoints);
    }

    @Override
    protected Point toPoint(Coord3d coord, Color color, float width) {
        return new AxeTransformablePoint(coord, color, width, this.transformers);
    }
}

