/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.log;

import com.jogamp.opengl.GL;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.ConcurrentScatterMultiColor;
import org.jzy3d.plot3d.primitives.log.GlVertexExecutor;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.transform.space.SpaceTransformer;

public class AxeTransformableConcurrentScatterMultiColor
extends ConcurrentScatterMultiColor {
    SpaceTransformer transformers;

    public AxeTransformableConcurrentScatterMultiColor(Coord3d[] coordinates, Color[] colors, ColorMapper mapper, SpaceTransformer transformers) {
        this(coordinates, colors, mapper, 1.0f, transformers);
    }

    public AxeTransformableConcurrentScatterMultiColor(Coord3d[] coordinates, ColorMapper mapper, SpaceTransformer transformers) {
        this(coordinates, null, mapper, 1.0f, transformers);
    }

    public AxeTransformableConcurrentScatterMultiColor(Coord3d[] coordinates, Color[] colors, ColorMapper mapper, float width, SpaceTransformer transformers) {
        super(coordinates, colors, mapper, width);
        this.transformers = transformers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void drawGLES2() {
        GLES2CompatUtils.glPointSize(this.width);
        GLES2CompatUtils.glBegin(0);
        if (this.coordinates != null) {
            Coord3d[] coord3dArray = this.coordinates;
            // MONITORENTER : this.coordinates
            for (Coord3d coord : this.coordinates) {
                Color color = this.mapper.getColor(coord);
                GLES2CompatUtils.glColor4f(color.r, color.g, color.b, color.a);
                GLES2CompatUtils.glVertex3f(this.transformers.getX().compute(coord.x), this.transformers.getY().compute(coord.y), this.transformers.getZ().compute(coord.z));
            }
            // MONITOREXIT : coord3dArray
        }
        GLES2CompatUtils.glEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void drawGL2(GL gl) {
        gl.getGL2().glPointSize(this.width);
        gl.getGL2().glBegin(0);
        if (this.coordinates != null) {
            Coord3d[] coord3dArray = this.coordinates;
            // MONITORENTER : this.coordinates
            for (Coord3d coord : this.coordinates) {
                Color color = this.mapper.getColor(coord);
                gl.getGL2().glColor4f(color.r, color.g, color.b, color.a);
                GlVertexExecutor.Vertex(gl, new Coord3d(coord.x, coord.y, coord.z), this.transformers);
            }
            // MONITOREXIT : coord3dArray
        }
        gl.getGL2().glEnd();
    }
}

