/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.axes;

import com.jogamp.opengl.GL;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.Range;
import org.jzy3d.plot3d.primitives.axes.AxeAnnotation;
import org.jzy3d.plot3d.primitives.axes.AxeBox;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;

public class AxeYLineAnnotation
implements AxeAnnotation {
    protected float value;
    protected Color color = Color.RED;
    protected float width = 3.0f;

    @Override
    public void draw(GL gl, AxeBox axe) {
        Range xrange = axe.getBoxBounds().getXRange();
        Range zrange = axe.getBoxBounds().getYRange();
        if (gl.isGL2()) {
            this.drawLineGL2(gl, xrange, zrange);
        } else {
            this.drawLineGLES2(xrange, zrange);
        }
    }

    public void drawLineGLES2(Range yrange, Range zrange) {
        GLES2CompatUtils.glBegin(3);
        GLES2CompatUtils.glLineWidth(this.width);
        GLES2CompatUtils.glColor4f(this.color.r, this.color.g, this.color.b, this.color.a);
        GLES2CompatUtils.glVertex3f(this.value, yrange.getMin(), 0.0f);
        GLES2CompatUtils.glVertex3f(this.value, yrange.getMax(), 0.0f);
        GLES2CompatUtils.glEnd();
    }

    public synchronized void drawLineGL2(GL gl, Range yrange, Range zrange) {
        gl.getGL2().glLineWidth(this.width);
        gl.getGL2().glBegin(3);
        gl.getGL2().glColor4f(this.color.r, this.color.g, this.color.b, this.color.a);
        gl.getGL2().glVertex3f(this.value, yrange.getMin() - yrange.getRange() / 30.0f, zrange.getMin() - 2.0f);
        gl.getGL2().glVertex3f(this.value, yrange.getMax() + yrange.getRange() / 30.0f, zrange.getMin() - 2.0f);
        gl.getGL2().glEnd();
    }

    public synchronized float getValue() {
        return this.value;
    }

    public synchronized void setValue(float value) {
        this.value = value;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }
}

