/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.colors.IMultiColorable;
import org.jzy3d.events.DrawableChangedEvent;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.transform.Transform;

public class ScatterMultiColor
extends AbstractDrawable
implements IMultiColorable {
    protected Coord3d[] coordinates;
    protected Color[] colors;
    protected float width;
    protected ColorMapper mapper;

    public ScatterMultiColor(Coord3d[] coordinates, Color[] colors, ColorMapper mapper) {
        this(coordinates, colors, mapper, 1.0f);
    }

    public ScatterMultiColor(Coord3d[] coordinates, ColorMapper mapper) {
        this(coordinates, null, mapper, 1.0f);
    }

    public ScatterMultiColor(Coord3d[] coordinates, Color[] colors, ColorMapper mapper, float width) {
        this.bbox = new BoundingBox3d();
        this.setData(coordinates);
        this.setColors(colors);
        this.setWidth(width);
        this.setColorMapper(mapper);
    }

    public void clear() {
        this.coordinates = null;
        this.bbox.reset();
    }

    @Override
    public void draw(GL gl, GLU glu, Camera cam) {
        this.doTransform(gl, glu, cam);
        if (gl.isGL2()) {
            this.drawGL2(gl);
        } else {
            this.drawGLES2();
        }
        this.doDrawBounds(gl, glu, cam);
    }

    public void drawGLES2() {
        GLES2CompatUtils.glPointSize(this.width);
        GLES2CompatUtils.glBegin(0);
        if (this.coordinates != null) {
            for (Coord3d coord : this.coordinates) {
                Color color = this.mapper.getColor(coord);
                GLES2CompatUtils.glColor4f(color.r, color.g, color.b, color.a);
                GLES2CompatUtils.glVertex3f(coord.x, coord.y, coord.z);
            }
        }
        GLES2CompatUtils.glEnd();
    }

    public void drawGL2(GL gl) {
        gl.getGL2().glPointSize(this.width);
        gl.getGL2().glBegin(0);
        if (this.coordinates != null) {
            for (Coord3d coord : this.coordinates) {
                Color color = this.mapper.getColor(coord);
                gl.getGL2().glColor4f(color.r, color.g, color.b, color.a);
                gl.getGL2().glVertex3f(coord.x, coord.y, coord.z);
            }
        }
        gl.getGL2().glEnd();
    }

    @Override
    public void applyGeometryTransform(Transform transform) {
        for (Coord3d c : this.coordinates) {
            c.set(transform.compute(c));
        }
        this.updateBounds();
    }

    @Override
    public void updateBounds() {
        this.bbox.reset();
        for (Coord3d c : this.coordinates) {
            this.bbox.add(c);
        }
    }

    public void setData(Coord3d[] coordinates) {
        this.coordinates = coordinates;
        this.bbox.reset();
        for (Coord3d c : coordinates) {
            this.bbox.add(c);
        }
    }

    public Coord3d[] getData() {
        return this.coordinates;
    }

    public void setColors(Color[] colors) {
        this.colors = colors;
        this.fireDrawableChanged(new DrawableChangedEvent(this, 2));
    }

    @Override
    public ColorMapper getColorMapper() {
        return this.mapper;
    }

    @Override
    public void setColorMapper(ColorMapper mapper) {
        this.mapper = mapper;
    }

    public void setWidth(float width) {
        this.width = width;
    }
}

