/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ISingleColorable;
import org.jzy3d.events.DrawableChangedEvent;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.transform.Transform;

public class Scatter
extends AbstractDrawable
implements ISingleColorable {
    public Color[] colors;
    public Coord3d[] coordinates;
    public Color rgb;
    public float width;

    public Scatter() {
        this.bbox = new BoundingBox3d();
        this.setWidth(1.0f);
        this.setColor(Color.BLACK);
    }

    public Scatter(Coord3d[] coordinates) {
        this(coordinates, Color.BLACK);
    }

    public Scatter(Coord3d[] coordinates, Color rgb) {
        this(coordinates, rgb, 1.0f);
    }

    public Scatter(Coord3d[] coordinates, Color rgb, float width) {
        this.bbox = new BoundingBox3d();
        this.setData(coordinates);
        this.setWidth(width);
        this.setColor(rgb);
    }

    public Scatter(Coord3d[] coordinates, Color[] colors) {
        this(coordinates, colors, 1.0f);
    }

    public Scatter(Coord3d[] coordinates, Color[] colors, float width) {
        this.bbox = new BoundingBox3d();
        this.setData(coordinates);
        this.setWidth(width);
        this.setColors(colors);
    }

    public void clear() {
        this.coordinates = null;
        this.bbox.reset();
    }

    @Override
    public void draw(GL gl, GLU glu, Camera cam) {
        this.doTransform(gl, glu, cam);
        if (gl.isGL2()) {
            this.drawGL2(gl);
        } else {
            this.drawGLES2();
        }
        this.doDrawBounds(gl, glu, cam);
    }

    public void drawGLES2() {
        GLES2CompatUtils.glPointSize(this.width);
        GLES2CompatUtils.glBegin(0);
        if (this.colors == null) {
            GLES2CompatUtils.glColor4f(this.rgb.r, this.rgb.g, this.rgb.b, this.rgb.a);
        }
        if (this.coordinates != null) {
            int k = 0;
            for (Coord3d c : this.coordinates) {
                if (this.colors != null) {
                    GLES2CompatUtils.glColor4f(this.colors[k].r, this.colors[k].g, this.colors[k].b, this.colors[k].a);
                    ++k;
                }
                GLES2CompatUtils.glVertex3f(c.x, c.y, c.z);
            }
        }
        GLES2CompatUtils.glEnd();
    }

    public void drawGL2(GL gl) {
        gl.getGL2().glPointSize(this.width);
        gl.getGL2().glBegin(0);
        if (this.colors == null) {
            gl.getGL2().glColor4f(this.rgb.r, this.rgb.g, this.rgb.b, this.rgb.a);
        }
        if (this.coordinates != null) {
            int k = 0;
            for (Coord3d c : this.coordinates) {
                if (this.colors != null) {
                    gl.getGL2().glColor4f(this.colors[k].r, this.colors[k].g, this.colors[k].b, this.colors[k].a);
                    ++k;
                }
                gl.getGL2().glVertex3f(c.x, c.y, c.z);
            }
        }
        gl.getGL2().glEnd();
    }

    @Override
    public void applyGeometryTransform(Transform transform) {
        for (Coord3d c : this.coordinates) {
            c.set(transform.compute(c));
        }
        this.updateBounds();
    }

    public void setData(Coord3d[] coordinates) {
        this.coordinates = coordinates;
        this.updateBounds();
    }

    @Override
    public void updateBounds() {
        this.bbox.reset();
        for (Coord3d c : this.coordinates) {
            this.bbox.add(c);
        }
    }

    public Coord3d[] getData() {
        return this.coordinates;
    }

    public void setColors(Color[] colors) {
        this.colors = colors;
        this.fireDrawableChanged(new DrawableChangedEvent(this, 2));
    }

    @Override
    public void setColor(Color color) {
        this.rgb = color;
        this.fireDrawableChanged(new DrawableChangedEvent(this, 2));
    }

    @Override
    public Color getColor() {
        return this.rgb;
    }

    public void setWidth(float width) {
        this.width = width;
    }
}

